/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.io;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Attributes$InputBuffer$;
import org.apache.pekko.stream.IOOperationIncompleteException;
import org.apache.pekko.stream.IOResult;
import org.apache.pekko.stream.IOResult$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.SourceShape;
import org.apache.pekko.stream.SourceShape$;
import org.apache.pekko.stream.SubscriptionWithCancelException;
import org.apache.pekko.stream.impl.io.FileSource$;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.GraphStageWithMaterializedValue;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Vector;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Failure$;
import scala.util.Success$;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class FileSource
extends GraphStageWithMaterializedValue<SourceShape<ByteString>, Future<IOResult>> {
    public final Path org$apache$pekko$stream$impl$io$FileSource$$path;
    public final int org$apache$pekko$stream$impl$io$FileSource$$chunkSize;
    public final long org$apache$pekko$stream$impl$io$FileSource$$startPosition;
    private final Outlet out;
    private final SourceShape shape;

    public static CompletionHandler<Integer, Function1<Try<Object>, BoxedUnit>> completionHandler() {
        return FileSource$.MODULE$.completionHandler();
    }

    public FileSource(Path path, int chunkSize, long startPosition) {
        this.org$apache$pekko$stream$impl$io$FileSource$$path = path;
        this.org$apache$pekko$stream$impl$io$FileSource$$chunkSize = chunkSize;
        this.org$apache$pekko$stream$impl$io$FileSource$$startPosition = startPosition;
        Predef$.MODULE$.require(chunkSize > 0, FileSource::$init$$$anonfun$1);
        this.out = Outlet$.MODULE$.apply("FileSource.out");
        this.shape = SourceShape$.MODULE$.apply(this.out());
    }

    public Outlet<ByteString> out() {
        return this.out;
    }

    @Override
    public SourceShape<ByteString> shape() {
        return this.shape;
    }

    @Override
    public Tuple2<GraphStageLogic, Future<IOResult>> createLogicAndMaterializedValue(Attributes inheritedAttributes) {
        Promise ioResultPromise = Promise$.MODULE$.apply();
        OutHandler logic = new OutHandler(inheritedAttributes, ioResultPromise, this){
            private final Promise ioResultPromise$2;
            private final ByteBuffer buffer;
            private final int maxReadAhead;
            private FileChannel channel;
            private long position;
            private Function1 chunkCallback;
            private boolean eofEncountered;
            private Vector availableChunks;
            private final /* synthetic */ FileSource $outer;
            {
                this.ioResultPromise$2 = ioResultPromise$1;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.shape());
                this.buffer = ByteBuffer.allocate($outer.org$apache$pekko$stream$impl$io$FileSource$$chunkSize);
                this.maxReadAhead = inheritedAttributes$1.get(Attributes$InputBuffer$.MODULE$.apply(16, 16), ClassTag$.MODULE$.apply(Attributes.InputBuffer.class)).max();
                this.position = $outer.org$apache$pekko$stream$impl$io$FileSource$$startPosition;
                this.eofEncountered = false;
                this.availableChunks = package$.MODULE$.Vector().empty();
                this.setHandler($outer.out(), this);
            }

            public ByteBuffer buffer() {
                return this.buffer;
            }

            public int maxReadAhead() {
                return this.maxReadAhead;
            }

            public FileChannel channel() {
                return this.channel;
            }

            public void channel_$eq(FileChannel x$1) {
                this.channel = x$1;
            }

            public long position() {
                return this.position;
            }

            public void position_$eq(long x$1) {
                this.position = x$1;
            }

            public Function1 chunkCallback() {
                return this.chunkCallback;
            }

            public void chunkCallback_$eq(Function1 x$1) {
                this.chunkCallback = x$1;
            }

            public boolean eofEncountered() {
                return this.eofEncountered;
            }

            public void eofEncountered_$eq(boolean x$1) {
                this.eofEncountered = x$1;
            }

            public Vector availableChunks() {
                return this.availableChunks;
            }

            public void availableChunks_$eq(Vector x$1) {
                this.availableChunks = x$1;
            }

            public void preStart() {
                try {
                    if (!Files.exists(this.$outer.org$apache$pekko$stream$impl$io$FileSource$$path, new LinkOption[0])) {
                        throw new NoSuchFileException(this.$outer.org$apache$pekko$stream$impl$io$FileSource$$path.toString());
                    }
                    Predef$.MODULE$.require(!Files.isDirectory(this.$outer.org$apache$pekko$stream$impl$io$FileSource$$path, new LinkOption[0]), this::preStart$$anonfun$1);
                    Predef$.MODULE$.require(Files.isReadable(this.$outer.org$apache$pekko$stream$impl$io$FileSource$$path), this::preStart$$anonfun$2);
                    this.channel_$eq(FileChannel.open(this.$outer.org$apache$pekko$stream$impl$io$FileSource$$path, StandardOpenOption.READ));
                    this.channel().position(this.position());
                }
                catch (Exception ex) {
                    this.ioResultPromise$2.trySuccess((Object)IOResult$.MODULE$.apply(this.position(), (Try<Done>)Failure$.MODULE$.apply((Throwable)ex)));
                    throw ex;
                }
            }

            public void onPull() {
                if (this.availableChunks().size() < this.maxReadAhead() && !this.eofEncountered()) {
                    this.availableChunks_$eq(this.readAhead(this.maxReadAhead(), this.availableChunks()));
                }
                if (this.availableChunks().nonEmpty()) {
                    this.emitMultiple(this.$outer.out(), this.availableChunks().iterator(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                        if (this.eofEncountered()) {
                            this.success();
                            return;
                        }
                        this.setHandler(this.$outer.out(), this);
                    });
                    this.availableChunks_$eq(package$.MODULE$.Vector().empty());
                    return;
                }
                if (this.eofEncountered()) {
                    this.success();
                    return;
                }
            }

            private void success() {
                this.completeStage();
                this.ioResultPromise$2.trySuccess((Object)IOResult$.MODULE$.apply(this.position(), (Try<Done>)Success$.MODULE$.apply((Object)Done$.MODULE$)));
            }

            public Vector readAhead(int maxChunks, Vector chunks) {
                while (chunks.size() < maxChunks && !this.eofEncountered()) {
                    int n;
                    try {
                        n = this.channel().read(this.buffer(), this.position());
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable throwable3;
                            Throwable ex = throwable3 = (Throwable)option.get();
                            this.failStage(ex);
                            this.ioResultPromise$2.trySuccess((Object)IOResult$.MODULE$.apply(this.position(), (Try<Done>)Failure$.MODULE$.apply(ex)));
                            throw ex;
                        }
                        throw throwable;
                    }
                    int readBytes = n;
                    if (readBytes > 0) {
                        this.buffer().flip();
                        this.position_$eq(this.position() + (long)readBytes);
                        Vector newChunks = (Vector)chunks.$colon$plus((Object)ByteString$.MODULE$.fromByteBuffer(this.buffer()));
                        this.buffer().clear();
                        if (readBytes < this.$outer.org$apache$pekko$stream$impl$io$FileSource$$chunkSize) {
                            this.eofEncountered_$eq(true);
                            return newChunks;
                        }
                        chunks = newChunks;
                        continue;
                    }
                    this.eofEncountered_$eq(true);
                    return chunks;
                }
                return chunks;
            }

            public void onDownstreamFinish(Throwable cause) {
                Throwable throwable = cause;
                if (throwable instanceof SubscriptionWithCancelException.NonFailureCancellation) {
                    this.success();
                    return;
                }
                Throwable ex = throwable;
                this.ioResultPromise$2.tryFailure((Throwable)new IOOperationIncompleteException("Downstream failed before reaching file end", this.position(), ex));
                this.completeStage();
            }

            public void postStop() {
                this.ioResultPromise$2.trySuccess((Object)IOResult$.MODULE$.apply(this.position(), (Try<Done>)Success$.MODULE$.apply((Object)Done$.MODULE$)));
                if (this.channel() != null && this.channel().isOpen()) {
                    this.channel().close();
                    return;
                }
            }

            private final Object preStart$$anonfun$1() {
                return new StringBuilder(22).append("Path '").append(this.$outer.org$apache$pekko$stream$impl$io$FileSource$$path).append("' is a directory").toString();
            }

            private final Object preStart$$anonfun$2() {
                return new StringBuilder(30).append("Missing read permission for '").append(this.$outer.org$apache$pekko$stream$impl$io$FileSource$$path).append("'").toString();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{preStart$$anonfun$1(), preStart$$anonfun$2(), onPull$$anonfun$1()}, serializedLambda);
            }
        };
        return Tuple2$.MODULE$.apply((Object)logic, (Object)ioResultPromise.future());
    }

    public String toString() {
        return new StringBuilder(14).append("FileSource(").append(this.org$apache$pekko$stream$impl$io$FileSource$$path).append(", ").append(this.org$apache$pekko$stream$impl$io$FileSource$$chunkSize).append(")").toString();
    }

    private static final Object $init$$$anonfun$1() {
        return "chunkSize must be greater than 0";
    }
}

