/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.serialization;

import java.nio.charset.StandardCharsets;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.protobufv3.internal.ByteString;
import org.apache.pekko.protobufv3.internal.UnsafeByteOperations;
import org.apache.pekko.serialization.BaseSerializer;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.Serialization$;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.serialization.SerializerWithStringManifest;
import org.apache.pekko.serialization.Serializers$;
import org.apache.pekko.stream.StreamRefMessages;
import org.apache.pekko.stream.impl.streamref.SinkRefImpl;
import org.apache.pekko.stream.impl.streamref.SinkRefImpl$;
import org.apache.pekko.stream.impl.streamref.SourceRefImpl;
import org.apache.pekko.stream.impl.streamref.SourceRefImpl$;
import org.apache.pekko.stream.impl.streamref.StreamRefsProtocol;
import org.apache.pekko.stream.impl.streamref.StreamRefsProtocol$Ack$;
import org.apache.pekko.stream.impl.streamref.StreamRefsProtocol$CumulativeDemand$;
import org.apache.pekko.stream.impl.streamref.StreamRefsProtocol$OnSubscribeHandshake$;
import org.apache.pekko.stream.impl.streamref.StreamRefsProtocol$RemoteStreamCompleted$;
import org.apache.pekko.stream.impl.streamref.StreamRefsProtocol$RemoteStreamFailure$;
import org.apache.pekko.stream.impl.streamref.StreamRefsProtocol$SequencedOnNext$;
import scala.Array$;
import scala.Option$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Statics;
import scala.util.Try;

@InternalApi
public final class StreamRefSerializer
extends SerializerWithStringManifest
implements BaseSerializer {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(StreamRefSerializer.class.getDeclaredField("serialization$lzy1"));
    private int identifier;
    private final ExtendedActorSystem system;
    private volatile Object serialization$lzy1;
    private final String SequencedOnNextManifest;
    private final String CumulativeDemandManifest;
    private final String RemoteSinkFailureManifest;
    private final String RemoteSinkCompletedManifest;
    private final String SourceRefManifest;
    private final String SinkRefManifest;
    private final String OnSubscribeHandshakeManifest;
    private final String AckManifest;

    public StreamRefSerializer(ExtendedActorSystem system) {
        this.system = system;
        BaseSerializer.$init$((BaseSerializer)this);
        this.SequencedOnNextManifest = "A";
        this.CumulativeDemandManifest = "B";
        this.RemoteSinkFailureManifest = "C";
        this.RemoteSinkCompletedManifest = "D";
        this.SourceRefManifest = "E";
        this.SinkRefManifest = "F";
        this.OnSubscribeHandshakeManifest = "G";
        this.AckManifest = "H";
        Statics.releaseFence();
    }

    public int identifier() {
        return this.identifier;
    }

    public void org$apache$pekko$serialization$BaseSerializer$_setter_$identifier_$eq(int x$0) {
        this.identifier = x$0;
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    private Serialization serialization() {
        Object object = this.serialization$lzy1;
        if (object instanceof Serialization) {
            return (Serialization)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Serialization)this.serialization$lzyINIT1();
    }

    private Object serialization$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.serialization$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Serialization serialization = null;
                    try {
                        serialization = (Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)this.system());
                        object2 = serialization == null ? LazyVals.NullValue$.MODULE$ : serialization;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.serialization$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return serialization;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String manifest(Object o) {
        Object object = o;
        if (object instanceof StreamRefsProtocol.SequencedOnNext) {
            return this.SequencedOnNextManifest;
        }
        if (object instanceof StreamRefsProtocol.CumulativeDemand) {
            return this.CumulativeDemandManifest;
        }
        if (object instanceof StreamRefsProtocol.OnSubscribeHandshake) {
            return this.OnSubscribeHandshakeManifest;
        }
        if (object instanceof StreamRefsProtocol.RemoteStreamFailure) {
            return this.RemoteSinkFailureManifest;
        }
        if (object instanceof StreamRefsProtocol.RemoteStreamCompleted) {
            return this.RemoteSinkCompletedManifest;
        }
        if (object instanceof SourceRefImpl) {
            return this.SourceRefManifest;
        }
        if (object instanceof SinkRefImpl) {
            return this.SinkRefManifest;
        }
        if (StreamRefsProtocol$Ack$.MODULE$.equals(object)) {
            return this.AckManifest;
        }
        Object unknown = object;
        throw new IllegalArgumentException(new StringBuilder(19).append("Unsupported object ").append(unknown.getClass()).toString());
    }

    public byte[] toBinary(Object o) {
        Object object = o;
        if (object instanceof StreamRefsProtocol.SequencedOnNext) {
            StreamRefsProtocol.SequencedOnNext o2 = (StreamRefsProtocol.SequencedOnNext)object;
            return this.serializeSequencedOnNext(o2).toByteArray();
        }
        if (object instanceof StreamRefsProtocol.CumulativeDemand) {
            StreamRefsProtocol.CumulativeDemand d = (StreamRefsProtocol.CumulativeDemand)object;
            return this.serializeCumulativeDemand(d).toByteArray();
        }
        if (object instanceof StreamRefsProtocol.OnSubscribeHandshake) {
            StreamRefsProtocol.OnSubscribeHandshake h = (StreamRefsProtocol.OnSubscribeHandshake)object;
            return this.serializeOnSubscribeHandshake(h).toByteArray();
        }
        if (object instanceof StreamRefsProtocol.RemoteStreamFailure) {
            StreamRefsProtocol.RemoteStreamFailure d = (StreamRefsProtocol.RemoteStreamFailure)object;
            return this.serializeRemoteSinkFailure(d).toByteArray();
        }
        if (object instanceof StreamRefsProtocol.RemoteStreamCompleted) {
            StreamRefsProtocol.RemoteStreamCompleted d = (StreamRefsProtocol.RemoteStreamCompleted)object;
            return this.serializeRemoteSinkCompleted(d).toByteArray();
        }
        if (object instanceof SinkRefImpl) {
            SinkRefImpl ref = (SinkRefImpl)object;
            return this.serializeSinkRef(ref).toByteArray();
        }
        if (object instanceof SourceRefImpl) {
            SourceRefImpl ref = (SourceRefImpl)object;
            return this.serializeSourceRef(ref).toByteArray();
        }
        if (StreamRefsProtocol$Ack$.MODULE$.equals(object)) {
            return Array$.MODULE$.emptyByteArray();
        }
        Object unknown = object;
        throw new IllegalArgumentException(new StringBuilder(19).append("Unsupported object ").append(unknown.getClass()).toString());
    }

    public Object fromBinary(byte[] bytes, String manifest) {
        String string = manifest;
        String string2 = this.OnSubscribeHandshakeManifest;
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return this.deserializeOnSubscribeHandshake(bytes);
        }
        String string4 = this.SequencedOnNextManifest;
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return this.deserializeSequencedOnNext(bytes);
        }
        String string6 = this.CumulativeDemandManifest;
        String string7 = string;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            return this.deserializeCumulativeDemand(bytes);
        }
        String string8 = this.RemoteSinkCompletedManifest;
        String string9 = string;
        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
            return this.deserializeRemoteStreamCompleted(bytes);
        }
        String string10 = this.RemoteSinkFailureManifest;
        String string11 = string;
        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
            return this.deserializeRemoteStreamFailure(bytes);
        }
        String string12 = this.SinkRefManifest;
        String string13 = string;
        if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
            return this.deserializeSinkRef(bytes);
        }
        String string14 = this.SourceRefManifest;
        String string15 = string;
        if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
            return this.deserializeSourceRef(bytes);
        }
        String string16 = this.AckManifest;
        String string17 = string;
        if (!(string16 != null ? !string16.equals(string17) : string17 != null)) {
            return StreamRefsProtocol$Ack$.MODULE$;
        }
        String unknown = string;
        throw new IllegalArgumentException(new StringBuilder(24).append("Unsupported manifest '").append(unknown).append("''").toString());
    }

    private StreamRefMessages.CumulativeDemand serializeCumulativeDemand(StreamRefsProtocol.CumulativeDemand d) {
        return StreamRefMessages.CumulativeDemand.newBuilder().setSeqNr(d.seqNr()).build();
    }

    private StreamRefMessages.RemoteStreamFailure serializeRemoteSinkFailure(StreamRefsProtocol.RemoteStreamFailure d) {
        String msg = (String)Option$.MODULE$.apply((Object)d.msg()).getOrElse(() -> StreamRefSerializer.$anonfun$1(d));
        return StreamRefMessages.RemoteStreamFailure.newBuilder().setCause(UnsafeByteOperations.unsafeWrap((byte[])msg.getBytes(StandardCharsets.UTF_8))).build();
    }

    private StreamRefMessages.RemoteStreamCompleted serializeRemoteSinkCompleted(StreamRefsProtocol.RemoteStreamCompleted d) {
        return StreamRefMessages.RemoteStreamCompleted.newBuilder().setSeqNr(d.seqNr()).build();
    }

    private StreamRefMessages.OnSubscribeHandshake serializeOnSubscribeHandshake(StreamRefsProtocol.OnSubscribeHandshake o) {
        return StreamRefMessages.OnSubscribeHandshake.newBuilder().setTargetRef(StreamRefMessages.ActorRef.newBuilder().setPath(Serialization$.MODULE$.serializedActorPath(o.targetRef()))).build();
    }

    private StreamRefMessages.SequencedOnNext serializeSequencedOnNext(StreamRefsProtocol.SequencedOnNext<?> o) {
        Object p = o.payload();
        Serializer msgSerializer = this.serialization().findSerializerFor(p);
        StreamRefMessages.Payload.Builder payloadBuilder = StreamRefMessages.Payload.newBuilder().setEnclosedMessage(UnsafeByteOperations.unsafeWrap((byte[])msgSerializer.toBinary(p))).setSerializerId(msgSerializer.identifier());
        String ms = Serializers$.MODULE$.manifestFor(msgSerializer, p);
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(ms))) {
            payloadBuilder.setMessageManifest(ByteString.copyFromUtf8((String)ms));
        }
        return StreamRefMessages.SequencedOnNext.newBuilder().setSeqNr(o.seqNr()).setPayload(payloadBuilder.build()).build();
    }

    private StreamRefMessages.SinkRef serializeSinkRef(SinkRefImpl<?> sink) {
        return StreamRefMessages.SinkRef.newBuilder().setTargetRef(StreamRefMessages.ActorRef.newBuilder().setPath(Serialization$.MODULE$.serializedActorPath(sink.initialPartnerRef()))).build();
    }

    private StreamRefMessages.SourceRef serializeSourceRef(SourceRefImpl<?> source) {
        return StreamRefMessages.SourceRef.newBuilder().setOriginRef(StreamRefMessages.ActorRef.newBuilder().setPath(Serialization$.MODULE$.serializedActorPath(source.initialPartnerRef()))).build();
    }

    private StreamRefsProtocol.OnSubscribeHandshake deserializeOnSubscribeHandshake(byte[] bytes) {
        StreamRefMessages.OnSubscribeHandshake handshake = StreamRefMessages.OnSubscribeHandshake.parseFrom(bytes);
        ActorRef targetRef = this.serialization().system().provider().resolveActorRef(handshake.getTargetRef().getPath());
        return StreamRefsProtocol$OnSubscribeHandshake$.MODULE$.apply(targetRef);
    }

    private SinkRefImpl<Object> deserializeSinkRef(byte[] bytes) {
        StreamRefMessages.SinkRef ref = StreamRefMessages.SinkRef.parseFrom(bytes);
        ActorRef initialTargetRef = this.serialization().system().provider().resolveActorRef(ref.getTargetRef().getPath());
        return SinkRefImpl$.MODULE$.apply(initialTargetRef);
    }

    private SourceRefImpl<Object> deserializeSourceRef(byte[] bytes) {
        StreamRefMessages.SourceRef ref = StreamRefMessages.SourceRef.parseFrom(bytes);
        ActorRef initialPartnerRef = this.serialization().system().provider().resolveActorRef(ref.getOriginRef().getPath());
        return SourceRefImpl$.MODULE$.apply(initialPartnerRef);
    }

    private StreamRefsProtocol.SequencedOnNext<Object> deserializeSequencedOnNext(byte[] bytes) {
        StreamRefMessages.SequencedOnNext o = StreamRefMessages.SequencedOnNext.parseFrom(bytes);
        StreamRefMessages.Payload p = o.getPayload();
        Try payload = this.serialization().deserialize(p.getEnclosedMessage().toByteArray(), p.getSerializerId(), p.getMessageManifest().toStringUtf8());
        return StreamRefsProtocol$SequencedOnNext$.MODULE$.apply(o.getSeqNr(), payload.get());
    }

    private StreamRefsProtocol.CumulativeDemand deserializeCumulativeDemand(byte[] bytes) {
        StreamRefMessages.CumulativeDemand d = StreamRefMessages.CumulativeDemand.parseFrom(bytes);
        return StreamRefsProtocol$CumulativeDemand$.MODULE$.apply(d.getSeqNr());
    }

    private StreamRefsProtocol.RemoteStreamCompleted deserializeRemoteStreamCompleted(byte[] bytes) {
        StreamRefMessages.RemoteStreamCompleted d = StreamRefMessages.RemoteStreamCompleted.parseFrom(bytes);
        return StreamRefsProtocol$RemoteStreamCompleted$.MODULE$.apply(d.getSeqNr());
    }

    private Object deserializeRemoteStreamFailure(byte[] bytes) {
        StreamRefMessages.RemoteStreamFailure d = StreamRefMessages.RemoteStreamFailure.parseFrom(bytes);
        return StreamRefsProtocol$RemoteStreamFailure$.MODULE$.apply(d.getCause().toStringUtf8());
    }

    private static final String $anonfun$1(StreamRefsProtocol.RemoteStreamFailure d$1) {
        return d$1.getClass().getName();
    }
}

