/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.client.pool;

import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeoutException;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.engine.client.PoolFlow;
import org.apache.pekko.http.impl.engine.client.pool.SlotContext;
import org.apache.pekko.http.impl.engine.client.pool.SlotState$Connecting$;
import org.apache.pekko.http.impl.engine.client.pool.SlotState$Embargoed$;
import org.apache.pekko.http.impl.engine.client.pool.SlotState$Failed$;
import org.apache.pekko.http.impl.engine.client.pool.SlotState$Idle$;
import org.apache.pekko.http.impl.engine.client.pool.SlotState$OutOfEmbargo$;
import org.apache.pekko.http.impl.engine.client.pool.SlotState$PreConnecting$;
import org.apache.pekko.http.impl.engine.client.pool.SlotState$PushingRequestToConnection$;
import org.apache.pekko.http.impl.engine.client.pool.SlotState$ToBeClosed$;
import org.apache.pekko.http.impl.engine.client.pool.SlotState$WaitingForEndOfRequestEntity$;
import org.apache.pekko.http.impl.engine.client.pool.SlotState$WaitingForEndOfResponseEntity$;
import org.apache.pekko.http.impl.engine.client.pool.SlotState$WaitingForResponse$;
import org.apache.pekko.http.impl.engine.client.pool.SlotState$WaitingForResponseDispatch$;
import org.apache.pekko.http.impl.engine.client.pool.SlotState$WaitingForResponseEntitySubscription$;
import org.apache.pekko.http.impl.util.package$;
import org.apache.pekko.http.impl.util.package$RichHttpRequest$;
import org.apache.pekko.http.impl.util.package$RichHttpResponse$;
import org.apache.pekko.http.scaladsl.Http;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;
import scala.util.control.NoStackTrace;

@InternalApi
public abstract class SlotState
implements Product {
    public abstract boolean isIdle();

    public abstract boolean isConnected();

    public SlotState idle(SlotContext ctx) {
        return SlotState$Idle$.MODULE$.apply(ctx.settings().keepAliveTimeout());
    }

    public SlotState onPreConnect(SlotContext ctx) {
        return this.illegalState(ctx, "onPreConnect");
    }

    public SlotState onConnectionAttemptSucceeded(SlotContext ctx, Http.OutgoingConnection outgoingConnection) {
        return this.illegalState(ctx, "onConnectionAttemptSucceeded");
    }

    public SlotState onConnectionAttemptFailed(SlotContext ctx, Throwable cause) {
        return this.illegalState(ctx, "onConnectionAttemptFailed");
    }

    public SlotState onNewConnectionEmbargo(SlotContext ctx, FiniteDuration embargoDuration) {
        return this.illegalState(ctx, "onNewConnectionEmbargo");
    }

    public SlotState onNewRequest(SlotContext ctx, PoolFlow.RequestContext requestContext) {
        return this.illegalState(ctx, "onNewRequest");
    }

    public SlotState onRequestDispatched(SlotContext ctx) {
        return this.illegalState(ctx, "onRequestDispatched");
    }

    public SlotState onRequestEntityCompleted(SlotContext ctx) {
        return this.illegalState(ctx, "onRequestEntityCompleted");
    }

    public SlotState onRequestEntityFailed(SlotContext ctx, Throwable cause) {
        return this.illegalState(ctx, "onRequestEntityFailed");
    }

    public SlotState onResponseReceived(SlotContext ctx, HttpResponse response) {
        return this.illegalState(ctx, "onResponseReceived");
    }

    public SlotState onResponseDispatchable(SlotContext ctx) {
        return this.illegalState(ctx, "onResponseDispatchable");
    }

    public SlotState onResponseEntitySubscribed(SlotContext ctx) {
        return this.illegalState(ctx, "onResponseEntitySubscribed");
    }

    public SlotState onResponseEntityCompleted(SlotContext ctx) {
        return this.illegalState(ctx, "onResponseEntityCompleted");
    }

    public SlotState onResponseEntityFailed(SlotContext ctx, Throwable cause) {
        return this.illegalState(ctx, "onResponseEntityFailed");
    }

    public SlotState onConnectionCompleted(SlotContext ctx) {
        return this.illegalState(ctx, "onConnectionCompleted");
    }

    public SlotState onConnectionFailed(SlotContext ctx, Throwable cause) {
        return this.illegalState(ctx, "onConnectionFailed");
    }

    public SlotState onTimeout(SlotContext ctx) {
        return this.illegalState(ctx, "onTimeout");
    }

    public void onShutdown(SlotContext ctx) {
    }

    public Duration stateTimeout() {
        return Duration$.MODULE$.Inf();
    }

    public SlotState illegalState(SlotContext ctx, String what) {
        SlotContext LogHelperMacro_this = ctx;
        if (LogHelperMacro_this.isDebugEnabled()) {
            LogHelperMacro_this.log().debug(new StringBuilder(0).append(LogHelperMacro_this.prefixString()).append(new StringBuilder(36).append("Got unexpected event [").append(what).append("] in state [").append(this.name()).append("]]").toString()).toString());
        }
        throw new IllegalStateException(new StringBuilder(26).append("Cannot [").append(what).append("] when in state [").append(this.name()).append("]").toString());
    }

    public String name() {
        return this.productPrefix();
    }

    public static interface BusyState {
        public /* synthetic */ void org$apache$pekko$http$impl$engine$client$pool$SlotState$BusyState$$super$onShutdown(SlotContext var1);

        public static boolean isIdle$(BusyState $this) {
            return $this.isIdle();
        }

        default public boolean isIdle() {
            return false;
        }

        public PoolFlow.RequestContext ongoingRequest();

        public boolean waitingForEndOfRequestEntity();

        public static void onShutdown$(BusyState $this, SlotContext ctx) {
            $this.onShutdown(ctx);
        }

        default public void onShutdown(SlotContext ctx) {
            SlotContext LogHelperMacro_this = ctx;
            if (LogHelperMacro_this.isWarningEnabled()) {
                LogHelperMacro_this.log().warning(new StringBuilder(0).append(LogHelperMacro_this.prefixString()).append(new StringBuilder(60).append("Ongoing request [").append(package$RichHttpRequest$.MODULE$.debugString$extension(package$.MODULE$.RichHttpRequest(this.ongoingRequest().request()))).append("] was dropped because pool is shutting down").toString()).toString());
            }
            this.org$apache$pekko$http$impl$engine$client$pool$SlotState$BusyState$$super$onShutdown(ctx);
        }

        public static SlotState onConnectionAttemptFailed$(BusyState $this, SlotContext ctx, Throwable cause) {
            return $this.onConnectionAttemptFailed(ctx, cause);
        }

        default public SlotState onConnectionAttemptFailed(SlotContext ctx, Throwable cause) {
            return this.failOngoingRequest(ctx, "connection attempt failed", cause);
        }

        public static SlotState onRequestEntityFailed$(BusyState $this, SlotContext ctx, Throwable cause) {
            return $this.onRequestEntityFailed(ctx, cause);
        }

        default public SlotState onRequestEntityFailed(SlotContext ctx, Throwable cause) {
            return this.failOngoingRequest(ctx, "request entity stream failed", cause);
        }

        public static SlotState onConnectionCompleted$(BusyState $this, SlotContext ctx) {
            return $this.onConnectionCompleted(ctx);
        }

        default public SlotState onConnectionCompleted(SlotContext ctx) {
            return this.failOngoingRequest(ctx, "connection completed", (Throwable)new NoStackTrace(){
                {
                    NoStackTrace.$init$((NoStackTrace)this);
                }

                public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
                    return super.fillInStackTrace();
                }
            });
        }

        public static SlotState onConnectionFailed$(BusyState $this, SlotContext ctx, Throwable cause) {
            return $this.onConnectionFailed(ctx, cause);
        }

        default public SlotState onConnectionFailed(SlotContext ctx, Throwable cause) {
            return this.failOngoingRequest(ctx, "connection failure", cause);
        }

        private SlotState failOngoingRequest(SlotContext ctx, String signal, Throwable cause) {
            SlotContext LogHelperMacro_this = ctx;
            if (LogHelperMacro_this.isDebugEnabled()) {
                LogHelperMacro_this.log().debug(new StringBuilder(0).append(LogHelperMacro_this.prefixString()).append(new StringBuilder(46).append("Ongoing request [").append(package$RichHttpRequest$.MODULE$.debugString$extension(package$.MODULE$.RichHttpRequest(this.ongoingRequest().request()))).append("] is failed because of [").append(signal).append("]: [").append(cause.getMessage()).append("]").toString()).toString());
            }
            if (this.ongoingRequest().canBeRetried()) {
                ctx.dispatchResponseResult(this.ongoingRequest(), (Try<HttpResponse>)Failure$.MODULE$.apply(cause));
                return this.waitingForEndOfRequestEntity() ? SlotState$WaitingForEndOfRequestEntity$.MODULE$ : SlotState$Failed$.MODULE$.apply(cause);
            }
            return SlotState$WaitingForResponseDispatch$.MODULE$.apply(this.ongoingRequest(), (Try<HttpResponse>)Failure$.MODULE$.apply(cause), this.waitingForEndOfRequestEntity());
        }
    }

    public static interface BusyWithResultAlreadyDetermined
    extends BusyState {
        public static SlotState onResponseEntityFailed$(BusyWithResultAlreadyDetermined $this, SlotContext ctx, Throwable cause) {
            return $this.onResponseEntityFailed(ctx, cause);
        }

        default public SlotState onResponseEntityFailed(SlotContext ctx, Throwable cause) {
            block0: {
                SlotContext LogHelperMacro_this = ctx;
                if (!LogHelperMacro_this.isDebugEnabled()) break block0;
                LogHelperMacro_this.log().debug(new StringBuilder(0).append(LogHelperMacro_this.prefixString()).append(new StringBuilder(45).append("Response entity for request [").append(package$RichHttpRequest$.MODULE$.debugString$extension(package$.MODULE$.RichHttpRequest(this.ongoingRequest().request()))).append("] failed with [").append(cause.getMessage()).append("]").toString()).toString());
            }
            return SlotState$Failed$.MODULE$.apply(cause);
        }

        public static SlotState onConnectionCompleted$(BusyWithResultAlreadyDetermined $this, SlotContext ctx) {
            return $this.onConnectionCompleted(ctx);
        }

        @Override
        default public SlotState onConnectionCompleted(SlotContext ctx) {
            return (SlotState)((Object)this);
        }

        public static SlotState onConnectionFailed$(BusyWithResultAlreadyDetermined $this, SlotContext ctx, Throwable cause) {
            return $this.onConnectionFailed(ctx, cause);
        }

        @Override
        default public SlotState onConnectionFailed(SlotContext ctx, Throwable cause) {
            return (SlotState)((Object)this);
        }

        public static SlotState onRequestEntityFailed$(BusyWithResultAlreadyDetermined $this, SlotContext ctx, Throwable cause) {
            return $this.onRequestEntityFailed(ctx, cause);
        }

        @Override
        default public SlotState onRequestEntityFailed(SlotContext ctx, Throwable cause) {
            return (SlotState)((Object)this);
        }
    }

    public static abstract class ConnectedState
    extends SlotState {
        @Override
        public boolean isConnected() {
            return true;
        }

        @Override
        public SlotState onNewConnectionEmbargo(SlotContext ctx, FiniteDuration embargoDuration) {
            return this;
        }
    }

    public static final class Connecting
    extends ConnectedState
    implements BusyState,
    Serializable {
        private final PoolFlow.RequestContext ongoingRequest;
        private final boolean waitingForEndOfRequestEntity;

        public static Connecting apply(PoolFlow.RequestContext requestContext) {
            return SlotState$Connecting$.MODULE$.apply(requestContext);
        }

        public static Connecting fromProduct(Product product) {
            return SlotState$Connecting$.MODULE$.fromProduct(product);
        }

        public static Connecting unapply(Connecting connecting) {
            return SlotState$Connecting$.MODULE$.unapply(connecting);
        }

        public Connecting(PoolFlow.RequestContext ongoingRequest) {
            this.ongoingRequest = ongoingRequest;
            this.waitingForEndOfRequestEntity = false;
        }

        @Override
        public /* synthetic */ void org$apache$pekko$http$impl$engine$client$pool$SlotState$BusyState$$super$onShutdown(SlotContext ctx) {
            super.onShutdown(ctx);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Connecting)) return false;
            Connecting connecting = (Connecting)object;
            PoolFlow.RequestContext requestContext = this.ongoingRequest();
            PoolFlow.RequestContext requestContext2 = connecting.ongoingRequest();
            if (requestContext != null) {
                if (!((Object)requestContext).equals(requestContext2)) return false;
                return true;
            }
            if (requestContext2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Connecting;
        }

        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Connecting";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "ongoingRequest";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public PoolFlow.RequestContext ongoingRequest() {
            return this.ongoingRequest;
        }

        @Override
        public boolean waitingForEndOfRequestEntity() {
            return this.waitingForEndOfRequestEntity;
        }

        @Override
        public SlotState onConnectionAttemptSucceeded(SlotContext ctx, Http.OutgoingConnection outgoingConnection) {
            block0: {
                SlotContext LogHelperMacro_this = ctx;
                if (!LogHelperMacro_this.isDebugEnabled()) break block0;
                LogHelperMacro_this.log().debug(new StringBuilder(31).append(LogHelperMacro_this.prefixString()).append("Slot connection was established").toString());
            }
            return SlotState$PushingRequestToConnection$.MODULE$.apply(this.ongoingRequest());
        }

        public Connecting copy(PoolFlow.RequestContext ongoingRequest) {
            return new Connecting(ongoingRequest);
        }

        public PoolFlow.RequestContext copy$default$1() {
            return this.ongoingRequest();
        }

        public PoolFlow.RequestContext _1() {
            return this.ongoingRequest();
        }
    }

    public static class Embargoed
    extends SlotState
    implements Serializable {
        private final FiniteDuration embargoDuration;
        private final Duration stateTimeout;

        public static Embargoed apply(FiniteDuration finiteDuration) {
            return SlotState$Embargoed$.MODULE$.apply(finiteDuration);
        }

        public static Embargoed fromProduct(Product product) {
            return SlotState$Embargoed$.MODULE$.fromProduct(product);
        }

        public static Embargoed unapply(Embargoed embargoed) {
            return SlotState$Embargoed$.MODULE$.unapply(embargoed);
        }

        public Embargoed(FiniteDuration embargoDuration) {
            this.embargoDuration = embargoDuration;
            this.stateTimeout = this.newLevelTimeout();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Embargoed)) return false;
            Embargoed embargoed = (Embargoed)object;
            FiniteDuration finiteDuration = this.embargoDuration();
            FiniteDuration finiteDuration2 = embargoed.embargoDuration();
            if (finiteDuration == null) {
                if (finiteDuration2 != null) {
                    return false;
                }
            } else if (!finiteDuration.equals(finiteDuration2)) return false;
            if (!embargoed.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Embargoed;
        }

        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Embargoed";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "embargoDuration";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public FiniteDuration embargoDuration() {
            return this.embargoDuration;
        }

        @Override
        public boolean isConnected() {
            return false;
        }

        @Override
        public boolean isIdle() {
            return false;
        }

        @Override
        public Duration stateTimeout() {
            return this.stateTimeout;
        }

        private FiniteDuration newLevelTimeout() {
            if (this.embargoDuration().toMillis() > 0L) {
                long minMillis = this.embargoDuration().toMillis();
                long maxMillis = minMillis * 2L;
                return new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(ThreadLocalRandom.current().nextLong(minMillis, maxMillis))).millis();
            }
            return Duration$.MODULE$.Zero();
        }

        @Override
        public SlotState onTimeout(SlotContext ctx) {
            return SlotState$OutOfEmbargo$.MODULE$;
        }

        @Override
        public SlotState onNewConnectionEmbargo(SlotContext ctx, FiniteDuration embargoDuration) {
            return SlotState$Embargoed$.MODULE$.apply(embargoDuration);
        }

        public Embargoed copy(FiniteDuration embargoDuration) {
            return new Embargoed(embargoDuration);
        }

        public FiniteDuration copy$default$1() {
            return this.embargoDuration();
        }

        public FiniteDuration _1() {
            return this.embargoDuration();
        }
    }

    public static class Failed
    extends ShouldCloseConnectionState
    implements Serializable {
        private final Throwable cause;

        public static Failed apply(Throwable throwable) {
            return SlotState$Failed$.MODULE$.apply(throwable);
        }

        public static Failed fromProduct(Product product) {
            return SlotState$Failed$.MODULE$.fromProduct(product);
        }

        public static Failed unapply(Failed failed) {
            return SlotState$Failed$.MODULE$.unapply(failed);
        }

        public Failed(Throwable cause) {
            this.cause = cause;
            super((Option<Throwable>)Some$.MODULE$.apply((Object)cause));
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Failed)) return false;
            Failed failed = (Failed)object;
            Throwable throwable = this.cause();
            Throwable throwable2 = failed.cause();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            if (!failed.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Failed;
        }

        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Failed";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "cause";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Throwable cause() {
            return this.cause;
        }

        public Failed copy(Throwable cause) {
            return new Failed(cause);
        }

        public Throwable copy$default$1() {
            return this.cause();
        }

        public Throwable _1() {
            return this.cause();
        }
    }

    public static final class Idle
    extends ConnectedState
    implements IdleState,
    Serializable {
        private final Duration keepAliveTimeout;

        public static Idle apply(Duration duration) {
            return SlotState$Idle$.MODULE$.apply(duration);
        }

        public static Idle fromProduct(Product product) {
            return SlotState$Idle$.MODULE$.fromProduct(product);
        }

        public static Idle unapply(Idle idle) {
            return SlotState$Idle$.MODULE$.unapply(idle);
        }

        public Idle(Duration keepAliveTimeout) {
            this.keepAliveTimeout = keepAliveTimeout;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Idle)) return false;
            Idle idle = (Idle)object;
            Duration duration = this.keepAliveTimeout();
            Duration duration2 = idle.keepAliveTimeout();
            if (duration != null) {
                if (!duration.equals(duration2)) return false;
                return true;
            }
            if (duration2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Idle;
        }

        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Idle";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "keepAliveTimeout";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Duration keepAliveTimeout() {
            return this.keepAliveTimeout;
        }

        @Override
        public Duration stateTimeout() {
            return this.keepAliveTimeout();
        }

        @Override
        public SlotState onNewRequest(SlotContext ctx, PoolFlow.RequestContext requestContext) {
            return SlotState$PushingRequestToConnection$.MODULE$.apply(requestContext);
        }

        @Override
        public SlotState onTimeout(SlotContext ctx) {
            return SlotState$ToBeClosed$.MODULE$;
        }

        @Override
        public SlotState onConnectionCompleted(SlotContext ctx) {
            return SlotState$ToBeClosed$.MODULE$;
        }

        @Override
        public SlotState onConnectionFailed(SlotContext ctx, Throwable cause) {
            return SlotState$ToBeClosed$.MODULE$;
        }

        public Idle copy(Duration keepAliveTimeout) {
            return new Idle(keepAliveTimeout);
        }

        public Duration copy$default$1() {
            return this.keepAliveTimeout();
        }

        public Duration _1() {
            return this.keepAliveTimeout();
        }
    }

    public static interface IdleState {
        public static boolean isIdle$(IdleState $this) {
            return $this.isIdle();
        }

        default public boolean isIdle() {
            return true;
        }
    }

    public static final class PushingRequestToConnection
    extends ConnectedState
    implements BusyState,
    Serializable {
        private final PoolFlow.RequestContext ongoingRequest;

        public static PushingRequestToConnection apply(PoolFlow.RequestContext requestContext) {
            return SlotState$PushingRequestToConnection$.MODULE$.apply(requestContext);
        }

        public static PushingRequestToConnection fromProduct(Product product) {
            return SlotState$PushingRequestToConnection$.MODULE$.fromProduct(product);
        }

        public static PushingRequestToConnection unapply(PushingRequestToConnection pushingRequestToConnection) {
            return SlotState$PushingRequestToConnection$.MODULE$.unapply(pushingRequestToConnection);
        }

        public PushingRequestToConnection(PoolFlow.RequestContext ongoingRequest) {
            this.ongoingRequest = ongoingRequest;
        }

        @Override
        public /* synthetic */ void org$apache$pekko$http$impl$engine$client$pool$SlotState$BusyState$$super$onShutdown(SlotContext ctx) {
            super.onShutdown(ctx);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PushingRequestToConnection)) return false;
            PushingRequestToConnection pushingRequestToConnection = (PushingRequestToConnection)object;
            PoolFlow.RequestContext requestContext = this.ongoingRequest();
            PoolFlow.RequestContext requestContext2 = pushingRequestToConnection.ongoingRequest();
            if (requestContext != null) {
                if (!((Object)requestContext).equals(requestContext2)) return false;
                return true;
            }
            if (requestContext2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PushingRequestToConnection;
        }

        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "PushingRequestToConnection";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "ongoingRequest";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public PoolFlow.RequestContext ongoingRequest() {
            return this.ongoingRequest;
        }

        @Override
        public boolean waitingForEndOfRequestEntity() {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }

        @Override
        public SlotState onRequestDispatched(SlotContext ctx) {
            if (this.ongoingRequest().request().entity().isStrict()) {
                return SlotState$WaitingForResponse$.MODULE$.apply(this.ongoingRequest(), false);
            }
            return SlotState$WaitingForResponse$.MODULE$.apply(this.ongoingRequest(), true);
        }

        public PushingRequestToConnection copy(PoolFlow.RequestContext ongoingRequest) {
            return new PushingRequestToConnection(ongoingRequest);
        }

        public PoolFlow.RequestContext copy$default$1() {
            return this.ongoingRequest();
        }

        public PoolFlow.RequestContext _1() {
            return this.ongoingRequest();
        }
    }

    public static abstract class ShouldCloseConnectionState
    extends SlotState {
        private final Option failure;

        public ShouldCloseConnectionState(Option<Throwable> failure) {
            this.failure = failure;
        }

        public Option<Throwable> failure() {
            return this.failure;
        }

        @Override
        public boolean isIdle() {
            return false;
        }

        @Override
        public boolean isConnected() {
            return false;
        }
    }

    public static interface UnconnectedState
    extends IdleState {
        public static boolean isConnected$(UnconnectedState $this) {
            return $this.isConnected();
        }

        default public boolean isConnected() {
            return false;
        }

        public static SlotState onPreConnect$(UnconnectedState $this, SlotContext ctx) {
            return $this.onPreConnect(ctx);
        }

        default public SlotState onPreConnect(SlotContext ctx) {
            ctx.openConnection();
            return SlotState$PreConnecting$.MODULE$;
        }

        public static SlotState onNewRequest$(UnconnectedState $this, SlotContext ctx, PoolFlow.RequestContext requestContext) {
            return $this.onNewRequest(ctx, requestContext);
        }

        default public SlotState onNewRequest(SlotContext ctx, PoolFlow.RequestContext requestContext) {
            ctx.openConnection();
            return SlotState$Connecting$.MODULE$.apply(requestContext);
        }

        public static SlotState onNewConnectionEmbargo$(UnconnectedState $this, SlotContext ctx, FiniteDuration embargoDuration) {
            return $this.onNewConnectionEmbargo(ctx, embargoDuration);
        }

        default public SlotState onNewConnectionEmbargo(SlotContext ctx, FiniteDuration embargoDuration) {
            return SlotState$Embargoed$.MODULE$.apply(embargoDuration);
        }
    }

    public static final class WaitingForEndOfResponseEntity
    extends ConnectedState
    implements BusyState,
    BusyWithResultAlreadyDetermined,
    Serializable {
        private final PoolFlow.RequestContext ongoingRequest;
        private final HttpResponse ongoingResponse;
        private final boolean waitingForEndOfRequestEntity;

        public static WaitingForEndOfResponseEntity apply(PoolFlow.RequestContext requestContext, HttpResponse httpResponse, boolean bl) {
            return SlotState$WaitingForEndOfResponseEntity$.MODULE$.apply(requestContext, httpResponse, bl);
        }

        public static WaitingForEndOfResponseEntity fromProduct(Product product) {
            return SlotState$WaitingForEndOfResponseEntity$.MODULE$.fromProduct(product);
        }

        public static WaitingForEndOfResponseEntity unapply(WaitingForEndOfResponseEntity waitingForEndOfResponseEntity) {
            return SlotState$WaitingForEndOfResponseEntity$.MODULE$.unapply(waitingForEndOfResponseEntity);
        }

        public WaitingForEndOfResponseEntity(PoolFlow.RequestContext ongoingRequest, HttpResponse ongoingResponse, boolean waitingForEndOfRequestEntity) {
            this.ongoingRequest = ongoingRequest;
            this.ongoingResponse = ongoingResponse;
            this.waitingForEndOfRequestEntity = waitingForEndOfRequestEntity;
        }

        @Override
        public /* synthetic */ void org$apache$pekko$http$impl$engine$client$pool$SlotState$BusyState$$super$onShutdown(SlotContext ctx) {
            super.onShutdown(ctx);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.ongoingRequest()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.ongoingResponse()));
            n = Statics.mix((int)n, (int)(this.waitingForEndOfRequestEntity() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof WaitingForEndOfResponseEntity)) return false;
            WaitingForEndOfResponseEntity waitingForEndOfResponseEntity = (WaitingForEndOfResponseEntity)object;
            if (this.waitingForEndOfRequestEntity() != waitingForEndOfResponseEntity.waitingForEndOfRequestEntity()) return false;
            PoolFlow.RequestContext requestContext = this.ongoingRequest();
            PoolFlow.RequestContext requestContext2 = waitingForEndOfResponseEntity.ongoingRequest();
            if (requestContext == null) {
                if (requestContext2 != null) {
                    return false;
                }
            } else if (!((Object)requestContext).equals(requestContext2)) return false;
            HttpResponse httpResponse = this.ongoingResponse();
            HttpResponse httpResponse2 = waitingForEndOfResponseEntity.ongoingResponse();
            if (httpResponse == null) {
                if (httpResponse2 == null) return true;
                return false;
            } else {
                if (!((Object)httpResponse).equals(httpResponse2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof WaitingForEndOfResponseEntity;
        }

        public int productArity() {
            return 3;
        }

        @Override
        public String productPrefix() {
            return "WaitingForEndOfResponseEntity";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToBoolean((boolean)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "ongoingRequest";
                }
                case 1: {
                    return "ongoingResponse";
                }
                case 2: {
                    return "waitingForEndOfRequestEntity";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public PoolFlow.RequestContext ongoingRequest() {
            return this.ongoingRequest;
        }

        public HttpResponse ongoingResponse() {
            return this.ongoingResponse;
        }

        @Override
        public boolean waitingForEndOfRequestEntity() {
            return this.waitingForEndOfRequestEntity;
        }

        @Override
        public SlotState onResponseEntityCompleted(SlotContext ctx) {
            if (this.waitingForEndOfRequestEntity()) {
                return SlotState$WaitingForEndOfRequestEntity$.MODULE$;
            }
            if (ctx.willCloseAfter(this.ongoingResponse()) || ctx.isConnectionClosed()) {
                return SlotState$ToBeClosed$.MODULE$;
            }
            return this.idle(ctx);
        }

        @Override
        public SlotState onRequestEntityCompleted(SlotContext ctx) {
            Predef$.MODULE$.require(this.waitingForEndOfRequestEntity());
            return SlotState$WaitingForEndOfResponseEntity$.MODULE$.apply(this.ongoingRequest(), this.ongoingResponse(), false);
        }

        public WaitingForEndOfResponseEntity copy(PoolFlow.RequestContext ongoingRequest, HttpResponse ongoingResponse, boolean waitingForEndOfRequestEntity) {
            return new WaitingForEndOfResponseEntity(ongoingRequest, ongoingResponse, waitingForEndOfRequestEntity);
        }

        public PoolFlow.RequestContext copy$default$1() {
            return this.ongoingRequest();
        }

        public HttpResponse copy$default$2() {
            return this.ongoingResponse();
        }

        public boolean copy$default$3() {
            return this.waitingForEndOfRequestEntity();
        }

        public PoolFlow.RequestContext _1() {
            return this.ongoingRequest();
        }

        public HttpResponse _2() {
            return this.ongoingResponse();
        }

        public boolean _3() {
            return this.waitingForEndOfRequestEntity();
        }
    }

    public static final class WaitingForResponse
    extends ConnectedState
    implements BusyState,
    Serializable {
        private final PoolFlow.RequestContext ongoingRequest;
        private final boolean waitingForEndOfRequestEntity;

        public static WaitingForResponse apply(PoolFlow.RequestContext requestContext, boolean bl) {
            return SlotState$WaitingForResponse$.MODULE$.apply(requestContext, bl);
        }

        public static WaitingForResponse fromProduct(Product product) {
            return SlotState$WaitingForResponse$.MODULE$.fromProduct(product);
        }

        public static WaitingForResponse unapply(WaitingForResponse waitingForResponse) {
            return SlotState$WaitingForResponse$.MODULE$.unapply(waitingForResponse);
        }

        public WaitingForResponse(PoolFlow.RequestContext ongoingRequest, boolean waitingForEndOfRequestEntity) {
            this.ongoingRequest = ongoingRequest;
            this.waitingForEndOfRequestEntity = waitingForEndOfRequestEntity;
        }

        @Override
        public /* synthetic */ void org$apache$pekko$http$impl$engine$client$pool$SlotState$BusyState$$super$onShutdown(SlotContext ctx) {
            super.onShutdown(ctx);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.ongoingRequest()));
            n = Statics.mix((int)n, (int)(this.waitingForEndOfRequestEntity() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof WaitingForResponse)) return false;
            WaitingForResponse waitingForResponse = (WaitingForResponse)object;
            if (this.waitingForEndOfRequestEntity() != waitingForResponse.waitingForEndOfRequestEntity()) return false;
            PoolFlow.RequestContext requestContext = this.ongoingRequest();
            PoolFlow.RequestContext requestContext2 = waitingForResponse.ongoingRequest();
            if (requestContext != null) {
                if (!((Object)requestContext).equals(requestContext2)) return false;
                return true;
            }
            if (requestContext2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof WaitingForResponse;
        }

        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "WaitingForResponse";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToBoolean((boolean)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "ongoingRequest";
            }
            if (1 == n2) {
                return "waitingForEndOfRequestEntity";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public PoolFlow.RequestContext ongoingRequest() {
            return this.ongoingRequest;
        }

        @Override
        public boolean waitingForEndOfRequestEntity() {
            return this.waitingForEndOfRequestEntity;
        }

        @Override
        public SlotState onRequestEntityCompleted(SlotContext ctx) {
            Predef$.MODULE$.require(this.waitingForEndOfRequestEntity());
            return SlotState$WaitingForResponse$.MODULE$.apply(this.ongoingRequest(), false);
        }

        @Override
        public SlotState onResponseReceived(SlotContext ctx, HttpResponse response) {
            block0: {
                SlotContext LogHelperMacro_this = ctx;
                if (!LogHelperMacro_this.isDebugEnabled()) break block0;
                LogHelperMacro_this.log().debug(new StringBuilder(0).append(LogHelperMacro_this.prefixString()).append(new StringBuilder(46).append("onResponseReceived in WaitingForResponse with ").append(this.waitingForEndOfRequestEntity()).toString()).toString());
            }
            return SlotState$WaitingForResponseDispatch$.MODULE$.apply(this.ongoingRequest(), (Try<HttpResponse>)Success$.MODULE$.apply((Object)response), this.waitingForEndOfRequestEntity());
        }

        public WaitingForResponse copy(PoolFlow.RequestContext ongoingRequest, boolean waitingForEndOfRequestEntity) {
            return new WaitingForResponse(ongoingRequest, waitingForEndOfRequestEntity);
        }

        public PoolFlow.RequestContext copy$default$1() {
            return this.ongoingRequest();
        }

        public boolean copy$default$2() {
            return this.waitingForEndOfRequestEntity();
        }

        public PoolFlow.RequestContext _1() {
            return this.ongoingRequest();
        }

        public boolean _2() {
            return this.waitingForEndOfRequestEntity();
        }
    }

    public static final class WaitingForResponseDispatch
    extends ConnectedState
    implements BusyState,
    BusyWithResultAlreadyDetermined,
    Serializable {
        private final PoolFlow.RequestContext ongoingRequest;
        private final Try result;
        private final boolean waitingForEndOfRequestEntity;

        public static WaitingForResponseDispatch apply(PoolFlow.RequestContext requestContext, Try<HttpResponse> try_, boolean bl) {
            return SlotState$WaitingForResponseDispatch$.MODULE$.apply(requestContext, try_, bl);
        }

        public static WaitingForResponseDispatch fromProduct(Product product) {
            return SlotState$WaitingForResponseDispatch$.MODULE$.fromProduct(product);
        }

        public static WaitingForResponseDispatch unapply(WaitingForResponseDispatch waitingForResponseDispatch) {
            return SlotState$WaitingForResponseDispatch$.MODULE$.unapply(waitingForResponseDispatch);
        }

        public WaitingForResponseDispatch(PoolFlow.RequestContext ongoingRequest, Try<HttpResponse> result, boolean waitingForEndOfRequestEntity) {
            this.ongoingRequest = ongoingRequest;
            this.result = result;
            this.waitingForEndOfRequestEntity = waitingForEndOfRequestEntity;
        }

        @Override
        public /* synthetic */ void org$apache$pekko$http$impl$engine$client$pool$SlotState$BusyState$$super$onShutdown(SlotContext ctx) {
            super.onShutdown(ctx);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.ongoingRequest()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.result()));
            n = Statics.mix((int)n, (int)(this.waitingForEndOfRequestEntity() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof WaitingForResponseDispatch)) return false;
            WaitingForResponseDispatch waitingForResponseDispatch = (WaitingForResponseDispatch)object;
            if (this.waitingForEndOfRequestEntity() != waitingForResponseDispatch.waitingForEndOfRequestEntity()) return false;
            PoolFlow.RequestContext requestContext = this.ongoingRequest();
            PoolFlow.RequestContext requestContext2 = waitingForResponseDispatch.ongoingRequest();
            if (requestContext == null) {
                if (requestContext2 != null) {
                    return false;
                }
            } else if (!((Object)requestContext).equals(requestContext2)) return false;
            Try<HttpResponse> try_ = this.result();
            Try<HttpResponse> try_2 = waitingForResponseDispatch.result();
            if (try_ == null) {
                if (try_2 == null) return true;
                return false;
            } else {
                if (!try_.equals(try_2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof WaitingForResponseDispatch;
        }

        public int productArity() {
            return 3;
        }

        @Override
        public String productPrefix() {
            return "WaitingForResponseDispatch";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToBoolean((boolean)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "ongoingRequest";
                }
                case 1: {
                    return "result";
                }
                case 2: {
                    return "waitingForEndOfRequestEntity";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public PoolFlow.RequestContext ongoingRequest() {
            return this.ongoingRequest;
        }

        public Try<HttpResponse> result() {
            return this.result;
        }

        @Override
        public boolean waitingForEndOfRequestEntity() {
            return this.waitingForEndOfRequestEntity;
        }

        @Override
        public SlotState onRequestEntityCompleted(SlotContext ctx) {
            Predef$.MODULE$.require(this.waitingForEndOfRequestEntity());
            return SlotState$WaitingForResponseDispatch$.MODULE$.apply(this.ongoingRequest(), this.result(), false);
        }

        @Override
        public SlotState onResponseDispatchable(SlotContext ctx) {
            SlotState slotState;
            ctx.dispatchResponseResult(this.ongoingRequest(), this.result());
            Try<HttpResponse> try_ = this.result();
            if (try_ instanceof Success) {
                HttpResponse res = (HttpResponse)((Success)try_).value();
                slotState = SlotState$WaitingForResponseEntitySubscription$.MODULE$.apply(this.ongoingRequest(), res, ctx.settings().responseEntitySubscriptionTimeout(), this.waitingForEndOfRequestEntity());
            } else if (try_ instanceof Failure) {
                Throwable cause = ((Failure)try_).exception();
                slotState = SlotState$Failed$.MODULE$.apply(cause);
            } else {
                throw new MatchError(try_);
            }
            return slotState;
        }

        public WaitingForResponseDispatch copy(PoolFlow.RequestContext ongoingRequest, Try<HttpResponse> result, boolean waitingForEndOfRequestEntity) {
            return new WaitingForResponseDispatch(ongoingRequest, result, waitingForEndOfRequestEntity);
        }

        public PoolFlow.RequestContext copy$default$1() {
            return this.ongoingRequest();
        }

        public Try<HttpResponse> copy$default$2() {
            return this.result();
        }

        public boolean copy$default$3() {
            return this.waitingForEndOfRequestEntity();
        }

        public PoolFlow.RequestContext _1() {
            return this.ongoingRequest();
        }

        public Try<HttpResponse> _2() {
            return this.result();
        }

        public boolean _3() {
            return this.waitingForEndOfRequestEntity();
        }
    }

    public static final class WaitingForResponseEntitySubscription
    extends ConnectedState
    implements BusyState,
    BusyWithResultAlreadyDetermined,
    Serializable {
        private final PoolFlow.RequestContext ongoingRequest;
        private final HttpResponse ongoingResponse;
        private final Duration stateTimeout;
        private final boolean waitingForEndOfRequestEntity;

        public static WaitingForResponseEntitySubscription apply(PoolFlow.RequestContext requestContext, HttpResponse httpResponse, Duration duration, boolean bl) {
            return SlotState$WaitingForResponseEntitySubscription$.MODULE$.apply(requestContext, httpResponse, duration, bl);
        }

        public static WaitingForResponseEntitySubscription fromProduct(Product product) {
            return SlotState$WaitingForResponseEntitySubscription$.MODULE$.fromProduct(product);
        }

        public static WaitingForResponseEntitySubscription unapply(WaitingForResponseEntitySubscription waitingForResponseEntitySubscription) {
            return SlotState$WaitingForResponseEntitySubscription$.MODULE$.unapply(waitingForResponseEntitySubscription);
        }

        public WaitingForResponseEntitySubscription(PoolFlow.RequestContext ongoingRequest, HttpResponse ongoingResponse, Duration stateTimeout, boolean waitingForEndOfRequestEntity) {
            this.ongoingRequest = ongoingRequest;
            this.ongoingResponse = ongoingResponse;
            this.stateTimeout = stateTimeout;
            this.waitingForEndOfRequestEntity = waitingForEndOfRequestEntity;
        }

        @Override
        public /* synthetic */ void org$apache$pekko$http$impl$engine$client$pool$SlotState$BusyState$$super$onShutdown(SlotContext ctx) {
            super.onShutdown(ctx);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.ongoingRequest()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.ongoingResponse()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.stateTimeout()));
            n = Statics.mix((int)n, (int)(this.waitingForEndOfRequestEntity() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof WaitingForResponseEntitySubscription)) return false;
            WaitingForResponseEntitySubscription waitingForResponseEntitySubscription = (WaitingForResponseEntitySubscription)object;
            if (this.waitingForEndOfRequestEntity() != waitingForResponseEntitySubscription.waitingForEndOfRequestEntity()) return false;
            PoolFlow.RequestContext requestContext = this.ongoingRequest();
            PoolFlow.RequestContext requestContext2 = waitingForResponseEntitySubscription.ongoingRequest();
            if (requestContext == null) {
                if (requestContext2 != null) {
                    return false;
                }
            } else if (!((Object)requestContext).equals(requestContext2)) return false;
            HttpResponse httpResponse = this.ongoingResponse();
            HttpResponse httpResponse2 = waitingForResponseEntitySubscription.ongoingResponse();
            if (httpResponse == null) {
                if (httpResponse2 != null) {
                    return false;
                }
            } else if (!((Object)httpResponse).equals(httpResponse2)) return false;
            Duration duration = this.stateTimeout();
            Duration duration2 = waitingForResponseEntitySubscription.stateTimeout();
            if (duration == null) {
                if (duration2 == null) return true;
                return false;
            } else {
                if (!duration.equals(duration2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof WaitingForResponseEntitySubscription;
        }

        public int productArity() {
            return 4;
        }

        @Override
        public String productPrefix() {
            return "WaitingForResponseEntitySubscription";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return BoxesRunTime.boxToBoolean((boolean)this._4());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "ongoingRequest";
                }
                case 1: {
                    return "ongoingResponse";
                }
                case 2: {
                    return "stateTimeout";
                }
                case 3: {
                    return "waitingForEndOfRequestEntity";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public PoolFlow.RequestContext ongoingRequest() {
            return this.ongoingRequest;
        }

        public HttpResponse ongoingResponse() {
            return this.ongoingResponse;
        }

        @Override
        public Duration stateTimeout() {
            return this.stateTimeout;
        }

        @Override
        public boolean waitingForEndOfRequestEntity() {
            return this.waitingForEndOfRequestEntity;
        }

        @Override
        public SlotState onRequestEntityCompleted(SlotContext ctx) {
            Predef$.MODULE$.require(this.waitingForEndOfRequestEntity());
            return SlotState$WaitingForResponseEntitySubscription$.MODULE$.apply(this.ongoingRequest(), this.ongoingResponse(), this.stateTimeout(), false);
        }

        @Override
        public SlotState onResponseEntitySubscribed(SlotContext ctx) {
            return SlotState$WaitingForEndOfResponseEntity$.MODULE$.apply(this.ongoingRequest(), this.ongoingResponse(), this.waitingForEndOfRequestEntity());
        }

        @Override
        public SlotState onTimeout(SlotContext ctx) {
            String msg = new StringBuilder(217).append("Response entity was not subscribed after ").append(this.stateTimeout()).append(". Make sure to read the response `entity` body or call `entity.discardBytes()` on it -- in case you deal with `HttpResponse`, use the shortcut `response.discardEntityBytes()`. ").append(new StringBuilder(4).append(package$RichHttpRequest$.MODULE$.debugString$extension(package$.MODULE$.RichHttpRequest(this.ongoingRequest().request()))).append(" -> ").append(package$RichHttpResponse$.MODULE$.debugString$extension(package$.MODULE$.RichHttpResponse(this.ongoingResponse()))).toString()).toString();
            SlotContext LogHelperMacro_this = ctx;
            if (LogHelperMacro_this.isWarningEnabled()) {
                LogHelperMacro_this.log().warning(new StringBuilder(0).append(LogHelperMacro_this.prefixString()).append(msg).toString());
            }
            return SlotState$Failed$.MODULE$.apply(new TimeoutException(msg));
        }

        public WaitingForResponseEntitySubscription copy(PoolFlow.RequestContext ongoingRequest, HttpResponse ongoingResponse, Duration stateTimeout, boolean waitingForEndOfRequestEntity) {
            return new WaitingForResponseEntitySubscription(ongoingRequest, ongoingResponse, stateTimeout, waitingForEndOfRequestEntity);
        }

        public PoolFlow.RequestContext copy$default$1() {
            return this.ongoingRequest();
        }

        public HttpResponse copy$default$2() {
            return this.ongoingResponse();
        }

        public Duration copy$default$3() {
            return this.stateTimeout();
        }

        public boolean copy$default$4() {
            return this.waitingForEndOfRequestEntity();
        }

        public PoolFlow.RequestContext _1() {
            return this.ongoingRequest();
        }

        public HttpResponse _2() {
            return this.ongoingResponse();
        }

        public Duration _3() {
            return this.stateTimeout();
        }

        public boolean _4() {
            return this.waitingForEndOfRequestEntity();
        }
    }
}

