/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.http2;

import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.engine.http2.ConfigurablePing$;
import org.apache.pekko.http.impl.engine.http2.ConfigurablePing$PingState$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent;
import org.apache.pekko.http.scaladsl.settings.Http2CommonSettings;
import scala.Option;
import scala.Some$;
import scala.concurrent.duration.FiniteDuration;

@InternalApi
public final class ConfigurablePing {
    public static FrameEvent.PingFrame Ping() {
        return ConfigurablePing$.MODULE$.Ping();
    }

    public static final class EnabledPingState
    implements PingState {
        private final FiniteDuration _tickInterval;
        private final long pingEveryNTickWithoutData;
        private long ticksWithoutData;
        private long ticksSincePing;
        private boolean pingInFlight;

        public EnabledPingState(FiniteDuration _tickInterval, long pingEveryNTickWithoutData) {
            this._tickInterval = _tickInterval;
            this.pingEveryNTickWithoutData = pingEveryNTickWithoutData;
            this.ticksWithoutData = 0L;
            this.ticksSincePing = 0L;
            this.pingInFlight = false;
        }

        @Override
        public Option<FiniteDuration> tickInterval() {
            return Some$.MODULE$.apply((Object)this._tickInterval);
        }

        @Override
        public void onDataFrameSeen() {
            this.ticksWithoutData = 0L;
        }

        @Override
        public void onPingAck() {
            this.ticksSincePing = 0L;
            this.pingInFlight = false;
        }

        @Override
        public void onTick() {
            ++this.ticksWithoutData;
            if (this.pingInFlight) {
                ++this.ticksSincePing;
                return;
            }
        }

        @Override
        public void clear() {
            this.ticksWithoutData = 0L;
            this.ticksSincePing = 0L;
        }

        @Override
        public boolean shouldEmitPing() {
            return this.ticksWithoutData > 0L && this.ticksWithoutData % this.pingEveryNTickWithoutData == 0L;
        }

        @Override
        public void sendingPing() {
            this.ticksSincePing = 0L;
            this.pingInFlight = true;
        }

        @Override
        public boolean pingAckOverdue() {
            return this.pingInFlight && this.ticksSincePing > 1L;
        }
    }

    public static interface PingState {
        public static PingState apply(Http2CommonSettings http2CommonSettings) {
            return ConfigurablePing$PingState$.MODULE$.apply(http2CommonSettings);
        }

        public Option<FiniteDuration> tickInterval();

        public void onDataFrameSeen();

        public void onPingAck();

        public void onTick();

        public void clear();

        public boolean shouldEmitPing();

        public void sendingPing();

        public boolean pingAckOverdue();
    }
}

