/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.http2;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.engine.http2.ByteFlag;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$ContinuationFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$DataFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$GoAwayFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$HeadersFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$ParsedHeadersFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$PingFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$PriorityFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$PushPromiseFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$RstStreamFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$Setting$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$SettingsAckFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$SettingsFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$UnknownFrameEvent$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$WindowUpdateFrame$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol;
import org.apache.pekko.util.ByteString;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@InternalApi
public interface FrameEvent {
    public static int ordinal(FrameEvent frameEvent) {
        return FrameEvent$.MODULE$.ordinal(frameEvent);
    }

    public static String frameTypeName$(FrameEvent $this) {
        return $this.frameTypeName();
    }

    default public String frameTypeName() {
        return ((Product)this).productPrefix();
    }

    public static final class ContinuationFrame
    implements FrameEvent,
    StreamFrameEvent,
    Product,
    Serializable {
        private final int streamId;
        private final boolean endHeaders;
        private final ByteString payload;

        public static ContinuationFrame apply(int n, boolean bl, ByteString byteString) {
            return FrameEvent$ContinuationFrame$.MODULE$.apply(n, bl, byteString);
        }

        public static ContinuationFrame fromProduct(Product product) {
            return FrameEvent$ContinuationFrame$.MODULE$.fromProduct(product);
        }

        public static ContinuationFrame unapply(ContinuationFrame continuationFrame) {
            return FrameEvent$ContinuationFrame$.MODULE$.unapply(continuationFrame);
        }

        public ContinuationFrame(int streamId, boolean endHeaders, ByteString payload) {
            this.streamId = streamId;
            this.endHeaders = endHeaders;
            this.payload = payload;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.streamId());
            n = Statics.mix((int)n, (int)(this.endHeaders() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.payload()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ContinuationFrame)) return false;
            ContinuationFrame continuationFrame = (ContinuationFrame)object;
            if (this.streamId() != continuationFrame.streamId()) return false;
            if (this.endHeaders() != continuationFrame.endHeaders()) return false;
            ByteString byteString = this.payload();
            ByteString byteString2 = continuationFrame.payload();
            if (byteString != null) {
                if (!byteString.equals(byteString2)) return false;
                return true;
            }
            if (byteString2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ContinuationFrame;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "ContinuationFrame";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToBoolean((boolean)this._2());
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "streamId";
                }
                case 1: {
                    return "endHeaders";
                }
                case 2: {
                    return "payload";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public int streamId() {
            return this.streamId;
        }

        public boolean endHeaders() {
            return this.endHeaders;
        }

        public ByteString payload() {
            return this.payload;
        }

        public ContinuationFrame copy(int streamId, boolean endHeaders, ByteString payload) {
            return new ContinuationFrame(streamId, endHeaders, payload);
        }

        public int copy$default$1() {
            return this.streamId();
        }

        public boolean copy$default$2() {
            return this.endHeaders();
        }

        public ByteString copy$default$3() {
            return this.payload();
        }

        public int _1() {
            return this.streamId();
        }

        public boolean _2() {
            return this.endHeaders();
        }

        public ByteString _3() {
            return this.payload();
        }
    }

    public static final class DataFrame
    implements FrameEvent,
    StreamFrameEvent,
    Product,
    Serializable {
        private final int streamId;
        private final boolean endStream;
        private final ByteString payload;

        public static DataFrame apply(int n, boolean bl, ByteString byteString) {
            return FrameEvent$DataFrame$.MODULE$.apply(n, bl, byteString);
        }

        public static DataFrame fromProduct(Product product) {
            return FrameEvent$DataFrame$.MODULE$.fromProduct(product);
        }

        public static DataFrame unapply(DataFrame dataFrame) {
            return FrameEvent$DataFrame$.MODULE$.unapply(dataFrame);
        }

        public DataFrame(int streamId, boolean endStream, ByteString payload) {
            this.streamId = streamId;
            this.endStream = endStream;
            this.payload = payload;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.streamId());
            n = Statics.mix((int)n, (int)(this.endStream() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.payload()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DataFrame)) return false;
            DataFrame dataFrame = (DataFrame)object;
            if (this.streamId() != dataFrame.streamId()) return false;
            if (this.endStream() != dataFrame.endStream()) return false;
            ByteString byteString = this.payload();
            ByteString byteString2 = dataFrame.payload();
            if (byteString != null) {
                if (!byteString.equals(byteString2)) return false;
                return true;
            }
            if (byteString2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DataFrame;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "DataFrame";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToBoolean((boolean)this._2());
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "streamId";
                }
                case 1: {
                    return "endStream";
                }
                case 2: {
                    return "payload";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public int streamId() {
            return this.streamId;
        }

        public boolean endStream() {
            return this.endStream;
        }

        public ByteString payload() {
            return this.payload;
        }

        public int sizeInWindow() {
            return this.payload().size();
        }

        public DataFrame copy(int streamId, boolean endStream, ByteString payload) {
            return new DataFrame(streamId, endStream, payload);
        }

        public int copy$default$1() {
            return this.streamId();
        }

        public boolean copy$default$2() {
            return this.endStream();
        }

        public ByteString copy$default$3() {
            return this.payload();
        }

        public int _1() {
            return this.streamId();
        }

        public boolean _2() {
            return this.endStream();
        }

        public ByteString _3() {
            return this.payload();
        }
    }

    public static final class GoAwayFrame
    implements FrameEvent,
    Product,
    Serializable {
        private final int lastStreamId;
        private final Http2Protocol.ErrorCode errorCode;
        private final ByteString debug;

        public static GoAwayFrame apply(int n, Http2Protocol.ErrorCode errorCode, ByteString byteString) {
            return FrameEvent$GoAwayFrame$.MODULE$.apply(n, errorCode, byteString);
        }

        public static GoAwayFrame fromProduct(Product product) {
            return FrameEvent$GoAwayFrame$.MODULE$.fromProduct(product);
        }

        public static GoAwayFrame unapply(GoAwayFrame goAwayFrame) {
            return FrameEvent$GoAwayFrame$.MODULE$.unapply(goAwayFrame);
        }

        public static ByteString $lessinit$greater$default$3() {
            return FrameEvent$GoAwayFrame$.MODULE$.$lessinit$greater$default$3();
        }

        public GoAwayFrame(int lastStreamId, Http2Protocol.ErrorCode errorCode, ByteString debug) {
            this.lastStreamId = lastStreamId;
            this.errorCode = errorCode;
            this.debug = debug;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.lastStreamId());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.errorCode()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.debug()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof GoAwayFrame)) return false;
            GoAwayFrame goAwayFrame = (GoAwayFrame)object;
            if (this.lastStreamId() != goAwayFrame.lastStreamId()) return false;
            Http2Protocol.ErrorCode errorCode = this.errorCode();
            Http2Protocol.ErrorCode errorCode2 = goAwayFrame.errorCode();
            if (errorCode == null) {
                if (errorCode2 != null) {
                    return false;
                }
            } else if (!errorCode.equals(errorCode2)) return false;
            ByteString byteString = this.debug();
            ByteString byteString2 = goAwayFrame.debug();
            if (byteString == null) {
                if (byteString2 == null) return true;
                return false;
            } else {
                if (!byteString.equals(byteString2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof GoAwayFrame;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "GoAwayFrame";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "lastStreamId";
                }
                case 1: {
                    return "errorCode";
                }
                case 2: {
                    return "debug";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int lastStreamId() {
            return this.lastStreamId;
        }

        public Http2Protocol.ErrorCode errorCode() {
            return this.errorCode;
        }

        public ByteString debug() {
            return this.debug;
        }

        public String toString() {
            return new StringBuilder(29).append("GoAwayFrame(").append(this.lastStreamId()).append(",").append(this.errorCode()).append(",debug:<hidden>)").toString();
        }

        public GoAwayFrame copy(int lastStreamId, Http2Protocol.ErrorCode errorCode, ByteString debug) {
            return new GoAwayFrame(lastStreamId, errorCode, debug);
        }

        public int copy$default$1() {
            return this.lastStreamId();
        }

        public Http2Protocol.ErrorCode copy$default$2() {
            return this.errorCode();
        }

        public ByteString copy$default$3() {
            return this.debug();
        }

        public int _1() {
            return this.lastStreamId();
        }

        public Http2Protocol.ErrorCode _2() {
            return this.errorCode();
        }

        public ByteString _3() {
            return this.debug();
        }
    }

    public static final class HeadersFrame
    implements FrameEvent,
    StreamFrameEvent,
    Product,
    Serializable {
        private final int streamId;
        private final boolean endStream;
        private final boolean endHeaders;
        private final ByteString headerBlockFragment;
        private final Option priorityInfo;

        public static HeadersFrame apply(int n, boolean bl, boolean bl2, ByteString byteString, Option<PriorityFrame> option) {
            return FrameEvent$HeadersFrame$.MODULE$.apply(n, bl, bl2, byteString, option);
        }

        public static HeadersFrame fromProduct(Product product) {
            return FrameEvent$HeadersFrame$.MODULE$.fromProduct(product);
        }

        public static HeadersFrame unapply(HeadersFrame headersFrame) {
            return FrameEvent$HeadersFrame$.MODULE$.unapply(headersFrame);
        }

        public HeadersFrame(int streamId, boolean endStream, boolean endHeaders, ByteString headerBlockFragment, Option<PriorityFrame> priorityInfo) {
            this.streamId = streamId;
            this.endStream = endStream;
            this.endHeaders = endHeaders;
            this.headerBlockFragment = headerBlockFragment;
            this.priorityInfo = priorityInfo;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.streamId());
            n = Statics.mix((int)n, (int)(this.endStream() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.endHeaders() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.headerBlockFragment()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.priorityInfo()));
            return Statics.finalizeHash((int)n, (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof HeadersFrame)) return false;
            HeadersFrame headersFrame = (HeadersFrame)object;
            if (this.streamId() != headersFrame.streamId()) return false;
            if (this.endStream() != headersFrame.endStream()) return false;
            if (this.endHeaders() != headersFrame.endHeaders()) return false;
            ByteString byteString = this.headerBlockFragment();
            ByteString byteString2 = headersFrame.headerBlockFragment();
            if (byteString == null) {
                if (byteString2 != null) {
                    return false;
                }
            } else if (!byteString.equals(byteString2)) return false;
            Option<PriorityFrame> option = this.priorityInfo();
            Option<PriorityFrame> option2 = headersFrame.priorityInfo();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof HeadersFrame;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "HeadersFrame";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToBoolean((boolean)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToBoolean((boolean)this._3());
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "streamId";
                }
                case 1: {
                    return "endStream";
                }
                case 2: {
                    return "endHeaders";
                }
                case 3: {
                    return "headerBlockFragment";
                }
                case 4: {
                    return "priorityInfo";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public int streamId() {
            return this.streamId;
        }

        public boolean endStream() {
            return this.endStream;
        }

        public boolean endHeaders() {
            return this.endHeaders;
        }

        public ByteString headerBlockFragment() {
            return this.headerBlockFragment;
        }

        public Option<PriorityFrame> priorityInfo() {
            return this.priorityInfo;
        }

        public HeadersFrame copy(int streamId, boolean endStream, boolean endHeaders, ByteString headerBlockFragment, Option<PriorityFrame> priorityInfo) {
            return new HeadersFrame(streamId, endStream, endHeaders, headerBlockFragment, priorityInfo);
        }

        public int copy$default$1() {
            return this.streamId();
        }

        public boolean copy$default$2() {
            return this.endStream();
        }

        public boolean copy$default$3() {
            return this.endHeaders();
        }

        public ByteString copy$default$4() {
            return this.headerBlockFragment();
        }

        public Option<PriorityFrame> copy$default$5() {
            return this.priorityInfo();
        }

        public int _1() {
            return this.streamId();
        }

        public boolean _2() {
            return this.endStream();
        }

        public boolean _3() {
            return this.endHeaders();
        }

        public ByteString _4() {
            return this.headerBlockFragment();
        }

        public Option<PriorityFrame> _5() {
            return this.priorityInfo();
        }
    }

    public static final class ParsedHeadersFrame
    implements FrameEvent,
    StreamFrameEvent,
    Product,
    Serializable {
        private final int streamId;
        private final boolean endStream;
        private final Seq keyValuePairs;
        private final Option priorityInfo;

        public static ParsedHeadersFrame apply(int n, boolean bl, Seq<Tuple2<String, Object>> seq, Option<PriorityFrame> option) {
            return FrameEvent$ParsedHeadersFrame$.MODULE$.apply(n, bl, seq, option);
        }

        public static ParsedHeadersFrame fromProduct(Product product) {
            return FrameEvent$ParsedHeadersFrame$.MODULE$.fromProduct(product);
        }

        public static ParsedHeadersFrame unapply(ParsedHeadersFrame parsedHeadersFrame) {
            return FrameEvent$ParsedHeadersFrame$.MODULE$.unapply(parsedHeadersFrame);
        }

        public ParsedHeadersFrame(int streamId, boolean endStream, Seq<Tuple2<String, Object>> keyValuePairs, Option<PriorityFrame> priorityInfo) {
            this.streamId = streamId;
            this.endStream = endStream;
            this.keyValuePairs = keyValuePairs;
            this.priorityInfo = priorityInfo;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.streamId());
            n = Statics.mix((int)n, (int)(this.endStream() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.keyValuePairs()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.priorityInfo()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ParsedHeadersFrame)) return false;
            ParsedHeadersFrame parsedHeadersFrame = (ParsedHeadersFrame)object;
            if (this.streamId() != parsedHeadersFrame.streamId()) return false;
            if (this.endStream() != parsedHeadersFrame.endStream()) return false;
            Seq<Tuple2<String, Object>> seq = this.keyValuePairs();
            Seq<Tuple2<String, Object>> seq2 = parsedHeadersFrame.keyValuePairs();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            Option<PriorityFrame> option = this.priorityInfo();
            Option<PriorityFrame> option2 = parsedHeadersFrame.priorityInfo();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ParsedHeadersFrame;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "ParsedHeadersFrame";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToBoolean((boolean)this._2());
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "streamId";
                }
                case 1: {
                    return "endStream";
                }
                case 2: {
                    return "keyValuePairs";
                }
                case 3: {
                    return "priorityInfo";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public int streamId() {
            return this.streamId;
        }

        public boolean endStream() {
            return this.endStream;
        }

        public Seq<Tuple2<String, Object>> keyValuePairs() {
            return this.keyValuePairs;
        }

        public Option<PriorityFrame> priorityInfo() {
            return this.priorityInfo;
        }

        public ParsedHeadersFrame copy(int streamId, boolean endStream, Seq<Tuple2<String, Object>> keyValuePairs, Option<PriorityFrame> priorityInfo) {
            return new ParsedHeadersFrame(streamId, endStream, keyValuePairs, priorityInfo);
        }

        public int copy$default$1() {
            return this.streamId();
        }

        public boolean copy$default$2() {
            return this.endStream();
        }

        public Seq<Tuple2<String, Object>> copy$default$3() {
            return this.keyValuePairs();
        }

        public Option<PriorityFrame> copy$default$4() {
            return this.priorityInfo();
        }

        public int _1() {
            return this.streamId();
        }

        public boolean _2() {
            return this.endStream();
        }

        public Seq<Tuple2<String, Object>> _3() {
            return this.keyValuePairs();
        }

        public Option<PriorityFrame> _4() {
            return this.priorityInfo();
        }
    }

    public static class PingFrame
    implements FrameEvent,
    Product,
    Serializable {
        private final boolean ack;
        private final ByteString data;

        public static PingFrame apply(boolean bl, ByteString byteString) {
            return FrameEvent$PingFrame$.MODULE$.apply(bl, byteString);
        }

        public static PingFrame fromProduct(Product product) {
            return FrameEvent$PingFrame$.MODULE$.fromProduct(product);
        }

        public static PingFrame unapply(PingFrame pingFrame) {
            return FrameEvent$PingFrame$.MODULE$.unapply(pingFrame);
        }

        public PingFrame(boolean ack, ByteString data) {
            this.ack = ack;
            this.data = data;
            Predef$.MODULE$.require(data.size() == 8, () -> this.$init$$$anonfun$1(data));
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)(this.ack() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.data()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PingFrame)) return false;
            PingFrame pingFrame = (PingFrame)object;
            if (this.ack() != pingFrame.ack()) return false;
            ByteString byteString = this.data();
            ByteString byteString2 = pingFrame.data();
            if (byteString == null) {
                if (byteString2 != null) {
                    return false;
                }
            } else if (!byteString.equals(byteString2)) return false;
            if (!pingFrame.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PingFrame;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "PingFrame";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToBoolean((boolean)this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "ack";
            }
            if (1 == n2) {
                return "data";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public boolean ack() {
            return this.ack;
        }

        public ByteString data() {
            return this.data;
        }

        public PingFrame copy(boolean ack, ByteString data) {
            return new PingFrame(ack, data);
        }

        public boolean copy$default$1() {
            return this.ack();
        }

        public ByteString copy$default$2() {
            return this.data();
        }

        public boolean _1() {
            return this.ack();
        }

        public ByteString _2() {
            return this.data();
        }

        private final Object $init$$$anonfun$1(ByteString data$1) {
            return new StringBuilder(44).append("PingFrame payload must be of size 8 but was ").append(data$1.size()).toString();
        }
    }

    public static final class PriorityFrame
    implements FrameEvent,
    StreamFrameEvent,
    Product,
    Serializable {
        private final int streamId;
        private final boolean exclusiveFlag;
        private final int streamDependency;
        private final int weight;

        public static PriorityFrame apply(int n, boolean bl, int n2, int n3) {
            return FrameEvent$PriorityFrame$.MODULE$.apply(n, bl, n2, n3);
        }

        public static PriorityFrame fromProduct(Product product) {
            return FrameEvent$PriorityFrame$.MODULE$.fromProduct(product);
        }

        public static PriorityFrame unapply(PriorityFrame priorityFrame) {
            return FrameEvent$PriorityFrame$.MODULE$.unapply(priorityFrame);
        }

        public PriorityFrame(int streamId, boolean exclusiveFlag, int streamDependency, int weight) {
            this.streamId = streamId;
            this.exclusiveFlag = exclusiveFlag;
            this.streamDependency = streamDependency;
            this.weight = weight;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.streamId());
            n = Statics.mix((int)n, (int)(this.exclusiveFlag() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)this.streamDependency());
            n = Statics.mix((int)n, (int)this.weight());
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PriorityFrame)) return false;
            PriorityFrame priorityFrame = (PriorityFrame)object;
            if (this.streamId() != priorityFrame.streamId()) return false;
            if (this.exclusiveFlag() != priorityFrame.exclusiveFlag()) return false;
            if (this.streamDependency() != priorityFrame.streamDependency()) return false;
            if (this.weight() != priorityFrame.weight()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PriorityFrame;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "PriorityFrame";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToBoolean((boolean)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
                case 3: {
                    return BoxesRunTime.boxToInteger((int)this._4());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "streamId";
                }
                case 1: {
                    return "exclusiveFlag";
                }
                case 2: {
                    return "streamDependency";
                }
                case 3: {
                    return "weight";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public int streamId() {
            return this.streamId;
        }

        public boolean exclusiveFlag() {
            return this.exclusiveFlag;
        }

        public int streamDependency() {
            return this.streamDependency;
        }

        public int weight() {
            return this.weight;
        }

        public PriorityFrame copy(int streamId, boolean exclusiveFlag, int streamDependency, int weight) {
            return new PriorityFrame(streamId, exclusiveFlag, streamDependency, weight);
        }

        public int copy$default$1() {
            return this.streamId();
        }

        public boolean copy$default$2() {
            return this.exclusiveFlag();
        }

        public int copy$default$3() {
            return this.streamDependency();
        }

        public int copy$default$4() {
            return this.weight();
        }

        public int _1() {
            return this.streamId();
        }

        public boolean _2() {
            return this.exclusiveFlag();
        }

        public int _3() {
            return this.streamDependency();
        }

        public int _4() {
            return this.weight();
        }
    }

    public static class PushPromiseFrame
    implements FrameEvent,
    StreamFrameEvent,
    Product,
    Serializable {
        private final int streamId;
        private final boolean endHeaders;
        private final int promisedStreamId;
        private final ByteString headerBlockFragment;

        public static PushPromiseFrame apply(int n, boolean bl, int n2, ByteString byteString) {
            return FrameEvent$PushPromiseFrame$.MODULE$.apply(n, bl, n2, byteString);
        }

        public static PushPromiseFrame fromProduct(Product product) {
            return FrameEvent$PushPromiseFrame$.MODULE$.fromProduct(product);
        }

        public static PushPromiseFrame unapply(PushPromiseFrame pushPromiseFrame) {
            return FrameEvent$PushPromiseFrame$.MODULE$.unapply(pushPromiseFrame);
        }

        public PushPromiseFrame(int streamId, boolean endHeaders, int promisedStreamId, ByteString headerBlockFragment) {
            this.streamId = streamId;
            this.endHeaders = endHeaders;
            this.promisedStreamId = promisedStreamId;
            this.headerBlockFragment = headerBlockFragment;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.streamId());
            n = Statics.mix((int)n, (int)(this.endHeaders() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)this.promisedStreamId());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.headerBlockFragment()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PushPromiseFrame)) return false;
            PushPromiseFrame pushPromiseFrame = (PushPromiseFrame)object;
            if (this.streamId() != pushPromiseFrame.streamId()) return false;
            if (this.endHeaders() != pushPromiseFrame.endHeaders()) return false;
            if (this.promisedStreamId() != pushPromiseFrame.promisedStreamId()) return false;
            ByteString byteString = this.headerBlockFragment();
            ByteString byteString2 = pushPromiseFrame.headerBlockFragment();
            if (byteString == null) {
                if (byteString2 != null) {
                    return false;
                }
            } else if (!byteString.equals(byteString2)) return false;
            if (!pushPromiseFrame.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PushPromiseFrame;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "PushPromiseFrame";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToBoolean((boolean)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "streamId";
                }
                case 1: {
                    return "endHeaders";
                }
                case 2: {
                    return "promisedStreamId";
                }
                case 3: {
                    return "headerBlockFragment";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public int streamId() {
            return this.streamId;
        }

        public boolean endHeaders() {
            return this.endHeaders;
        }

        public int promisedStreamId() {
            return this.promisedStreamId;
        }

        public ByteString headerBlockFragment() {
            return this.headerBlockFragment;
        }

        public PushPromiseFrame copy(int streamId, boolean endHeaders, int promisedStreamId, ByteString headerBlockFragment) {
            return new PushPromiseFrame(streamId, endHeaders, promisedStreamId, headerBlockFragment);
        }

        public int copy$default$1() {
            return this.streamId();
        }

        public boolean copy$default$2() {
            return this.endHeaders();
        }

        public int copy$default$3() {
            return this.promisedStreamId();
        }

        public ByteString copy$default$4() {
            return this.headerBlockFragment();
        }

        public int _1() {
            return this.streamId();
        }

        public boolean _2() {
            return this.endHeaders();
        }

        public int _3() {
            return this.promisedStreamId();
        }

        public ByteString _4() {
            return this.headerBlockFragment();
        }
    }

    public static final class RstStreamFrame
    implements FrameEvent,
    StreamFrameEvent,
    Product,
    Serializable {
        private final int streamId;
        private final Http2Protocol.ErrorCode errorCode;

        public static RstStreamFrame apply(int n, Http2Protocol.ErrorCode errorCode) {
            return FrameEvent$RstStreamFrame$.MODULE$.apply(n, errorCode);
        }

        public static RstStreamFrame fromProduct(Product product) {
            return FrameEvent$RstStreamFrame$.MODULE$.fromProduct(product);
        }

        public static RstStreamFrame unapply(RstStreamFrame rstStreamFrame) {
            return FrameEvent$RstStreamFrame$.MODULE$.unapply(rstStreamFrame);
        }

        public RstStreamFrame(int streamId, Http2Protocol.ErrorCode errorCode) {
            this.streamId = streamId;
            this.errorCode = errorCode;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.streamId());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.errorCode()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RstStreamFrame)) return false;
            RstStreamFrame rstStreamFrame = (RstStreamFrame)object;
            if (this.streamId() != rstStreamFrame.streamId()) return false;
            Http2Protocol.ErrorCode errorCode = this.errorCode();
            Http2Protocol.ErrorCode errorCode2 = rstStreamFrame.errorCode();
            if (errorCode != null) {
                if (!errorCode.equals(errorCode2)) return false;
                return true;
            }
            if (errorCode2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RstStreamFrame;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "RstStreamFrame";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToInteger((int)this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "streamId";
            }
            if (1 == n2) {
                return "errorCode";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public int streamId() {
            return this.streamId;
        }

        public Http2Protocol.ErrorCode errorCode() {
            return this.errorCode;
        }

        public RstStreamFrame copy(int streamId, Http2Protocol.ErrorCode errorCode) {
            return new RstStreamFrame(streamId, errorCode);
        }

        public int copy$default$1() {
            return this.streamId();
        }

        public Http2Protocol.ErrorCode copy$default$2() {
            return this.errorCode();
        }

        public int _1() {
            return this.streamId();
        }

        public Http2Protocol.ErrorCode _2() {
            return this.errorCode();
        }
    }

    public static final class Setting
    implements Product,
    Serializable {
        private final Http2Protocol.SettingIdentifier identifier;
        private final int value;

        public static Setting apply(Http2Protocol.SettingIdentifier settingIdentifier, int n) {
            return FrameEvent$Setting$.MODULE$.apply(settingIdentifier, n);
        }

        public static Setting autoConvertFromTuple(Tuple2<Http2Protocol.SettingIdentifier, Object> tuple2) {
            return FrameEvent$Setting$.MODULE$.autoConvertFromTuple(tuple2);
        }

        public static Setting fromProduct(Product product) {
            return FrameEvent$Setting$.MODULE$.fromProduct(product);
        }

        public static Setting unapply(Setting setting) {
            return FrameEvent$Setting$.MODULE$.unapply(setting);
        }

        public Setting(Http2Protocol.SettingIdentifier identifier, int value) {
            this.identifier = identifier;
            this.value = value;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.identifier()));
            n = Statics.mix((int)n, (int)this.value());
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Setting)) return false;
            Setting setting = (Setting)object;
            if (this.value() != setting.value()) return false;
            Http2Protocol.SettingIdentifier settingIdentifier = this.identifier();
            Http2Protocol.SettingIdentifier settingIdentifier2 = setting.identifier();
            if (settingIdentifier != null) {
                if (!settingIdentifier.equals(settingIdentifier2)) return false;
                return true;
            }
            if (settingIdentifier2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Setting;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Setting";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToInteger((int)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "identifier";
            }
            if (1 == n2) {
                return "value";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Http2Protocol.SettingIdentifier identifier() {
            return this.identifier;
        }

        public int value() {
            return this.value;
        }

        public Setting copy(Http2Protocol.SettingIdentifier identifier, int value) {
            return new Setting(identifier, value);
        }

        public Http2Protocol.SettingIdentifier copy$default$1() {
            return this.identifier();
        }

        public int copy$default$2() {
            return this.value();
        }

        public Http2Protocol.SettingIdentifier _1() {
            return this.identifier();
        }

        public int _2() {
            return this.value();
        }
    }

    public static final class SettingsAckFrame
    implements FrameEvent,
    Product,
    Serializable {
        private final Seq acked;

        public static SettingsAckFrame apply(Seq<Setting> seq) {
            return FrameEvent$SettingsAckFrame$.MODULE$.apply(seq);
        }

        public static SettingsAckFrame fromProduct(Product product) {
            return FrameEvent$SettingsAckFrame$.MODULE$.fromProduct(product);
        }

        public static SettingsAckFrame unapply(SettingsAckFrame settingsAckFrame) {
            return FrameEvent$SettingsAckFrame$.MODULE$.unapply(settingsAckFrame);
        }

        public SettingsAckFrame(Seq<Setting> acked) {
            this.acked = acked;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SettingsAckFrame)) return false;
            SettingsAckFrame settingsAckFrame = (SettingsAckFrame)object;
            Seq<Setting> seq = this.acked();
            Seq<Setting> seq2 = settingsAckFrame.acked();
            if (seq != null) {
                if (!seq.equals(seq2)) return false;
                return true;
            }
            if (seq2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SettingsAckFrame;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "SettingsAckFrame";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "acked";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Seq<Setting> acked() {
            return this.acked;
        }

        public SettingsAckFrame copy(Seq<Setting> acked) {
            return new SettingsAckFrame(acked);
        }

        public Seq<Setting> copy$default$1() {
            return this.acked();
        }

        public Seq<Setting> _1() {
            return this.acked();
        }
    }

    public static final class SettingsFrame
    implements FrameEvent,
    Product,
    Serializable {
        private final Seq settings;

        public static SettingsFrame apply(Seq<Setting> seq) {
            return FrameEvent$SettingsFrame$.MODULE$.apply(seq);
        }

        public static SettingsFrame fromProduct(Product product) {
            return FrameEvent$SettingsFrame$.MODULE$.fromProduct(product);
        }

        public static SettingsFrame unapply(SettingsFrame settingsFrame) {
            return FrameEvent$SettingsFrame$.MODULE$.unapply(settingsFrame);
        }

        public SettingsFrame(Seq<Setting> settings) {
            this.settings = settings;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SettingsFrame)) return false;
            SettingsFrame settingsFrame = (SettingsFrame)object;
            Seq<Setting> seq = this.settings();
            Seq<Setting> seq2 = settingsFrame.settings();
            if (seq != null) {
                if (!seq.equals(seq2)) return false;
                return true;
            }
            if (seq2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SettingsFrame;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "SettingsFrame";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "settings";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Seq<Setting> settings() {
            return this.settings;
        }

        public SettingsFrame copy(Seq<Setting> settings) {
            return new SettingsFrame(settings);
        }

        public Seq<Setting> copy$default$1() {
            return this.settings();
        }

        public Seq<Setting> _1() {
            return this.settings();
        }
    }

    public static interface StreamFrameEvent
    extends FrameEvent {
        public int streamId();
    }

    public static final class UnknownFrameEvent
    implements FrameEvent,
    StreamFrameEvent,
    Product,
    Serializable {
        private final Http2Protocol.FrameType tpe;
        private final int flags;
        private final int streamId;
        private final ByteString payload;

        public static UnknownFrameEvent apply(Http2Protocol.FrameType frameType, int n, int n2, ByteString byteString) {
            return FrameEvent$UnknownFrameEvent$.MODULE$.apply(frameType, n, n2, byteString);
        }

        public static UnknownFrameEvent fromProduct(Product product) {
            return FrameEvent$UnknownFrameEvent$.MODULE$.fromProduct(product);
        }

        public static UnknownFrameEvent unapply(UnknownFrameEvent unknownFrameEvent) {
            return FrameEvent$UnknownFrameEvent$.MODULE$.unapply(unknownFrameEvent);
        }

        public UnknownFrameEvent(Http2Protocol.FrameType tpe, int flags, int streamId, ByteString payload) {
            this.tpe = tpe;
            this.flags = flags;
            this.streamId = streamId;
            this.payload = payload;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.tpe()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)new ByteFlag(this.flags())));
            n = Statics.mix((int)n, (int)this.streamId());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.payload()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof UnknownFrameEvent)) return false;
            UnknownFrameEvent unknownFrameEvent = (UnknownFrameEvent)object;
            if (this.streamId() != unknownFrameEvent.streamId()) return false;
            Http2Protocol.FrameType frameType = this.tpe();
            Http2Protocol.FrameType frameType2 = unknownFrameEvent.tpe();
            if (frameType == null) {
                if (frameType2 != null) {
                    return false;
                }
            } else if (!frameType.equals(frameType2)) return false;
            if (this.flags() != unknownFrameEvent.flags()) return false;
            ByteString byteString = this.payload();
            ByteString byteString2 = unknownFrameEvent.payload();
            if (byteString == null) {
                if (byteString2 == null) return true;
                return false;
            } else {
                if (!byteString.equals(byteString2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof UnknownFrameEvent;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "UnknownFrameEvent";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return new ByteFlag(this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "tpe";
                }
                case 1: {
                    return "flags";
                }
                case 2: {
                    return "streamId";
                }
                case 3: {
                    return "payload";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Http2Protocol.FrameType tpe() {
            return this.tpe;
        }

        public int flags() {
            return this.flags;
        }

        @Override
        public int streamId() {
            return this.streamId;
        }

        public ByteString payload() {
            return this.payload;
        }

        public UnknownFrameEvent copy(Http2Protocol.FrameType tpe, int flags, int streamId, ByteString payload) {
            return new UnknownFrameEvent(tpe, flags, streamId, payload);
        }

        public Http2Protocol.FrameType copy$default$1() {
            return this.tpe();
        }

        public int copy$default$2() {
            return this.flags();
        }

        public int copy$default$3() {
            return this.streamId();
        }

        public ByteString copy$default$4() {
            return this.payload();
        }

        public Http2Protocol.FrameType _1() {
            return this.tpe();
        }

        public int _2() {
            return this.flags();
        }

        public int _3() {
            return this.streamId();
        }

        public ByteString _4() {
            return this.payload();
        }
    }

    public static final class WindowUpdateFrame
    implements FrameEvent,
    StreamFrameEvent,
    Product,
    Serializable {
        private final int streamId;
        private final int windowSizeIncrement;

        public static WindowUpdateFrame apply(int n, int n2) {
            return FrameEvent$WindowUpdateFrame$.MODULE$.apply(n, n2);
        }

        public static WindowUpdateFrame fromProduct(Product product) {
            return FrameEvent$WindowUpdateFrame$.MODULE$.fromProduct(product);
        }

        public static WindowUpdateFrame unapply(WindowUpdateFrame windowUpdateFrame) {
            return FrameEvent$WindowUpdateFrame$.MODULE$.unapply(windowUpdateFrame);
        }

        public WindowUpdateFrame(int streamId, int windowSizeIncrement) {
            this.streamId = streamId;
            this.windowSizeIncrement = windowSizeIncrement;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.streamId());
            n = Statics.mix((int)n, (int)this.windowSizeIncrement());
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof WindowUpdateFrame)) return false;
            WindowUpdateFrame windowUpdateFrame = (WindowUpdateFrame)object;
            if (this.streamId() != windowUpdateFrame.streamId()) return false;
            if (this.windowSizeIncrement() != windowUpdateFrame.windowSizeIncrement()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof WindowUpdateFrame;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "WindowUpdateFrame";
        }

        public Object productElement(int n) {
            int n2;
            int n3 = n;
            if (0 == n3) {
                n2 = this._1();
            } else if (1 == n3) {
                n2 = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToInteger((int)n2);
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "streamId";
            }
            if (1 == n2) {
                return "windowSizeIncrement";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public int streamId() {
            return this.streamId;
        }

        public int windowSizeIncrement() {
            return this.windowSizeIncrement;
        }

        public WindowUpdateFrame copy(int streamId, int windowSizeIncrement) {
            return new WindowUpdateFrame(streamId, windowSizeIncrement);
        }

        public int copy$default$1() {
            return this.streamId();
        }

        public int copy$default$2() {
            return this.windowSizeIncrement();
        }

        public int _1() {
            return this.streamId();
        }

        public int _2() {
            return this.windowSizeIncrement();
        }
    }
}

