/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.http2;

import java.io.Serializable;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLSession;
import org.apache.pekko.NotUsed;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.engine.HttpConnectionIdleTimeoutBidi$;
import org.apache.pekko.http.impl.engine.HttpIdleTimeoutException;
import org.apache.pekko.http.impl.engine.http2.FrameEvent;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$GoAwayFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameLogger$;
import org.apache.pekko.http.impl.engine.http2.Http2$;
import org.apache.pekko.http.impl.engine.http2.Http2Blueprint;
import org.apache.pekko.http.impl.engine.http2.Http2ClientDemux;
import org.apache.pekko.http.impl.engine.http2.Http2Compliance;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$ErrorCode$INTERNAL_ERROR$;
import org.apache.pekko.http.impl.engine.http2.Http2ServerDemux;
import org.apache.pekko.http.impl.engine.http2.Http2SubStream;
import org.apache.pekko.http.impl.engine.http2.RequestParsing$;
import org.apache.pekko.http.impl.engine.http2.RequestRendering;
import org.apache.pekko.http.impl.engine.http2.ResponseRendering;
import org.apache.pekko.http.impl.engine.http2.TelemetrySpi;
import org.apache.pekko.http.impl.engine.http2.client.ResponseParsing$;
import org.apache.pekko.http.impl.engine.http2.framing.FrameRenderer$;
import org.apache.pekko.http.impl.engine.http2.framing.Http2FrameParsing;
import org.apache.pekko.http.impl.engine.http2.hpack.HeaderCompression$;
import org.apache.pekko.http.impl.engine.http2.hpack.HeaderDecompression;
import org.apache.pekko.http.impl.engine.parsing.HttpHeaderParser;
import org.apache.pekko.http.impl.engine.parsing.HttpHeaderParser$;
import org.apache.pekko.http.impl.engine.rendering.DateHeaderRendering;
import org.apache.pekko.http.impl.engine.server.ServerTerminator;
import org.apache.pekko.http.impl.util.JavaMapping;
import org.apache.pekko.http.impl.util.JavaMapping$;
import org.apache.pekko.http.impl.util.LogByteStringTools$;
import org.apache.pekko.http.impl.util.StreamUtils$;
import org.apache.pekko.http.javadsl.model.AttributeKey;
import org.apache.pekko.http.scaladsl.model.ErrorInfo;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.settings.ClientConnectionSettings;
import org.apache.pekko.http.scaladsl.settings.Http2ClientSettings;
import org.apache.pekko.http.scaladsl.settings.Http2ServerSettings;
import org.apache.pekko.http.scaladsl.settings.ParserSettings;
import org.apache.pekko.http.scaladsl.settings.ParserSettings$ErrorLoggingVerbosity$Full$;
import org.apache.pekko.http.scaladsl.settings.ParserSettings$ErrorLoggingVerbosity$Off$;
import org.apache.pekko.http.scaladsl.settings.ParserSettings$ErrorLoggingVerbosity$Simple$;
import org.apache.pekko.http.scaladsl.settings.ServerSettings;
import org.apache.pekko.http.scaladsl.settings.ServerSettings$;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.StreamTcpException;
import org.apache.pekko.stream.TLSProtocol;
import org.apache.pekko.stream.ThrottleMode;
import org.apache.pekko.stream.scaladsl.BidiFlow;
import org.apache.pekko.stream.scaladsl.BidiFlow$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.util.ByteString;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.control.NonFatal$;

@InternalApi
public final class Http2Blueprint$
implements Serializable {
    private static final BidiFlow unwrapTls;
    public static final Http2Blueprint$ MODULE$;

    private Http2Blueprint$() {
    }

    static {
        MODULE$ = new Http2Blueprint$();
        unwrapTls = BidiFlow$.MODULE$.fromFlows((Graph)Flow$.MODULE$.apply().map((Function1 & Serializable)_$3 -> TLSProtocol.SendBytes$.MODULE$.apply(_$3)), (Graph)Flow$.MODULE$.apply().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(TLSProtocol.SslTlsInbound x) {
                TLSProtocol.SslTlsInbound sslTlsInbound = x;
                if (sslTlsInbound instanceof TLSProtocol.SessionBytes) {
                    ByteString byteString;
                    TLSProtocol.SessionBytes sessionBytes = TLSProtocol.SessionBytes$.MODULE$.unapply((TLSProtocol.SessionBytes)sslTlsInbound);
                    SSLSession sSLSession = sessionBytes._1();
                    ByteString bytes = byteString = sessionBytes._2();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(TLSProtocol.SslTlsInbound x, Function1 function1) {
                TLSProtocol.SslTlsInbound sslTlsInbound = x;
                if (sslTlsInbound instanceof TLSProtocol.SessionBytes) {
                    ByteString byteString;
                    TLSProtocol.SessionBytes sessionBytes = TLSProtocol.SessionBytes$.MODULE$.unapply((TLSProtocol.SessionBytes)sslTlsInbound);
                    SSLSession sSLSession = sessionBytes._1();
                    ByteString bytes = byteString = sessionBytes._2();
                    return bytes;
                }
                return function1.apply((Object)x);
            }
        }));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Http2Blueprint$.class);
    }

    public BidiFlow<HttpResponse, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, HttpRequest, ServerTerminator> serverStackTls(ServerSettings settings, LoggingAdapter log, TelemetrySpi telemetry, DateHeaderRendering dateHeaderRendering) {
        return this.serverStack(settings, log, this.serverStack$default$3(), this.serverStack$default$4(), telemetry, dateHeaderRendering).atop(this.unwrapTls()).atop(LogByteStringTools$.MODULE$.logTLSBidiBySetting("server-plain-text", settings.logUnencryptedNetworkBytes()));
    }

    public BidiFlow<HttpResponse, ByteString, ByteString, HttpRequest, ServerTerminator> serverStack(ServerSettings settings, LoggingAdapter log, Seq<FrameEvent.Setting> initialDemuxerSettings, boolean upgraded, TelemetrySpi telemetry, DateHeaderRendering dateHeaderRendering) {
        HttpHeaderParser masterHttpHeaderParser = HttpHeaderParser$.MODULE$.apply(settings.parserSettings(), log);
        BidiFlow initialFlow = this.BidiFlowExt(telemetry.serverConnection().atop(this.httpLayer(settings, log, dateHeaderRendering))).atopKeepRight(this.serverDemux(settings.http2Settings(), initialDemuxerSettings, upgraded)).atop(FrameLogger$.MODULE$.logFramesIfEnabled(settings.http2Settings().logFrames())).atop(this.hpackCoding(masterHttpHeaderParser, settings.parserSettings()));
        Set<String> frameTypesForThrottle = this.getFrameTypesForThrottle(settings.http2Settings());
        BidiFlow flowWithPossibleThrottle = frameTypesForThrottle.nonEmpty() ? this.BidiFlowExt(initialFlow.atop(this.rapidResetMitigation(settings.http2Settings(), frameTypesForThrottle))).atopKeepLeft(this.framing(log)) : initialFlow.atop(this.framing(log));
        return flowWithPossibleThrottle.atop(this.errorHandling(log)).atop(this.idleTimeoutIfConfigured(ServerSettings$.MODULE$.timeoutsShortcut(settings).idleTimeout()));
    }

    public Seq<FrameEvent.Setting> serverStack$default$3() {
        return package$.MODULE$.Nil();
    }

    public boolean serverStack$default$4() {
        return false;
    }

    public BidiFlow<HttpRequest, ByteString, ByteString, HttpResponse, NotUsed> clientStack(ClientConnectionSettings settings, LoggingAdapter log, TelemetrySpi telemetry) {
        HttpHeaderParser masterHttpHeaderParser = HttpHeaderParser$.MODULE$.apply(settings.parserSettings(), log);
        return telemetry.client().atop(this.httpLayerClient(masterHttpHeaderParser, settings, log)).atop(this.clientDemux(settings.http2Settings(), masterHttpHeaderParser)).atop(FrameLogger$.MODULE$.logFramesIfEnabled(settings.http2Settings().logFrames())).atop(this.hpackCoding(masterHttpHeaderParser, settings.parserSettings())).atop(this.framingClient(log)).atop(this.errorHandling(log)).atop(this.idleTimeoutIfConfigured(settings.idleTimeout()));
    }

    public BidiFlow<HttpRequest, Http2SubStream, Http2SubStream, HttpResponse, NotUsed> httpLayerClient(HttpHeaderParser masterHttpHeaderParser, ClientConnectionSettings settings, LoggingAdapter log) {
        return BidiFlow$.MODULE$.fromFlows((Graph)Flow$.MODULE$.apply().statefulMap((Function0 & Serializable)() -> new RequestRendering(settings, log), (Function2 & Serializable)(renderer, request) -> Tuple2$.MODULE$.apply(renderer, (Object)renderer.apply(request)), (Function1 & Serializable)_$1 -> None$.MODULE$), StreamUtils$.MODULE$.statefulAttrsMap((Function1 & Serializable)attrs -> {
            HttpHeaderParser headerParser = masterHttpHeaderParser.createShallowCopy();
            return (Function1 & Serializable)stream -> (HttpResponse)ResponseParsing$.MODULE$.parseResponse(headerParser, settings.parserSettings(), (Attributes)attrs).apply(stream);
        }));
    }

    public BidiFlow<ByteString, ByteString, ByteString, ByteString, NotUsed> idleTimeoutIfConfigured(Duration timeout) {
        Duration duration = timeout;
        if (duration instanceof FiniteDuration) {
            FiniteDuration f = (FiniteDuration)duration;
            return HttpConnectionIdleTimeoutBidi$.MODULE$.apply(f, (Option<InetSocketAddress>)None$.MODULE$);
        }
        return BidiFlow$.MODULE$.identity();
    }

    public BidiFlow<ByteString, ByteString, ByteString, ByteString, NotUsed> errorHandling(LoggingAdapter log) {
        return BidiFlow$.MODULE$.fromFlows(StreamUtils$.MODULE$.encodeErrorAndComplete((Function1 & Serializable)x$1 -> {
            Option option;
            Throwable throwable = x$1;
            if (throwable instanceof Http2Compliance.Http2ProtocolException) {
                Http2Compliance.Http2ProtocolException ex = (Http2Compliance.Http2ProtocolException)throwable;
                if (log.isDebugEnabled()) {
                    log.debug(new StringBuilder(71).append("HTTP2 connection failed with error [").append(ex.getMessage()).append("]. Sending ").append(ex.errorCode()).append(" and closing connection.").toString());
                }
                return FrameRenderer$.MODULE$.render(FrameEvent$GoAwayFrame$.MODULE$.apply(0, ex.errorCode(), FrameEvent$GoAwayFrame$.MODULE$.$lessinit$greater$default$3()));
            }
            if (throwable instanceof StreamTcpException) {
                StreamTcpException ex = (StreamTcpException)throwable;
                throw ex;
            }
            if (throwable instanceof HttpIdleTimeoutException) {
                HttpIdleTimeoutException ex = (HttpIdleTimeoutException)throwable;
                throw ex;
            }
            if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                Throwable throwable2;
                Throwable ex = throwable2 = (Throwable)option.get();
                log.error(new StringBuilder(85).append("HTTP2 connection failed with error [").append(ex.getMessage()).append("]. Sending INTERNAL_ERROR and closing connection.").toString());
                return FrameRenderer$.MODULE$.render(FrameEvent$GoAwayFrame$.MODULE$.apply(0, Http2Protocol$ErrorCode$INTERNAL_ERROR$.MODULE$, FrameEvent$GoAwayFrame$.MODULE$.$lessinit$greater$default$3()));
            }
            throw new MatchError((Object)throwable);
        }), (Graph)Flow$.MODULE$.apply());
    }

    public BidiFlow<FrameEvent, ByteString, ByteString, FrameEvent, NotUsed> framing(LoggingAdapter log) {
        return BidiFlow$.MODULE$.fromFlows((Graph)Flow$.MODULE$.apply().map((Function1 & Serializable)frame -> FrameRenderer$.MODULE$.render((FrameEvent)frame)), (Graph)Flow$.MODULE$.apply().via((Graph)new Http2FrameParsing(true, log)));
    }

    public BidiFlow<FrameEvent, ByteString, ByteString, FrameEvent, NotUsed> framingClient(LoggingAdapter log) {
        return BidiFlow$.MODULE$.fromFlows((Graph)Flow$.MODULE$.apply().map((Function1 & Serializable)frame -> FrameRenderer$.MODULE$.render((FrameEvent)frame)).prepend((Graph)Source$.MODULE$.single((Object)Http2Protocol$.MODULE$.ClientConnectionPreface())), (Graph)Flow$.MODULE$.apply().via((Graph)new Http2FrameParsing(false, log)));
    }

    private BidiFlow<FrameEvent, FrameEvent, FrameEvent, FrameEvent, NotUsed> rapidResetMitigation(Http2ServerSettings settings, Set<String> frameTypesForThrottle) {
        return BidiFlow$.MODULE$.fromFlows((Graph)Flow$.MODULE$.apply(), (Graph)Flow$.MODULE$.apply().throttle(settings.frameTypeThrottleCost(), settings.frameTypeThrottleInterval(), settings.frameTypeThrottleBurst(), (Function1 & Serializable)event -> this.frameCost$1((Set)frameTypesForThrottle, (FrameEvent)event), (ThrottleMode)ThrottleMode.Enforcing$.MODULE$));
    }

    private Set<String> getFrameTypesForThrottle(Http2ServerSettings settings) {
        Set<String> set = settings.frameTypeThrottleFrameTypes();
        if (set.isEmpty()) {
            return Predef$.MODULE$.Set().empty();
        }
        return (Set)set.flatMap((Function1 & Serializable)frameType -> MODULE$.frameTypeAliasToFrameTypeName((String)frameType));
    }

    public Option<String> frameTypeAliasToFrameTypeName(String frameType) {
        String string = frameType.toLowerCase();
        switch (string == null ? 0 : string.hashCode()) {
            case -1825599128: {
                if (!"push-promise".equals(string)) break;
                return Some$.MODULE$.apply((Object)"PushPromiseFrame");
            }
            case -1165461084: {
                if (!"priority".equals(string)) break;
                return Some$.MODULE$.apply((Object)"PriorityFrame");
            }
            case -756386249: {
                if (!"continuation".equals(string)) break;
                return Some$.MODULE$.apply((Object)"ContinuationFrame");
            }
            case 3441010: {
                if (!"ping".equals(string)) break;
                return Some$.MODULE$.apply((Object)"PingFrame");
            }
            case 108404047: {
                if (!"reset".equals(string)) break;
                return Some$.MODULE$.apply((Object)"RstStreamFrame");
            }
            case 146000051: {
                if (!"go-away".equals(string)) break;
                return Some$.MODULE$.apply((Object)"GoAwayFrame");
            }
            case 462059846: {
                if (!"window-update".equals(string)) break;
                return Some$.MODULE$.apply((Object)"WindowUpdateFrame");
            }
            case 795307910: {
                if (!"headers".equals(string)) break;
                return Some$.MODULE$.apply((Object)"HeadersFrame");
            }
        }
        return None$.MODULE$;
    }

    public BidiFlow<FrameEvent, FrameEvent, FrameEvent, FrameEvent, NotUsed> hpackCoding(HttpHeaderParser masterHttpHeaderParser, ParserSettings parserSettings) {
        return BidiFlow$.MODULE$.fromFlows((Graph)Flow$.MODULE$.apply().via((Graph)HeaderCompression$.MODULE$), (Graph)Flow$.MODULE$.apply().via((Graph)new HeaderDecompression(masterHttpHeaderParser, parserSettings)));
    }

    public BidiFlow<Http2SubStream, FrameEvent, FrameEvent, Http2SubStream, ServerTerminator> serverDemux(Http2ServerSettings settings, Seq<FrameEvent.Setting> initialDemuxerSettings, boolean upgraded) {
        return BidiFlow$.MODULE$.fromGraph((Graph)new Http2ServerDemux(settings, initialDemuxerSettings, upgraded));
    }

    public BidiFlow<Http2SubStream, FrameEvent, FrameEvent, Http2SubStream, ServerTerminator> clientDemux(Http2ClientSettings settings, HttpHeaderParser masterHttpHeaderParser) {
        return BidiFlow$.MODULE$.fromGraph((Graph)new Http2ClientDemux(settings, masterHttpHeaderParser));
    }

    public BidiFlow<HttpResponse, Http2SubStream, Http2SubStream, HttpRequest, NotUsed> httpLayer(ServerSettings settings, LoggingAdapter log, DateHeaderRendering dateHeaderRendering) {
        ParserSettings parserSettings = settings.parserSettings();
        HttpHeaderParser masterHttpHeaderParser = HttpHeaderParser$.MODULE$.apply(parserSettings, log);
        return BidiFlow$.MODULE$.fromFlows((Graph)Flow$.MODULE$.apply().map((Function1)new ResponseRendering(settings, log, dateHeaderRendering)), (Graph)Flow$.MODULE$.apply().via(StreamUtils$.MODULE$.statefulAttrsMap((Function1 & Serializable)attrs -> {
            HttpHeaderParser headerParser = masterHttpHeaderParser.createShallowCopy();
            return RequestParsing$.MODULE$.parseRequest(headerParser, settings, (Attributes)attrs);
        })));
    }

    public Flow<HttpRequest, HttpResponse, NotUsed> handleWithStreamIdHeader(int parallelism, Function1<HttpRequest, Future<HttpResponse>> handler, ExecutionContext ec) {
        return (Flow)Flow$.MODULE$.apply().mapAsyncUnordered(parallelism, (Function1 & Serializable)req -> Future$.MODULE$.apply(() -> Http2Blueprint$.handleWithStreamIdHeader$$anonfun$1$$anonfun$1(handler, req, ec), ec).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public void logParsingError(ErrorInfo info, LoggingAdapter log, ParserSettings.ErrorLoggingVerbosity setting) {
        ParserSettings.ErrorLoggingVerbosity errorLoggingVerbosity = setting;
        if (ParserSettings$ErrorLoggingVerbosity$Off$.MODULE$.equals(errorLoggingVerbosity)) {
            return;
        }
        if (ParserSettings$ErrorLoggingVerbosity$Simple$.MODULE$.equals(errorLoggingVerbosity)) {
            log.warning(info.summary());
            return;
        }
        if (ParserSettings$ErrorLoggingVerbosity$Full$.MODULE$.equals(errorLoggingVerbosity)) {
            log.warning(info.formatPretty());
            return;
        }
        throw new MatchError((Object)errorLoggingVerbosity);
    }

    public BidiFlow<ByteString, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, ByteString, NotUsed> unwrapTls() {
        return unwrapTls;
    }

    public final <I1, O1, I2, O2, Mat> Http2Blueprint.BidiFlowExt<I1, O1, I2, O2, Mat> BidiFlowExt(BidiFlow<I1, O1, I2, O2, Mat> bidi) {
        return new Http2Blueprint.BidiFlowExt<I1, O1, I2, O2, Mat>(bidi);
    }

    private final int frameCost$1(Set frameTypesForThrottle$1, FrameEvent event) {
        if (frameTypesForThrottle$1.contains((Object)event.frameTypeName())) {
            return 1;
        }
        return 0;
    }

    private static final Future handleWithStreamIdHeader$$anonfun$1$$anonfun$1(Function1 handler$2, HttpRequest req$1, ExecutionContext ec$2) {
        Future response = (Future)handler$2.apply((Object)req$1);
        Option option = req$1.attribute((AttributeKey)Http2$.MODULE$.streamId(), (JavaMapping)JavaMapping$.MODULE$.attributeKey());
        if (option instanceof Some) {
            int streamIdHeader = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            return response.map((Function1 & Serializable)_$2 -> (HttpResponse)_$2.addAttribute((AttributeKey)Http2$.MODULE$.streamId(), BoxesRunTime.boxToInteger((int)streamIdHeader)), ec$2);
        }
        if (None$.MODULE$.equals(option)) {
            return response;
        }
        throw new MatchError((Object)option);
    }
}

