/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.http2;

import java.io.Serializable;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLEngine;
import org.apache.pekko.Done$;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.ExecutionContexts$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.engine.HttpConnectionIdleTimeoutBidi$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent;
import org.apache.pekko.http.impl.engine.http2.Http2$;
import org.apache.pekko.http.impl.engine.http2.Http2AlpnSupport$;
import org.apache.pekko.http.impl.engine.http2.Http2Blueprint$;
import org.apache.pekko.http.impl.engine.http2.NoOpTelemetry$;
import org.apache.pekko.http.impl.engine.http2.ProtocolSwitch$;
import org.apache.pekko.http.impl.engine.http2.TelemetryAttributes$;
import org.apache.pekko.http.impl.engine.http2.TelemetrySpi;
import org.apache.pekko.http.impl.engine.http2.TelemetrySpi$;
import org.apache.pekko.http.impl.engine.server.GracefulTerminatorStage$;
import org.apache.pekko.http.impl.engine.server.MasterServerTerminator;
import org.apache.pekko.http.impl.engine.server.ServerTerminator;
import org.apache.pekko.http.impl.engine.server.UpgradeToOtherProtocolResponseHeader$;
import org.apache.pekko.http.impl.util.LogByteStringTools$;
import org.apache.pekko.http.javadsl.ConnectionContext;
import org.apache.pekko.http.javadsl.model.AttributeKey;
import org.apache.pekko.http.scaladsl.DeprecatedSslContextParameters;
import org.apache.pekko.http.scaladsl.Http;
import org.apache.pekko.http.scaladsl.Http$;
import org.apache.pekko.http.scaladsl.Http$ServerBinding$;
import org.apache.pekko.http.scaladsl.HttpExt;
import org.apache.pekko.http.scaladsl.HttpsConnectionContext;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.HttpResponse$;
import org.apache.pekko.http.scaladsl.model.StatusCodes$;
import org.apache.pekko.http.scaladsl.model.headers.Connection;
import org.apache.pekko.http.scaladsl.model.headers.Connection$;
import org.apache.pekko.http.scaladsl.model.headers.RawHeader;
import org.apache.pekko.http.scaladsl.model.headers.Upgrade;
import org.apache.pekko.http.scaladsl.model.headers.Upgrade$;
import org.apache.pekko.http.scaladsl.model.headers.UpgradeProtocol;
import org.apache.pekko.http.scaladsl.model.headers.UpgradeProtocol$;
import org.apache.pekko.http.scaladsl.model.http2.Http2SettingsHeader$;
import org.apache.pekko.http.scaladsl.settings.ClientConnectionSettings;
import org.apache.pekko.http.scaladsl.settings.ServerSettings;
import org.apache.pekko.http.scaladsl.settings.ServerSettings$;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Attributes$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.IgnoreComplete$;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.TLSClosing;
import org.apache.pekko.stream.TLSClosing$;
import org.apache.pekko.stream.TLSProtocol;
import org.apache.pekko.stream.impl.io.TlsUtils$;
import org.apache.pekko.stream.scaladsl.BidiFlow;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Keep$;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.stream.scaladsl.TLS$;
import org.apache.pekko.stream.scaladsl.TLSPlacebo$;
import org.apache.pekko.stream.scaladsl.Tcp;
import org.apache.pekko.stream.scaladsl.Tcp$;
import org.apache.pekko.util.ByteString;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;
import scala.util.control.NonFatal$;

@InternalApi
public final class Http2Ext
implements Extension {
    private final ActorSystem system;
    private final HttpExt http;
    private final TelemetrySpi telemetry;
    private final Connection ConnectionUpgradeHeader;
    private final Upgrade UpgradeHeader;

    public Http2Ext(ActorSystem system) {
        this.system = system;
        int DefaultPortForProtocol = -1;
        this.http = Http$.MODULE$.apply(system);
        this.telemetry = TelemetrySpi$.MODULE$.create(system);
        this.ConnectionUpgradeHeader = Connection$.MODULE$.apply((Seq<String>)((Seq)new .colon.colon((Object)"upgrade", (List)Nil$.MODULE$)));
        this.UpgradeHeader = Upgrade$.MODULE$.apply((Seq<UpgradeProtocol>)((Seq)new .colon.colon((Object)UpgradeProtocol$.MODULE$.apply("h2c", UpgradeProtocol$.MODULE$.$lessinit$greater$default$2()), (List)Nil$.MODULE$)));
    }

    public ActorSystem system() {
        return this.system;
    }

    public HttpExt http() {
        return this.http;
    }

    public TelemetrySpi telemetry() {
        return this.telemetry;
    }

    public Future<Http.ServerBinding> bindAndHandleAsync(Function1<HttpRequest, Future<HttpResponse>> handler, String string, int port, org.apache.pekko.http.scaladsl.ConnectionContext connectionContext, ServerSettings settings, LoggingAdapter log, Materializer fm) {
        Function2 & Serializable httpPlusSwitching;
        Function2 & Serializable intersect;
        if (((ConnectionContext)((Object)connectionContext)).isSecure()) {
            HttpsConnectionContext httpsConnectionContext = (HttpsConnectionContext)connectionContext;
            intersect = (Function2 & Serializable)(http1, http2) -> this.httpsWithAlpn(httpsConnectionContext, (Flow<TLSProtocol.SslTlsInbound, TLSProtocol.SslTlsOutbound, ServerTerminator>)http1, (Flow<TLSProtocol.SslTlsInbound, TLSProtocol.SslTlsOutbound, ServerTerminator>)http2);
        } else {
            intersect = httpPlusSwitching = (Function2 & Serializable)(http1, http2) -> Http2$.MODULE$.priorKnowledge((Flow<TLSProtocol.SslTlsInbound, TLSProtocol.SslTlsOutbound, ServerTerminator>)http1, (Flow<TLSProtocol.SslTlsInbound, TLSProtocol.SslTlsOutbound, ServerTerminator>)http2);
        }
        int effectivePort = port >= 0 ? port : (((ConnectionContext)((Object)connectionContext)).isSecure() ? settings.defaultHttpsPort() : settings.defaultHttpPort());
        Flow http12 = ((Flow)Flow$.MODULE$.apply().mapAsync(settings.pipeliningLimit(), this.handleUpgradeRequests(handler, settings, log))).joinMat((Graph)GracefulTerminatorStage$.MODULE$.apply(this.system(), settings).atop(this.http().serverLayer(settings, this.http().serverLayer$default$2(), log, this.http().serverLayer$default$4())), Keep$.MODULE$.right());
        Flow http22 = Http2Blueprint$.MODULE$.handleWithStreamIdHeader(settings.http2Settings().maxConcurrentStreams(), handler, (ExecutionContext)this.system().dispatcher()).joinMat(Http2Blueprint$.MODULE$.serverStackTls(settings, log, this.telemetry(), Http$.MODULE$.apply((ClassicActorSystemProvider)this.system()).dateHeaderRendering()), Keep$.MODULE$.right());
        MasterServerTerminator masterTerminator = new MasterServerTerminator(log);
        TelemetrySpi telemetrySpi = this.telemetry();
        NoOpTelemetry$ noOpTelemetry$ = NoOpTelemetry$.MODULE$;
        return (Future)((Source)((Tcp)Tcp$.MODULE$.apply((ClassicActorSystemProvider)this.system())).bind(string, effectivePort, settings.backlog(), settings.socketOptions(), false, (Duration)Duration$.MODULE$.Inf()).via(!(telemetrySpi != null ? !telemetrySpi.equals(noOpTelemetry$) : noOpTelemetry$ != null) ? Flow$.MODULE$.apply() : this.telemetry().serverBinding()).mapAsyncUnordered(settings.maxConnections(), (Function1 & Serializable)incoming -> {
            Future future;
            try {
                future = ((Future)((Flow)((Flow)httpPlusSwitching.apply((Object)http12, (Object)http22)).addAttributes(this.prepareServerAttributes(settings, (Tcp.IncomingConnection)incoming)).watchTermination((Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        Future connectionTerminatorF = (Future)tuple2._1();
                        Future future = (Future)tuple2._2();
                        connectionTerminatorF.foreach((Function1)(JProcedure1 & Serializable)connectionTerminator -> {
                            masterTerminator.registerConnection((ServerTerminator)connectionTerminator, (ExecutionContext)fm.executionContext());
                            future.onComplete((Function1)(JProcedure1 & Serializable)_$1 -> masterTerminator.removeConnection((ServerTerminator)connectionTerminator), (ExecutionContext)fm.executionContext());
                        }, (ExecutionContext)fm.executionContext());
                        return future;
                    }
                    throw new MatchError((Object)tuple2);
                })).join((Graph)HttpConnectionIdleTimeoutBidi$.MODULE$.apply(ServerSettings$.MODULE$.timeoutsShortcut(settings).idleTimeout(), (Option<InetSocketAddress>)Some$.MODULE$.apply((Object)incoming.remoteAddress())).join((Graph)incoming.flow())).addAttributes(Http$.MODULE$.cancellationStrategyAttributeForDelay(settings.streamCancellationDelay())).run(fm)).recover((PartialFunction)new Serializable(){

                    public final boolean isDefinedAt(Throwable x) {
                        Option option;
                        Throwable throwable = x;
                        if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                            Throwable throwable2;
                            Throwable ex = throwable2 = (Throwable)option.get();
                            return true;
                        }
                        return false;
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Option option;
                        Throwable throwable = x;
                        if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                            Throwable throwable2;
                            Throwable ex = throwable2 = (Throwable)option.get();
                            return Done$.MODULE$;
                        }
                        return function1.apply((Object)x);
                    }
                }, ExecutionContexts$.MODULE$.parasitic());
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = (Throwable)option.get();
                    log.error(e, "Could not materialize handling flow for {}", incoming);
                    throw e;
                }
                throw throwable;
            }
            return future;
        })).mapMaterializedValue((Function1 & Serializable)_$2 -> _$2.map((Function1 & Serializable)tcpBinding -> Http$ServerBinding$.MODULE$.apply(tcpBinding.localAddress(), (Function0<Future<BoxedUnit>>)(Function0 & Serializable)() -> tcpBinding.unbind(), (Function1<FiniteDuration, Future<Http.HttpTerminated>>)(Function1 & Serializable)timeout -> masterTerminator.terminate((FiniteDuration)timeout, (ExecutionContext)fm.executionContext())), (ExecutionContext)fm.executionContext())).to((Graph)Sink$.MODULE$.ignore()).run(fm);
    }

    public int bindAndHandleAsync$default$3() {
        return -1;
    }

    public ServerSettings bindAndHandleAsync$default$5() {
        return (ServerSettings)ServerSettings$.MODULE$.apply(this.system());
    }

    public LoggingAdapter bindAndHandleAsync$default$6() {
        return this.system().log();
    }

    private Attributes prepareServerAttributes(ServerSettings settings, Tcp.IncomingConnection incoming) {
        Attributes attrs = Http$.MODULE$.prepareAttributes(settings, incoming);
        TelemetrySpi telemetrySpi = this.telemetry();
        NoOpTelemetry$ noOpTelemetry$ = NoOpTelemetry$.MODULE$;
        if (!(telemetrySpi != null ? !telemetrySpi.equals(noOpTelemetry$) : noOpTelemetry$ != null)) {
            return attrs;
        }
        return attrs.and(incoming.flow().traversalBuilder().attributes());
    }

    private Function1<HttpRequest, Future<HttpResponse>> handleUpgradeRequests(Function1<HttpRequest, Future<HttpResponse>> handler, ServerSettings settings, LoggingAdapter log) {
        return (Function1 & Serializable)req -> {
            Upgrade upgrade;
            Option option = req.header(ClassTag$.MODULE$.apply(Upgrade.class));
            if (option instanceof Some && (upgrade = (Upgrade)((Some)option).value()).protocols().exists((Function1 & Serializable)_$3 -> _$3.name().equalsIgnoreCase("h2c"))) {
                SeqOps seqOps;
                Seq upgradeSettings;
                log.debug("Got h2c upgrade request from HTTP/1.1 to HTTP2");
                Seq seq = upgradeSettings = (Seq)req.headers().collect((PartialFunction)new Serializable(log){
                    private final LoggingAdapter log$3;
                    {
                        this.log$3 = log$4;
                    }

                    public final boolean isDefinedAt(HttpHeader x) {
                        HttpHeader httpHeader = x;
                        if (httpHeader instanceof RawHeader) {
                            RawHeader raw = (RawHeader)httpHeader;
                            String string = raw.lowercaseName();
                            String string2 = Http2SettingsHeader$.MODULE$.name();
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                return true;
                            }
                        }
                        return false;
                    }

                    public final Object applyOrElse(HttpHeader x, Function1 function1) {
                        HttpHeader httpHeader = x;
                        if (httpHeader instanceof RawHeader) {
                            RawHeader raw = (RawHeader)httpHeader;
                            String string = raw.lowercaseName();
                            String string2 = Http2SettingsHeader$.MODULE$.name();
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                return Http2SettingsHeader$.MODULE$.parse(raw.value(), this.log$3);
                            }
                        }
                        return function1.apply((Object)x);
                    }
                });
                if (seq != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = Seq$.MODULE$.unapplySeq((SeqOps)seq), 1) == 0) {
                    Try try_ = (Try)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                    if (try_ instanceof Success) {
                        Seq settingsFromHeader = (Seq)((Success)try_).value();
                        Source injectedRequest = Source$.MODULE$.single((Object)req.addAttribute((AttributeKey)Http2$.MODULE$.streamId(), BoxesRunTime.boxToInteger((int)1)));
                        Flow serverLayer = Flow$.MODULE$.fromGraph((Graph)((Flow)Flow$.MODULE$.apply().watchTermination(Keep$.MODULE$.right()).prepend((Graph)injectedRequest)).via(Http2Blueprint$.MODULE$.handleWithStreamIdHeader(settings.http2Settings().maxConcurrentStreams(), handler, (ExecutionContext)this.system().dispatcher())).joinMat(Http2Blueprint$.MODULE$.serverStack(settings, log, (Seq<FrameEvent.Setting>)settingsFromHeader, true, this.telemetry(), Http$.MODULE$.apply((ClassicActorSystemProvider)this.system()).dateHeaderRendering()), Keep$.MODULE$.left()));
                        return Future$.MODULE$.successful((Object)HttpResponse$.MODULE$.apply(StatusCodes$.MODULE$.SwitchingProtocols(), (Seq<HttpHeader>)((Seq)((SeqOps)new .colon.colon((Object)this.ConnectionUpgradeHeader(), (List)new .colon.colon((Object)this.UpgradeHeader(), (List)new .colon.colon((Object)UpgradeToOtherProtocolResponseHeader$.MODULE$.apply((Flow<ByteString, ByteString, Object>)serverLayer), (List)Nil$.MODULE$))))), HttpResponse$.MODULE$.apply$default$3(), HttpResponse$.MODULE$.apply$default$4()));
                    }
                    if (try_ instanceof Failure) {
                        Throwable e = ((Failure)try_).exception();
                        log.warning("Failed to parse http2-settings header in upgrade [{}], continuing with HTTP/1.1", (Object)e.getMessage());
                        return (Future)handler.apply(req);
                    }
                }
                log.debug("Invalid upgrade request (http2-settings header missing or repeated)");
                return (Future)handler.apply(req);
            }
            return (Future)handler.apply(req);
        };
    }

    public Connection ConnectionUpgradeHeader() {
        return this.ConnectionUpgradeHeader;
    }

    public Upgrade UpgradeHeader() {
        return this.UpgradeHeader;
    }

    public Flow<ByteString, ByteString, Future<ServerTerminator>> httpsWithAlpn(HttpsConnectionContext httpsContext, Flow<TLSProtocol.SslTlsInbound, TLSProtocol.SslTlsOutbound, ServerTerminator> http1, Flow<TLSProtocol.SslTlsInbound, TLSProtocol.SslTlsOutbound, ServerTerminator> http2) {
        ObjectRef chosenProtocol = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef eng = ObjectRef.create((Object)None$.MODULE$);
        BidiFlow tls = TLS$.MODULE$.apply((Function0 & Serializable)() -> Http2Ext.createEngine$1(httpsContext, eng, chosenProtocol), (Function1 & Serializable)_$4 -> Success$.MODULE$.apply((Object)BoxedUnit.UNIT), (TLSClosing)IgnoreComplete$.MODULE$);
        return ProtocolSwitch$.MODULE$.apply((Function1<TLSProtocol.SessionBytes, String>)(Function1 & Serializable)_$5 -> Http2Ext.getChosenProtocol$1(chosenProtocol), http1, http2).join((Graph)tls);
    }

    public Flow<HttpRequest, HttpResponse, Future<Http.OutgoingConnection>> outgoingConnection(String host, int port, HttpsConnectionContext connectionContext, ClientConnectionSettings clientConnectionSettings, LoggingAdapter log) {
        BidiFlow stack = Http2Blueprint$.MODULE$.clientStack(clientConnectionSettings, log, this.telemetry()).addAttributes(this.prepareClientAttributes(host, port)).atop(Http2Blueprint$.MODULE$.unwrapTls()).atop(LogByteStringTools$.MODULE$.logTLSBidiBySetting("client-plain-text", clientConnectionSettings.logUnencryptedNetworkBytes())).atop((Graph)TLS$.MODULE$.apply((Function0 & Serializable)() -> Http2Ext.createEngine$2(connectionContext, host, port), TLSClosing$.MODULE$.eagerClose()));
        return stack.joinMat(clientConnectionSettings.transport().connectTo(host, port, clientConnectionSettings, this.system().classicSystem()), Keep$.MODULE$.right()).addAttributes(Http$.MODULE$.cancellationStrategyAttributeForDelay(clientConnectionSettings.streamCancellationDelay()));
    }

    public Flow<HttpRequest, HttpResponse, Future<Http.OutgoingConnection>> outgoingConnectionPriorKnowledge(String host, int port, ClientConnectionSettings clientConnectionSettings, LoggingAdapter log) {
        BidiFlow stack = Http2Blueprint$.MODULE$.clientStack(clientConnectionSettings, log, this.telemetry()).addAttributes(this.prepareClientAttributes(host, port)).atop(Http2Blueprint$.MODULE$.unwrapTls()).atop(LogByteStringTools$.MODULE$.logTLSBidiBySetting("client-plain-text", clientConnectionSettings.logUnencryptedNetworkBytes())).atop((Graph)TLSPlacebo$.MODULE$.apply());
        return stack.joinMat(clientConnectionSettings.transport().connectTo(host, port, clientConnectionSettings, this.system().classicSystem()), Keep$.MODULE$.right()).addAttributes(Http$.MODULE$.cancellationStrategyAttributeForDelay(clientConnectionSettings.streamCancellationDelay()));
    }

    private Attributes prepareClientAttributes(String serverHost, int port) {
        TelemetrySpi telemetrySpi = this.telemetry();
        NoOpTelemetry$ noOpTelemetry$ = NoOpTelemetry$.MODULE$;
        if (!(telemetrySpi != null ? !telemetrySpi.equals(noOpTelemetry$) : noOpTelemetry$ != null)) {
            return Attributes$.MODULE$.none();
        }
        return TelemetryAttributes$.MODULE$.prepareClientFlowAttributes(serverHost, port);
    }

    private static final void setChosenProtocol$1(ObjectRef chosenProtocol$1, String protocol) {
        if (((Option)chosenProtocol$1.elem).isEmpty()) {
            chosenProtocol$1.elem = Some$.MODULE$.apply((Object)protocol);
            return;
        }
        throw new IllegalStateException("ChosenProtocol was set twice. Http2.serverLayer is not reusable.");
    }

    private static final String getChosenProtocol$1$$anonfun$1() {
        return Http2AlpnSupport$.MODULE$.HTTP11();
    }

    private static final String getChosenProtocol$1(ObjectRef chosenProtocol$2) {
        return (String)((Option)chosenProtocol$2.elem).getOrElse(Http2Ext::getChosenProtocol$1$$anonfun$1);
    }

    private static final SSLEngine createEngine$1(HttpsConnectionContext httpsContext$2, ObjectRef eng$1, ObjectRef chosenProtocol$3) {
        SSLEngine sSLEngine;
        Either<DeprecatedSslContextParameters, Function1<Option<Tuple2<String, Object>>, SSLEngine>> either = httpsContext$2.sslContextData();
        if (either instanceof Left) {
            DeprecatedSslContextParameters ssl = (DeprecatedSslContextParameters)((Left)either).value();
            SSLEngine e = ssl.sslContext().createSSLEngine();
            TlsUtils$.MODULE$.applySessionParameters(e, ssl.firstSession());
            sSLEngine = e;
        } else if (either instanceof Right) {
            Function1 e = (Function1)((Right)either).value();
            sSLEngine = (SSLEngine)e.apply((Object)None$.MODULE$);
        } else {
            throw new MatchError(either);
        }
        SSLEngine engine = sSLEngine;
        eng$1.elem = Some$.MODULE$.apply((Object)engine);
        engine.setUseClientMode(false);
        return Http2AlpnSupport$.MODULE$.enableForServer(engine, (Function1<String, BoxedUnit>)(JProcedure1 & Serializable)protocol -> Http2Ext.setChosenProtocol$1(chosenProtocol$3, protocol));
    }

    private static final SSLEngine createEngine$2(HttpsConnectionContext connectionContext$1, String host$1, int port$1) {
        SSLEngine sSLEngine;
        Either<DeprecatedSslContextParameters, Function1<Option<Tuple2<String, Object>>, SSLEngine>> either = connectionContext$1.sslContextData();
        if (either instanceof Left) {
            DeprecatedSslContextParameters ssl = (DeprecatedSslContextParameters)((Left)either).value();
            SSLEngine e = ssl.sslContext().createSSLEngine(host$1, port$1);
            TlsUtils$.MODULE$.applySessionParameters(e, ssl.firstSession());
            sSLEngine = e;
        } else if (either instanceof Right) {
            Function1 e = (Function1)((Right)either).value();
            sSLEngine = (SSLEngine)e.apply((Object)Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)host$1, (Object)BoxesRunTime.boxToInteger((int)port$1))));
        } else {
            throw new MatchError(either);
        }
        SSLEngine engine = sSLEngine;
        engine.setUseClientMode(true);
        Http2AlpnSupport$.MODULE$.clientSetApplicationProtocols(engine, new String[]{"h2"});
        return engine;
    }
}

