/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.ws;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.engine.ws.FrameData;
import org.apache.pekko.http.impl.engine.ws.FrameData$;
import org.apache.pekko.http.impl.engine.ws.FrameEvent;
import org.apache.pekko.http.impl.engine.ws.FrameEventRenderer$;
import org.apache.pekko.http.impl.engine.ws.FrameHeader;
import org.apache.pekko.http.impl.engine.ws.FrameStart;
import org.apache.pekko.http.impl.engine.ws.FrameStart$;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@InternalApi
public final class FrameEventRenderer
extends GraphStage<FlowShape<FrameEvent, ByteString>> {
    private final Inlet in = Inlet$.MODULE$.apply("FrameEventRenderer.in");
    private final Outlet out = Outlet$.MODULE$.apply("FrameEventRenderer.out");
    private final FlowShape shape = FlowShape$.MODULE$.apply(this.in(), this.out());

    public Inlet<FrameEvent> in() {
        return this.in;
    }

    public Outlet<ByteString> out() {
        return this.out;
    }

    public FlowShape<FrameEvent, ByteString> shape() {
        return this.shape;
    }

    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new GraphStageLogic(this){
            private final InHandler Initial;
            private final /* synthetic */ FrameEventRenderer $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.shape());
                this.Initial = new InHandler(this){
                    private final /* synthetic */ $anon$1 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public void onPush() {
                        FrameEvent frameEvent = (FrameEvent)this.$outer.protected$grab(this.$outer.org$apache$pekko$http$impl$engine$ws$FrameEventRenderer$_$$anon$$$outer().in());
                        if (frameEvent instanceof FrameStart) {
                            FrameStart frameStart = (FrameStart)frameEvent;
                            FrameStart frameStart2 = FrameStart$.MODULE$.unapply(frameStart);
                            FrameHeader frameHeader = frameStart2._1();
                            ByteString byteString = frameStart2._2();
                            FrameHeader header = frameHeader;
                            ByteString data = byteString;
                            FrameStart start = frameStart;
                            Predef$.MODULE$.require(header.length() >= (long)data.size());
                            if (!start.lastPart() && header.length() > 0L) {
                                this.$outer.protected$setHandler(this.$outer.org$apache$pekko$http$impl$engine$ws$FrameEventRenderer$_$$anon$$$outer().in(), this.$outer.renderData(header.length() - (long)data.length(), this));
                            }
                            this.$outer.protected$push(this.$outer.org$apache$pekko$http$impl$engine$ws$FrameEventRenderer$_$$anon$$$outer().out(), this.$outer.org$apache$pekko$http$impl$engine$ws$FrameEventRenderer$_$$anon$$$outer().org$apache$pekko$http$impl$engine$ws$FrameEventRenderer$$renderStart(start));
                            return;
                        }
                        if (frameEvent instanceof FrameData) {
                            FrameData f = (FrameData)frameEvent;
                            this.$outer.protected$fail(this.$outer.org$apache$pekko$http$impl$engine$ws$FrameEventRenderer$_$$anon$$$outer().out(), new IllegalStateException("unexpected FrameData (need FrameStart first)"));
                            return;
                        }
                        throw new MatchError((Object)frameEvent);
                    }
                };
                this.setHandler($outer.in(), this.Initial());
                this.setHandler($outer.out(), new OutHandler(this){
                    private final /* synthetic */ $anon$1 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public void onPull() {
                        this.$outer.protected$pull(this.$outer.org$apache$pekko$http$impl$engine$ws$FrameEventRenderer$_$$anon$$$outer().in());
                    }
                });
            }

            public InHandler Initial() {
                return this.Initial;
            }

            public InHandler renderData(long initialRemaining, InHandler nextState) {
                return new InHandler(initialRemaining, nextState, this){
                    private final InHandler nextState$2;
                    private long remaining;
                    private final /* synthetic */ $anon$1 $outer;
                    {
                        this.nextState$2 = nextState$1;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.remaining = initialRemaining$1;
                    }

                    public long remaining() {
                        return this.remaining;
                    }

                    public void remaining_$eq(long x$1) {
                        this.remaining = x$1;
                    }

                    public void onPush() {
                        FrameEvent frameEvent = (FrameEvent)this.$outer.protected$grab(this.$outer.org$apache$pekko$http$impl$engine$ws$FrameEventRenderer$_$$anon$$$outer().in());
                        if (frameEvent instanceof FrameData) {
                            FrameData frameData = FrameData$.MODULE$.unapply((FrameData)frameEvent);
                            ByteString byteString = frameData._1();
                            boolean bl = frameData._2();
                            ByteString data = byteString;
                            boolean lastPart = bl;
                            if ((long)data.size() > this.remaining()) {
                                throw new IllegalStateException(new StringBuilder(30).append("Expected ").append(this.remaining()).append(" frame bytes but got ").append(data.size()).toString());
                            }
                            if ((long)data.size() == this.remaining()) {
                                if (!lastPart) {
                                    throw new IllegalStateException("Frame data complete but `lastPart` flag not set");
                                }
                                this.$outer.protected$setHandler(this.$outer.org$apache$pekko$http$impl$engine$ws$FrameEventRenderer$_$$anon$$$outer().in(), this.nextState$2);
                                this.$outer.protected$push(this.$outer.org$apache$pekko$http$impl$engine$ws$FrameEventRenderer$_$$anon$$$outer().out(), data);
                                return;
                            }
                            this.remaining_$eq(this.remaining() - (long)data.size());
                            this.$outer.protected$push(this.$outer.org$apache$pekko$http$impl$engine$ws$FrameEventRenderer$_$$anon$$$outer().out(), data);
                            return;
                        }
                        if (frameEvent instanceof FrameStart) {
                            FrameStart f = (FrameStart)frameEvent;
                            this.$outer.protected$fail(this.$outer.org$apache$pekko$http$impl$engine$ws$FrameEventRenderer$_$$anon$$$outer().out(), new IllegalStateException("unexpected FrameStart (need more FrameData first)"));
                            return;
                        }
                        throw new MatchError((Object)frameEvent);
                    }
                };
            }

            public Object protected$grab(Inlet in) {
                return this.grab(in);
            }

            public void protected$setHandler(Inlet in, InHandler handler) {
                this.setHandler(in, handler);
            }

            public void protected$push(Outlet out, Object elem) {
                this.push(out, elem);
            }

            public void protected$fail(Outlet out, Throwable ex) {
                this.fail(out, ex);
            }

            public void protected$pull(Inlet in) {
                this.pull(in);
            }

            public final /* synthetic */ FrameEventRenderer org$apache$pekko$http$impl$engine$ws$FrameEventRenderer$_$$anon$$$outer() {
                return this.$outer;
            }
        };
    }

    public ByteString org$apache$pekko$http$impl$engine$ws$FrameEventRenderer$$renderStart(FrameStart start) {
        return this.renderHeader(start.header()).$plus$plus(start.data());
    }

    private ByteString renderHeader(FrameHeader header) {
        long x;
        long length = header.length();
        long l = length;
        long x2 = l;
        Tuple2 tuple2 = x2 < 126L ? Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)((int)x2)), (Object)BoxesRunTime.boxToInteger((int)0)) : ((x = l) <= 65535L ? new Tuple2.mcII.sp(126, 2) : new Tuple2.mcII.sp(127, 8));
        int lengthBits = tuple2._1$mcI$sp();
        int extraLengthBytes = tuple2._2$mcI$sp();
        int maskBytes = header.mask().isDefined() ? 4 : 0;
        int totalSize = 2 + extraLengthBytes + maskBytes;
        byte[] data = new byte[totalSize];
        int flags = FrameEventRenderer.bool$1(header.fin(), 128) | FrameEventRenderer.bool$1(header.rsv1(), 64) | FrameEventRenderer.bool$1(header.rsv2(), 32) | FrameEventRenderer.bool$1(header.rsv3(), 16);
        data[0] = (byte)(flags | header.opcode().code());
        data[1] = (byte)(FrameEventRenderer.bool$1(header.mask().isDefined(), 128) | lengthBits);
        int n = extraLengthBytes;
        switch (n) {
            case 0: {
                break;
            }
            case 2: {
                data[2] = (byte)((length & 0xFF00L) >> 8);
                data[3] = (byte)((length & 0xFFL) >> 0);
                break;
            }
            case 8: {
                FrameEventRenderer.addLongBytes$1(data, Long.rotateLeft(length, 8), 0);
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        int maskOffset = 2 + extraLengthBytes;
        header.mask().foreach((Function1)(JFunction1.mcVI.sp & Serializable)mask -> {
            data$2[maskOffset$1 + 0] = (byte)((mask & 0xFF000000) >> 24);
            data$2[maskOffset$1 + 1] = (byte)((mask & 0xFF0000) >> 16);
            data$2[maskOffset$1 + 2] = (byte)((mask & 0xFF00) >> 8);
            data$2[maskOffset$1 + 3] = (byte)((mask & 0xFF) >> 0);
        });
        return ByteString$.MODULE$.apply(data);
    }

    private static final int bool$1(boolean b, int mask) {
        if (b) {
            return mask;
        }
        return 0;
    }

    private static final void addLongBytes$1(byte[] data$1, long l, int writtenBytes) {
        while (writtenBytes < 8) {
            data$1[2 + writtenBytes] = (byte)(l & 0xFFL);
            long l2 = Long.rotateLeft(l, 8);
            int n = writtenBytes + 1;
            l = l2;
            writtenBytes = n;
        }
    }
}

