/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.model;

import java.io.Serializable;
import org.apache.pekko.http.scaladsl.model.DateTime;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.deriving.Mirror;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class DateTime$
implements Mirror.Product,
Serializable {
    private static final String[] WEEKDAYS;
    private static final String[] MONTHS;
    private static final DateTime MinValue;
    private static final DateTime MaxValue;
    public static final DateTime$ MODULE$;

    private DateTime$() {
    }

    static {
        MODULE$ = new DateTime$();
        WEEKDAYS = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        MinValue = MODULE$.apply(1800, 1, 1, MODULE$.apply$default$4(), MODULE$.apply$default$5(), MODULE$.apply$default$6());
        MaxValue = MODULE$.apply(2199, 12, 31, 23, 59, 59);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DateTime$.class);
    }

    private DateTime apply(int year, int month, int day, int hour, int minute, int second, int weekday, long clicks, boolean isLeapYear) {
        return new DateTime(year, month, day, hour, minute, second, weekday, clicks, isLeapYear);
    }

    public DateTime unapply(DateTime x$1) {
        return x$1;
    }

    public String weekday(int index) {
        return WEEKDAYS[index];
    }

    public String month(int index) {
        return MONTHS[index];
    }

    public DateTime MinValue() {
        return MinValue;
    }

    public DateTime MaxValue() {
        return MaxValue;
    }

    public DateTime apply(int year, int month, int day, int hour, int minute, int second) {
        Predef$.MODULE$.require(1800 <= year && year <= 9999, DateTime$::apply$$anonfun$1);
        Predef$.MODULE$.require(1 <= month && month <= 12, DateTime$::apply$$anonfun$2);
        Predef$.MODULE$.require(1 <= day && day <= 31, DateTime$::apply$$anonfun$3);
        Predef$.MODULE$.require(0 <= hour && hour <= 23, DateTime$::apply$$anonfun$4);
        Predef$.MODULE$.require(0 <= minute && minute <= 59, DateTime$::apply$$anonfun$5);
        Predef$.MODULE$.require(0 <= second && second <= 59, DateTime$::apply$$anonfun$6);
        int m = month - 1;
        int m7 = m % 7;
        int d = m7 * 30 + (m7 + 1 >> 1) + day;
        boolean isLeap = this.isLeapYear(year);
        if (m >= 7) {
            d += 214;
        }
        if (d >= 61) {
            --d;
        }
        if (!isLeap && d >= 60) {
            --d;
        }
        int y = year - 1;
        int yd = y / 100;
        int dn = (d += y * 365 + (y >> 2) - yd + (yd >> 2)) - 719162;
        long c = (long)(dn - 1) * 86400L + (long)hour * 3600L + (long)minute * 60L + (long)second;
        return new DateTime(year, month, day, hour, minute, second, d % 7, c * 1000L, isLeap);
    }

    public int apply$default$4() {
        return 0;
    }

    public int apply$default$5() {
        return 0;
    }

    public int apply$default$6() {
        return 0;
    }

    public DateTime apply(long clicks) {
        long c;
        Predef$.MODULE$.require(this.MinValue().clicks() <= clicks && clicks <= this.MaxValue().clicks(), DateTime$::apply$$anonfun$7);
        long s2 = c = clicks - clicks % 1000L;
        s2 = s2 >= 0L ? (s2 /= 1000L) : (s2 - 999L) / 1000L;
        int dn = (int)(s2 / 86400L);
        if ((s2 %= 86400L) < 0L) {
            s2 += 86400L;
            --dn;
        }
        int y = 400 * ((dn += 719162) / 146097) + 1;
        int d = dn % 146097;
        if (d == 146096) {
            y += 399;
            d = 365;
        } else {
            y += 100 * (d / 36524);
            y += (d %= 36524) / 1461 << 2;
            if ((d %= 1461) == 1460) {
                y += 3;
                d = 365;
            } else {
                y += d / 365;
                d %= 365;
            }
        }
        boolean isLeap = this.isLeapYear(y);
        if (!isLeap && d >= 59) {
            ++d;
        }
        if (d >= 60) {
            ++d;
        }
        int d214 = d % 214;
        int d214_61 = d214 % 61;
        int mon = (d214 / 61 << 1) + d214_61 / 31;
        if (d > 213) {
            mon += 7;
        }
        d = d214_61 % 31 + 1;
        int m = (int)(s2 / 60L);
        int h = m / 60;
        int w = (dn + 1) % 7;
        return new DateTime(y, mon + 1, d, h, m %= 60, (int)(s2 %= 60L), w, c, isLeap);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isLeapYear(int year) {
        if ((year & 3) != 0) return false;
        int q = year / 100;
        int r = year % 100;
        if (r != 0) return true;
        if ((q & 3) != 0) return false;
        return true;
    }

    public DateTime now() {
        return this.apply(System.currentTimeMillis());
    }

    public Option<DateTime> fromIsoDateTimeString(String string) {
        if (this.check$1(string, string.length())) {
            None$ none$;
            try {
                int year = this.i$1(string, 0) * 1000 + this.i$1(string, 1) * 100 + this.mul10$1(this.i$1(string, 2)) + this.i$1(string, 3);
                int month = this.mul10$1(this.i$1(string, 5)) + this.i$1(string, 6);
                int day = this.mul10$1(this.i$1(string, 8)) + this.i$1(string, 9);
                int hour = this.mul10$1(this.i$1(string, 11)) + this.i$1(string, 12);
                int min2 = this.mul10$1(this.i$1(string, 14)) + this.i$1(string, 15);
                int sec = this.mul10$1(this.i$1(string, 17)) + this.i$1(string, 18);
                none$ = Some$.MODULE$.apply((Object)this.apply(year, month, day, hour, min2, sec));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                none$ = None$.MODULE$;
            }
            return none$;
        }
        return None$.MODULE$;
    }

    public DateTime fromProduct(Product x$0) {
        return new DateTime(BoxesRunTime.unboxToInt((Object)x$0.productElement(0)), BoxesRunTime.unboxToInt((Object)x$0.productElement(1)), BoxesRunTime.unboxToInt((Object)x$0.productElement(2)), BoxesRunTime.unboxToInt((Object)x$0.productElement(3)), BoxesRunTime.unboxToInt((Object)x$0.productElement(4)), BoxesRunTime.unboxToInt((Object)x$0.productElement(5)), BoxesRunTime.unboxToInt((Object)x$0.productElement(6)), BoxesRunTime.unboxToLong((Object)x$0.productElement(7)), BoxesRunTime.unboxToBoolean((Object)x$0.productElement(8)));
    }

    private static final Object apply$$anonfun$1() {
        return "year must be >= 1800 and <= 9999";
    }

    private static final Object apply$$anonfun$2() {
        return "month must be >= 1 and <= 12";
    }

    private static final Object apply$$anonfun$3() {
        return "day must be >= 1 and <= 31";
    }

    private static final Object apply$$anonfun$4() {
        return "hour must be >= 0 and <= 23";
    }

    private static final Object apply$$anonfun$5() {
        return "minute_ must be >= 0 and <= 59";
    }

    private static final Object apply$$anonfun$6() {
        return "second must be >= 0 and <= 59";
    }

    private static final Object apply$$anonfun$7() {
        return new StringBuilder(34).append("DateTime value must be >= ").append(MODULE$.MinValue()).append(" and <= ").append(MODULE$.MaxValue()).toString();
    }

    private final char c$1(String string$1, int ix) {
        return string$1.charAt(ix);
    }

    private final boolean isDigit$1(char c) {
        return '0' <= c && c <= '9';
    }

    private final int i$1(String string$2, int ix) {
        char x = this.c$1(string$2, ix);
        Predef$.MODULE$.require(this.isDigit$1(x));
        return x - 48;
    }

    private final boolean check$1(String string$3, int len) {
        int n = len;
        if (19 == n) {
            return this.c$1(string$3, 4) == '-' && this.c$1(string$3, 7) == '-' && this.c$1(string$3, 10) == 'T' && this.c$1(string$3, 13) == ':' && this.c$1(string$3, 16) == ':';
        }
        if (24 == n) {
            return this.check$1(string$3, 19) && this.c$1(string$3, 19) == '.' && this.isDigit$1(this.c$1(string$3, 20)) && this.isDigit$1(this.c$1(string$3, 21)) && this.isDigit$1(this.c$1(string$3, 22)) && this.c$1(string$3, 23) == 'Z';
        }
        return false;
    }

    private final int mul10$1(int i) {
        return (i << 3) + (i << 1);
    }
}

