/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.model;

import com.typesafe.config.Config;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collections;
import java.util.OptionalLong;
import java.util.concurrent.CompletionStage;
import org.apache.pekko.Done;
import org.apache.pekko.NotUsed;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.annotation.DoNotInherit;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.util.EnhancedConfig$;
import org.apache.pekko.http.impl.util.J2SMapping$;
import org.apache.pekko.http.impl.util.JavaMapping$;
import org.apache.pekko.http.impl.util.JavaMapping$ContentType$;
import org.apache.pekko.http.impl.util.JavaMapping$HttpHeader$;
import org.apache.pekko.http.impl.util.JavaMapping$Implicits$;
import org.apache.pekko.http.impl.util.S2JMapping$;
import org.apache.pekko.http.impl.util.ToStrict;
import org.apache.pekko.http.javadsl.model.HttpEntity;
import org.apache.pekko.http.javadsl.model.HttpMessage;
import org.apache.pekko.http.scaladsl.model.BodyPartEntity;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.EntityStreamException;
import org.apache.pekko.http.scaladsl.model.EntityStreamSizeException$;
import org.apache.pekko.http.scaladsl.model.ErrorInfo;
import org.apache.pekko.http.scaladsl.model.HttpEntity$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$Chunk$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$ChunkStreamPart$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$Chunked$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$CloseDelimited$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$Default$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$HttpEntityScalaDSLSugar$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$IndefiniteLength$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$LastChunk$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$Limitable$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$SizeLimit$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$Strict$;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpMessage;
import org.apache.pekko.http.scaladsl.model.HttpMessage$;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.model.ResponseEntity;
import org.apache.pekko.http.scaladsl.model.UniversalEntity;
import org.apache.pekko.http.scaladsl.util.FastFuture$;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.SystemMaterializer;
import org.apache.pekko.stream.SystemMaterializer$;
import org.apache.pekko.stream.UniformFanInShape;
import org.apache.pekko.stream.UniformFanOutShape;
import org.apache.pekko.stream.scaladsl.Concat$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.GraphDSL;
import org.apache.pekko.stream.scaladsl.GraphDSL$;
import org.apache.pekko.stream.scaladsl.Partition$;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.apache.pekko.util.FutureConverters;
import org.apache.pekko.util.FutureConverters$;
import org.apache.pekko.util.OptionConverters;
import org.apache.pekko.util.OptionConverters$;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.OptionShape$;
import scala.math.Integral;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

public interface HttpEntity
extends org.apache.pekko.http.javadsl.model.HttpEntity {
    public static Strict Empty() {
        return HttpEntity$.MODULE$.Empty();
    }

    public static HttpEntity HttpEntityScalaDSLSugar(HttpEntity httpEntity) {
        return HttpEntity$.MODULE$.HttpEntityScalaDSLSugar(httpEntity);
    }

    public static Strict apply(ByteString byteString) {
        return HttpEntity$.MODULE$.apply(byteString);
    }

    public static Strict apply(byte[] byArray) {
        return HttpEntity$.MODULE$.apply(byArray);
    }

    public static Strict apply(ContentType contentType, ByteString byteString) {
        return HttpEntity$.MODULE$.apply(contentType, byteString);
    }

    public static Strict apply(ContentType contentType, byte[] byArray) {
        return HttpEntity$.MODULE$.apply(contentType, byArray);
    }

    public static UniversalEntity apply(ContentType contentType, long l, Source<ByteString, Object> source) {
        return HttpEntity$.MODULE$.apply(contentType, l, source);
    }

    public static Chunked apply(ContentType contentType, Source<ByteString, Object> source) {
        return HttpEntity$.MODULE$.apply(contentType, source);
    }

    public static Strict apply(ContentType.NonBinary nonBinary, String string) {
        return HttpEntity$.MODULE$.apply(nonBinary, string);
    }

    public static Strict apply(String string) {
        return HttpEntity$.MODULE$.apply(string);
    }

    public static Strict apply(ContentType.WithFixedCharset withFixedCharset, String string) {
        return HttpEntity$.MODULE$.apply(withFixedCharset, string);
    }

    @InternalApi
    public static <T extends HttpEntity> Tuple2<T, Future<BoxedUnit>> captureTermination(T t) {
        return HttpEntity$.MODULE$.captureTermination(t);
    }

    public static Strict empty(ContentType contentType) {
        return HttpEntity$.MODULE$.empty(contentType);
    }

    public static UniversalEntity fromFile(ContentType contentType, File file, int n) {
        return HttpEntity$.MODULE$.fromFile(contentType, file, n);
    }

    public static UniversalEntity fromPath(ContentType contentType, Path path, int n) {
        return HttpEntity$.MODULE$.fromPath(contentType, path, n);
    }

    public static <Mat> Source<ByteString, Mat> limitableByteSource(Source<ByteString, Mat> source) {
        return HttpEntity$.MODULE$.limitableByteSource(source);
    }

    public static <Mat> Source<ChunkStreamPart, Mat> limitableChunkSource(Source<ChunkStreamPart, Mat> source) {
        return HttpEntity$.MODULE$.limitableChunkSource(source);
    }

    public static int ordinal(HttpEntity httpEntity) {
        return HttpEntity$.MODULE$.ordinal(httpEntity);
    }

    public static int fromFile$default$3() {
        return HttpEntity$.MODULE$.fromFile$default$3();
    }

    public static int fromPath$default$3() {
        return HttpEntity$.MODULE$.fromPath$default$3();
    }

    private <T, U> CompletionStage<U> completionStageCovariant(CompletionStage<T> in) {
        return in;
    }

    @Override
    public boolean isKnownEmpty();

    public ContentType contentType();

    public Option<Object> contentLengthOption();

    public Source<ByteString, Object> dataBytes();

    public static Future toStrict$(HttpEntity $this, FiniteDuration timeout, Materializer fm) {
        return $this.toStrict(timeout, fm);
    }

    default public Future<Strict> toStrict(FiniteDuration timeout, Materializer fm) {
        Config config = fm.system().settings().config();
        return this.toStrict(timeout, EnhancedConfig$.MODULE$.getPossiblyInfiniteBytes$extension(org.apache.pekko.http.impl.util.package$.MODULE$.enhanceConfig(config), "pekko.http.parsing.max-to-strict-bytes"), fm);
    }

    public static Future toStrict$(HttpEntity $this, FiniteDuration timeout, long maxBytes, Materializer fm) {
        return $this.toStrict(timeout, maxBytes, fm);
    }

    default public Future<Strict> toStrict(FiniteDuration timeout, long maxBytes, Materializer fm) {
        long contentLength;
        Option<Object> option = this.contentLengthOption();
        if (option instanceof Some && (contentLength = BoxesRunTime.unboxToLong((Object)((Some)option).value())) > maxBytes) {
            return (Future)FastFuture$.MODULE$.failed().apply((Object)new EntityStreamException(new ErrorInfo("Request too large", new StringBuilder(48).append("Request of size ").append(contentLength).append(" was longer than the maximum of ").append(maxBytes).toString())));
        }
        return (Future)this.dataBytes().via((Graph)new ToStrict(timeout, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)maxBytes)), this.contentType())).runWith((Graph)Sink$.MODULE$.head(), fm);
    }

    public static HttpMessage.DiscardedEntity discardBytes$(HttpEntity $this, Materializer mat) {
        return $this.discardBytes(mat);
    }

    @Override
    default public HttpMessage.DiscardedEntity discardBytes(Materializer mat) {
        if (this.isStrict()) {
            return HttpMessage$.MODULE$.AlreadyDiscardedEntity();
        }
        return new HttpMessage.DiscardedEntity((Future<Done>)((Future)this.dataBytes().runWith((Graph)Sink$.MODULE$.ignore(), mat)));
    }

    public static HttpMessage.DiscardedEntity discardBytes$(HttpEntity $this, ClassicActorSystemProvider system) {
        return $this.discardBytes(system);
    }

    @Override
    default public HttpMessage.DiscardedEntity discardBytes(ClassicActorSystemProvider system) {
        return this.discardBytes(((SystemMaterializer)SystemMaterializer$.MODULE$.apply(system)).materializer());
    }

    public HttpEntity transformDataBytes(Flow<ByteString, ByteString, Object> var1);

    public static UniversalEntity transformDataBytes$(HttpEntity $this, long newContentLength, Flow transformer) {
        return $this.transformDataBytes(newContentLength, (Flow<ByteString, ByteString, Object>)transformer);
    }

    default public UniversalEntity transformDataBytes(long newContentLength, Flow<ByteString, ByteString, Object> transformer) {
        return HttpEntity$Default$.MODULE$.apply(this.contentType(), newContentLength, (Source<ByteString, Object>)this.dataBytes().via(transformer));
    }

    public HttpEntity withContentType(ContentType var1);

    @Override
    public HttpEntity withSizeLimit(long var1);

    @Override
    public HttpEntity withoutSizeLimit();

    public static org.apache.pekko.http.javadsl.model.ContentType getContentType$(HttpEntity $this) {
        return $this.getContentType();
    }

    @Override
    default public org.apache.pekko.http.javadsl.model.ContentType getContentType() {
        return this.contentType();
    }

    public static org.apache.pekko.stream.javadsl.Source getDataBytes$(HttpEntity $this) {
        return $this.getDataBytes();
    }

    @Override
    default public org.apache.pekko.stream.javadsl.Source<ByteString, Object> getDataBytes() {
        return org.apache.pekko.stream.javadsl.Source$.MODULE$.fromGraph(this.dataBytes());
    }

    public static OptionalLong getContentLengthOption$(HttpEntity $this) {
        return $this.getContentLengthOption();
    }

    @Override
    default public OptionalLong getContentLengthOption() {
        Option option = OptionConverters$.MODULE$.RichOption(this.contentLengthOption());
        return (OptionalLong)OptionConverters.RichOption$.MODULE$.toJavaPrimitive$extension(option, OptionShape$.MODULE$.longOptionShape());
    }

    public static boolean isCloseDelimited$(HttpEntity $this) {
        return $this.isCloseDelimited();
    }

    @Override
    default public boolean isCloseDelimited() {
        return false;
    }

    public static boolean isIndefiniteLength$(HttpEntity $this) {
        return $this.isIndefiniteLength();
    }

    @Override
    default public boolean isIndefiniteLength() {
        return false;
    }

    public static boolean isStrict$(HttpEntity $this) {
        return $this.isStrict();
    }

    @Override
    default public boolean isStrict() {
        return false;
    }

    public static boolean isDefault$(HttpEntity $this) {
        return $this.isDefault();
    }

    @Override
    default public boolean isDefault() {
        return false;
    }

    public static boolean isChunked$(HttpEntity $this) {
        return $this.isChunked();
    }

    @Override
    default public boolean isChunked() {
        return false;
    }

    public static CompletionStage toStrict$(HttpEntity $this, long timeoutMillis, Materializer materializer) {
        return $this.toStrict(timeoutMillis, materializer);
    }

    @Override
    default public CompletionStage<HttpEntity.Strict> toStrict(long timeoutMillis, Materializer materializer) {
        Future future = FutureConverters$.MODULE$.FutureOps(this.toStrict(new package.DurationLong(package$.MODULE$.DurationLong(timeoutMillis)).millis(), materializer));
        return FutureConverters.FutureOps$.MODULE$.asJava$extension(future);
    }

    public static CompletionStage toStrict$(HttpEntity $this, long timeoutMillis, long maxBytes, Materializer materializer) {
        return $this.toStrict(timeoutMillis, maxBytes, materializer);
    }

    @Override
    default public CompletionStage<HttpEntity.Strict> toStrict(long timeoutMillis, long maxBytes, Materializer materializer) {
        Future future = FutureConverters$.MODULE$.FutureOps(this.toStrict(new package.DurationLong(package$.MODULE$.DurationLong(timeoutMillis)).millis(), maxBytes, materializer));
        return FutureConverters.FutureOps$.MODULE$.asJava$extension(future);
    }

    public static CompletionStage toStrict$(HttpEntity $this, long timeoutMillis, ClassicActorSystemProvider system) {
        return $this.toStrict(timeoutMillis, system);
    }

    @Override
    default public CompletionStage<HttpEntity.Strict> toStrict(long timeoutMillis, ClassicActorSystemProvider system) {
        Future future = FutureConverters$.MODULE$.FutureOps(this.toStrict(new package.DurationLong(package$.MODULE$.DurationLong(timeoutMillis)).millis(), ((SystemMaterializer)SystemMaterializer$.MODULE$.apply(system)).materializer()));
        return FutureConverters.FutureOps$.MODULE$.asJava$extension(future);
    }

    public static CompletionStage toStrict$(HttpEntity $this, long timeoutMillis, long maxBytes, ClassicActorSystemProvider system) {
        return $this.toStrict(timeoutMillis, maxBytes, system);
    }

    @Override
    default public CompletionStage<HttpEntity.Strict> toStrict(long timeoutMillis, long maxBytes, ClassicActorSystemProvider system) {
        Future future = FutureConverters$.MODULE$.FutureOps(this.toStrict(new package.DurationLong(package$.MODULE$.DurationLong(timeoutMillis)).millis(), maxBytes, ((SystemMaterializer)SystemMaterializer$.MODULE$.apply(system)).materializer()));
        return FutureConverters.FutureOps$.MODULE$.asJava$extension(future);
    }

    public static HttpEntity withContentType$(HttpEntity $this, org.apache.pekko.http.javadsl.model.ContentType contentType) {
        return $this.withContentType(contentType);
    }

    @Override
    default public HttpEntity withContentType(org.apache.pekko.http.javadsl.model.ContentType contentType) {
        return this.withContentType((ContentType)JavaMapping$Implicits$.MODULE$.AddAsScala(contentType, J2SMapping$.MODULE$.fromJavaMapping(JavaMapping$ContentType$.MODULE$)).asScala());
    }

    public static final class Chunk
    extends ChunkStreamPart
    implements Product,
    Serializable {
        private final ByteString data;
        private final String extension;

        public static Chunk apply(ByteString byteString, String string) {
            return HttpEntity$Chunk$.MODULE$.apply(byteString, string);
        }

        public static Chunk apply(byte[] byArray) {
            return HttpEntity$Chunk$.MODULE$.apply(byArray);
        }

        public static Chunk apply(String string) {
            return HttpEntity$Chunk$.MODULE$.apply(string);
        }

        public static Chunk fromProduct(Product product) {
            return HttpEntity$Chunk$.MODULE$.fromProduct(product);
        }

        public static Chunk unapply(Chunk chunk) {
            return HttpEntity$Chunk$.MODULE$.unapply(chunk);
        }

        public static String $lessinit$greater$default$2() {
            return HttpEntity$Chunk$.MODULE$.$lessinit$greater$default$2();
        }

        public Chunk(ByteString data, String extension) {
            this.data = data;
            this.extension = extension;
            Predef$.MODULE$.require(data.nonEmpty(), this::$init$$$anonfun$2);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Chunk)) return false;
            Chunk chunk = (Chunk)object;
            ByteString byteString = this.data();
            ByteString byteString2 = chunk.data();
            if (byteString == null) {
                if (byteString2 != null) {
                    return false;
                }
            } else if (!byteString.equals(byteString2)) return false;
            String string = this.extension();
            String string2 = chunk.extension();
            if (string == null) {
                if (string2 == null) return true;
                return false;
            } else {
                if (!string.equals(string2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Chunk;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Chunk";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "data";
            }
            if (1 == n2) {
                return "extension";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public ByteString data() {
            return this.data;
        }

        @Override
        public String extension() {
            return this.extension;
        }

        @Override
        public boolean isLastChunk() {
            return false;
        }

        @Override
        public Iterable<org.apache.pekko.http.javadsl.model.HttpHeader> getTrailerHeaders() {
            return Collections.emptyList();
        }

        public Chunk copy(ByteString data, String extension) {
            return new Chunk(data, extension);
        }

        public ByteString copy$default$1() {
            return this.data();
        }

        public String copy$default$2() {
            return this.extension();
        }

        public ByteString _1() {
            return this.data();
        }

        public String _2() {
            return this.extension();
        }

        private final Object $init$$$anonfun$2() {
            return "An HttpEntity.Chunk must have non-empty data";
        }
    }

    public static abstract class ChunkStreamPart
    extends HttpEntity.ChunkStreamPart {
        public static ChunkStreamPart apply(ByteString byteString) {
            return HttpEntity$ChunkStreamPart$.MODULE$.apply(byteString);
        }

        public static ChunkStreamPart apply(byte[] byArray) {
            return HttpEntity$ChunkStreamPart$.MODULE$.apply(byArray);
        }

        public static ChunkStreamPart apply(String string) {
            return HttpEntity$ChunkStreamPart$.MODULE$.apply(string);
        }

        public static int ordinal(ChunkStreamPart chunkStreamPart) {
            return HttpEntity$ChunkStreamPart$.MODULE$.ordinal(chunkStreamPart);
        }

        @Override
        public abstract ByteString data();

        @Override
        public abstract String extension();

        @Override
        public abstract boolean isLastChunk();
    }

    public static final class Chunked
    implements HttpEntity.Chunked,
    HttpEntity,
    RequestEntity,
    Product,
    Serializable {
        private final ContentType contentType;
        private final Source chunks;

        public static Chunked apply(ContentType contentType, Source<ChunkStreamPart, Object> source) {
            return HttpEntity$Chunked$.MODULE$.apply(contentType, source);
        }

        public static Chunked fromData(ContentType contentType, Source<ByteString, Object> source) {
            return HttpEntity$Chunked$.MODULE$.fromData(contentType, source);
        }

        public static Chunked fromProduct(Product product) {
            return HttpEntity$Chunked$.MODULE$.fromProduct(product);
        }

        public static Chunked unapply(Chunked chunked) {
            return HttpEntity$Chunked$.MODULE$.unapply(chunked);
        }

        public Chunked(ContentType contentType, Source<ChunkStreamPart, Object> chunks) {
            this.contentType = contentType;
            this.chunks = chunks;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Chunked)) return false;
            Chunked chunked = (Chunked)object;
            ContentType contentType = this.contentType();
            ContentType contentType2 = chunked.contentType();
            if (contentType == null) {
                if (contentType2 != null) {
                    return false;
                }
            } else if (!contentType.equals(contentType2)) return false;
            Source<ChunkStreamPart, Object> source = this.chunks();
            Source<ChunkStreamPart, Object> source2 = chunked.chunks();
            if (source == null) {
                if (source2 == null) return true;
                return false;
            } else {
                if (!source.equals(source2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof Chunked;
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "contentType";
            }
            if (1 == n2) {
                return "chunks";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public ContentType contentType() {
            return this.contentType;
        }

        public Source<ChunkStreamPart, Object> chunks() {
            return this.chunks;
        }

        @Override
        public boolean isKnownEmpty() {
            return this.chunks() == Source$.MODULE$.empty();
        }

        @Override
        public Option<Object> contentLengthOption() {
            return None$.MODULE$;
        }

        @Override
        public boolean isChunked() {
            return true;
        }

        @Override
        public Source<ByteString, Object> dataBytes() {
            return (Source)this.chunks().map(HttpEntity$::org$apache$pekko$http$scaladsl$model$HttpEntity$Chunked$$_$dataBytes$$anonfun$1).filter(HttpEntity$::org$apache$pekko$http$scaladsl$model$HttpEntity$Chunked$$_$dataBytes$$anonfun$2);
        }

        @Override
        public Chunked withSizeLimit(long maxBytes) {
            Source<ChunkStreamPart, Object> source = HttpEntity$Limitable$.MODULE$.applyForChunks(this.chunks(), HttpEntity$SizeLimit$.MODULE$.apply(maxBytes, HttpEntity$SizeLimit$.MODULE$.$lessinit$greater$default$2()));
            ContentType contentType = this.copy$default$1();
            return this.copy(contentType, source);
        }

        @Override
        public Chunked withoutSizeLimit() {
            return this.withSizeLimit(Int$.MODULE$.int2long(HttpEntity$SizeLimit$.MODULE$.Disabled()));
        }

        @Override
        public Chunked transformDataBytes(Flow<ByteString, ByteString, Object> transformer) {
            Graph transformChunks = GraphDSL$.MODULE$.create((Function1 & Serializable)builder -> {
                UniformFanOutShape partition = (UniformFanOutShape)builder.add((Graph)Partition$.MODULE$.apply(2, HttpEntity$::org$apache$pekko$http$scaladsl$model$HttpEntity$Chunked$$_$_$$anonfun$2));
                UniformFanInShape concat = (UniformFanInShape)builder.add(Concat$.MODULE$.apply(2));
                Flow chunkTransformer = (Flow)((Flow)Flow$.MODULE$.apply().map(HttpEntity$::org$apache$pekko$http$scaladsl$model$HttpEntity$Chunked$$_$_$$anonfun$3)).via((Graph)transformer).map(HttpEntity$::org$apache$pekko$http$scaladsl$model$HttpEntity$Chunked$$_$_$$anonfun$4);
                Flow trailerBypass = (Flow)Flow$.MODULE$.apply().recover((PartialFunction)new Serializable(){

                    public final boolean isDefinedAt(Throwable x) {
                        Option option;
                        Throwable throwable = x;
                        if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                            Throwable throwable2;
                            Throwable ex = throwable2 = (Throwable)option.get();
                            return true;
                        }
                        return false;
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Option option;
                        Throwable throwable = x;
                        if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                            Throwable throwable2;
                            Throwable ex = throwable2 = (Throwable)option.get();
                            return HttpEntity$Chunk$.MODULE$.apply(ByteString$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}), (Integral)Numeric.IntIsIntegral$.MODULE$), "");
                        }
                        return function1.apply((Object)x);
                    }
                }).collect((PartialFunction)new Serializable(){

                    public final boolean isDefinedAt(ChunkStreamPart x) {
                        ChunkStreamPart chunkStreamPart = x;
                        if (chunkStreamPart instanceof LastChunk) {
                            Seq<HttpHeader> seq;
                            LastChunk lastChunk = (LastChunk)chunkStreamPart;
                            LastChunk lastChunk2 = HttpEntity$LastChunk$.MODULE$.unapply(lastChunk);
                            String string = lastChunk2._1();
                            Seq<HttpHeader> s2 = seq = lastChunk2._2();
                            LastChunk lc = lastChunk;
                            if (s2.nonEmpty()) {
                                return true;
                            }
                        }
                        return false;
                    }

                    public final Object applyOrElse(ChunkStreamPart x, Function1 function1) {
                        ChunkStreamPart chunkStreamPart = x;
                        if (chunkStreamPart instanceof LastChunk) {
                            Seq<HttpHeader> seq;
                            LastChunk lastChunk = (LastChunk)chunkStreamPart;
                            LastChunk lastChunk2 = HttpEntity$LastChunk$.MODULE$.unapply(lastChunk);
                            String string = lastChunk2._1();
                            Seq<HttpHeader> s2 = seq = lastChunk2._2();
                            LastChunk lc = lastChunk;
                            if (s2.nonEmpty()) {
                                return lc;
                            }
                        }
                        return function1.apply((Object)x);
                    }
                });
                GraphDSL.Implicits$.MODULE$.fanOut2flow(partition, builder).$tilde$greater((Graph)chunkTransformer, builder).$tilde$greater(concat, builder);
                GraphDSL.Implicits$.MODULE$.fanOut2flow(partition, builder).$tilde$greater((Graph)trailerBypass, builder).$tilde$greater(concat, builder);
                return FlowShape$.MODULE$.apply(partition.in(), concat.out());
            });
            return HttpEntity$Chunked$.MODULE$.apply(this.contentType(), (Source<ChunkStreamPart, Object>)this.chunks().via(transformChunks));
        }

        @Override
        public Chunked withContentType(ContentType contentType) {
            ContentType contentType2 = contentType;
            ContentType contentType3 = this.contentType();
            if (!(contentType2 != null ? !contentType2.equals(contentType3) : contentType3 != null)) {
                return this;
            }
            return this.copy(contentType, this.copy$default$2());
        }

        public String productPrefix() {
            return "HttpEntity.Chunked";
        }

        public String toString() {
            return new StringBuilder(2).append(this.productPrefix()).append("(").append(this.contentType()).append(")").toString();
        }

        @Override
        public org.apache.pekko.stream.javadsl.Source<HttpEntity.ChunkStreamPart, Object> getChunks() {
            return org.apache.pekko.stream.javadsl.Source$.MODULE$.fromGraph(this.chunks());
        }

        public Chunked copy(ContentType contentType, Source<ChunkStreamPart, Object> chunks) {
            return new Chunked(contentType, chunks);
        }

        public ContentType copy$default$1() {
            return this.contentType();
        }

        public Source<ChunkStreamPart, Object> copy$default$2() {
            return this.chunks();
        }

        public ContentType _1() {
            return this.contentType();
        }

        public Source<ChunkStreamPart, Object> _2() {
            return this.chunks();
        }
    }

    public static final class CloseDelimited
    implements HttpEntity.CloseDelimited,
    HttpEntity,
    ResponseEntity,
    WithoutKnownLength,
    Product,
    Serializable {
        private final ContentType contentType;
        private final Source data;

        public static CloseDelimited apply(ContentType contentType, Source<ByteString, Object> source) {
            return HttpEntity$CloseDelimited$.MODULE$.apply(contentType, source);
        }

        public static CloseDelimited fromProduct(Product product) {
            return HttpEntity$CloseDelimited$.MODULE$.fromProduct(product);
        }

        public static CloseDelimited unapply(CloseDelimited closeDelimited) {
            return HttpEntity$CloseDelimited$.MODULE$.unapply(closeDelimited);
        }

        public CloseDelimited(ContentType contentType, Source<ByteString, Object> data) {
            this.contentType = contentType;
            this.data = data;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CloseDelimited)) return false;
            CloseDelimited closeDelimited = (CloseDelimited)object;
            ContentType contentType = this.contentType();
            ContentType contentType2 = closeDelimited.contentType();
            if (contentType == null) {
                if (contentType2 != null) {
                    return false;
                }
            } else if (!contentType.equals(contentType2)) return false;
            Source<ByteString, Object> source = this.data();
            Source<ByteString, Object> source2 = closeDelimited.data();
            if (source == null) {
                if (source2 == null) return true;
                return false;
            } else {
                if (!source.equals(source2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof CloseDelimited;
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "contentType";
            }
            if (1 == n2) {
                return "data";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public ContentType contentType() {
            return this.contentType;
        }

        @Override
        public Source<ByteString, Object> data() {
            return this.data;
        }

        @Override
        public boolean isCloseDelimited() {
            return true;
        }

        @Override
        public CloseDelimited withContentType(ContentType contentType) {
            ContentType contentType2 = contentType;
            ContentType contentType3 = this.contentType();
            if (!(contentType2 != null ? !contentType2.equals(contentType3) : contentType3 != null)) {
                return this;
            }
            return this.copy(contentType, this.copy$default$2());
        }

        @Override
        public CloseDelimited withData(Source<ByteString, Object> data) {
            return this.copy(this.copy$default$1(), data);
        }

        public String productPrefix() {
            return "HttpEntity.CloseDelimited";
        }

        public String toString() {
            return new StringBuilder(2).append(this.productPrefix()).append("(").append(this.contentType()).append(")").toString();
        }

        public CloseDelimited copy(ContentType contentType, Source<ByteString, Object> data) {
            return new CloseDelimited(contentType, data);
        }

        public ContentType copy$default$1() {
            return this.contentType();
        }

        public Source<ByteString, Object> copy$default$2() {
            return this.data();
        }

        public ContentType _1() {
            return this.contentType();
        }

        public Source<ByteString, Object> _2() {
            return this.data();
        }
    }

    public static final class Default
    implements HttpEntity.Default,
    HttpEntity,
    UniversalEntity,
    Product,
    Serializable {
        private final ContentType contentType;
        private final long contentLength;
        private final Source data;

        public static Default apply(ContentType contentType, long l, Source<ByteString, Object> source) {
            return HttpEntity$Default$.MODULE$.apply(contentType, l, source);
        }

        public static Default fromProduct(Product product) {
            return HttpEntity$Default$.MODULE$.fromProduct(product);
        }

        public static Default unapply(Default default_) {
            return HttpEntity$Default$.MODULE$.unapply(default_);
        }

        public Default(ContentType contentType, long contentLength, Source<ByteString, Object> data) {
            this.contentType = contentType;
            this.contentLength = contentLength;
            this.data = data;
            Predef$.MODULE$.require(contentLength > 0L, this::$init$$$anonfun$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.contentType()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.contentLength()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.data()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Default)) return false;
            Default default_ = (Default)object;
            if (this.contentLength() != default_.contentLength()) return false;
            ContentType contentType = this.contentType();
            ContentType contentType2 = default_.contentType();
            if (contentType == null) {
                if (contentType2 != null) {
                    return false;
                }
            } else if (!contentType.equals(contentType2)) return false;
            Source<ByteString, Object> source = this.data();
            Source<ByteString, Object> source2 = default_.data();
            if (source == null) {
                if (source2 == null) return true;
                return false;
            } else {
                if (!source.equals(source2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof Default;
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this._2());
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "contentType";
                }
                case 1: {
                    return "contentLength";
                }
                case 2: {
                    return "data";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public ContentType contentType() {
            return this.contentType;
        }

        @Override
        public long contentLength() {
            return this.contentLength;
        }

        public Source<ByteString, Object> data() {
            return this.data;
        }

        @Override
        public boolean isKnownEmpty() {
            return false;
        }

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public Source<ByteString, Object> dataBytes() {
            return this.data();
        }

        @Override
        public Chunked transformDataBytes(Flow<ByteString, ByteString, Object> transformer) {
            return HttpEntity$Chunked$.MODULE$.fromData(this.contentType(), (Source<ByteString, Object>)this.data().via(transformer));
        }

        @Override
        public Default withContentType(ContentType contentType) {
            ContentType contentType2 = contentType;
            ContentType contentType3 = this.contentType();
            if (!(contentType2 != null ? !contentType2.equals(contentType3) : contentType3 != null)) {
                return this;
            }
            return this.copy(contentType, this.copy$default$2(), this.copy$default$3());
        }

        @Override
        public Default withSizeLimit(long maxBytes) {
            if (this.data() != Source$.MODULE$.empty()) {
                Source<ByteString, Object> source = HttpEntity$Limitable$.MODULE$.applyForByteStrings(this.data(), HttpEntity$SizeLimit$.MODULE$.apply(maxBytes, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)this.contentLength()))));
                ContentType contentType = this.copy$default$1();
                long l = this.copy$default$2();
                return this.copy(contentType, l, source);
            }
            return this;
        }

        @Override
        public Default withoutSizeLimit() {
            return this.withSizeLimit(Int$.MODULE$.int2long(HttpEntity$SizeLimit$.MODULE$.Disabled()));
        }

        public String productPrefix() {
            return "HttpEntity.Default";
        }

        public String toString() {
            return new StringBuilder(15).append(this.productPrefix()).append("(").append(this.contentType()).append(",").append(this.contentLength()).append(" bytes total)").toString();
        }

        @Override
        public long getContentLength() {
            return this.contentLength();
        }

        public Default copy(ContentType contentType, long contentLength, Source<ByteString, Object> data) {
            return new Default(contentType, contentLength, data);
        }

        public ContentType copy$default$1() {
            return this.contentType();
        }

        public long copy$default$2() {
            return this.contentLength();
        }

        public Source<ByteString, Object> copy$default$3() {
            return this.data();
        }

        public ContentType _1() {
            return this.contentType();
        }

        public long _2() {
            return this.contentLength();
        }

        public Source<ByteString, Object> _3() {
            return this.data();
        }

        private final Object $init$$$anonfun$1() {
            return "contentLength must be positive (use `HttpEntity.empty(contentType)` for empty entities)";
        }
    }

    public static final class DiscardedEntity
    implements HttpMessage.DiscardedEntity {
        private final Future<Done> f;

        public DiscardedEntity(Future<Done> f) {
            this.f = f;
        }

        @Override
        public Future<Done> future() {
            return this.f;
        }

        @Override
        public CompletionStage<Done> completionStage() {
            Future future = FutureConverters$.MODULE$.FutureOps(this.f);
            return FutureConverters.FutureOps$.MODULE$.asJava$extension(future);
        }
    }

    public static final class HttpEntityScalaDSLSugar {
        private final HttpEntity httpEntity;

        public static HttpMessage.DiscardedEntity discardBytes$extension(HttpEntity httpEntity, Materializer materializer) {
            return HttpEntity$HttpEntityScalaDSLSugar$.MODULE$.discardBytes$extension(httpEntity, materializer);
        }

        public static boolean equals$extension(HttpEntity httpEntity, Object object) {
            return HttpEntity$HttpEntityScalaDSLSugar$.MODULE$.equals$extension(httpEntity, object);
        }

        public static int hashCode$extension(HttpEntity httpEntity) {
            return HttpEntity$HttpEntityScalaDSLSugar$.MODULE$.hashCode$extension(httpEntity);
        }

        public HttpEntityScalaDSLSugar(HttpEntity httpEntity) {
            this.httpEntity = httpEntity;
        }

        public int hashCode() {
            return HttpEntity$HttpEntityScalaDSLSugar$.MODULE$.hashCode$extension(this.httpEntity());
        }

        public boolean equals(Object x$0) {
            return HttpEntity$HttpEntityScalaDSLSugar$.MODULE$.equals$extension(this.httpEntity(), x$0);
        }

        public HttpEntity httpEntity() {
            return this.httpEntity;
        }

        public HttpMessage.DiscardedEntity discardBytes(Materializer mat) {
            return HttpEntity$HttpEntityScalaDSLSugar$.MODULE$.discardBytes$extension(this.httpEntity(), mat);
        }
    }

    public static final class IndefiniteLength
    implements HttpEntity.IndefiniteLength,
    HttpEntity,
    BodyPartEntity,
    WithoutKnownLength,
    Product,
    Serializable {
        private final ContentType contentType;
        private final Source data;

        public static IndefiniteLength apply(ContentType contentType, Source<ByteString, Object> source) {
            return HttpEntity$IndefiniteLength$.MODULE$.apply(contentType, source);
        }

        public static IndefiniteLength fromProduct(Product product) {
            return HttpEntity$IndefiniteLength$.MODULE$.fromProduct(product);
        }

        public static IndefiniteLength unapply(IndefiniteLength indefiniteLength) {
            return HttpEntity$IndefiniteLength$.MODULE$.unapply(indefiniteLength);
        }

        public IndefiniteLength(ContentType contentType, Source<ByteString, Object> data) {
            this.contentType = contentType;
            this.data = data;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof IndefiniteLength)) return false;
            IndefiniteLength indefiniteLength = (IndefiniteLength)object;
            ContentType contentType = this.contentType();
            ContentType contentType2 = indefiniteLength.contentType();
            if (contentType == null) {
                if (contentType2 != null) {
                    return false;
                }
            } else if (!contentType.equals(contentType2)) return false;
            Source<ByteString, Object> source = this.data();
            Source<ByteString, Object> source2 = indefiniteLength.data();
            if (source == null) {
                if (source2 == null) return true;
                return false;
            } else {
                if (!source.equals(source2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof IndefiniteLength;
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "contentType";
            }
            if (1 == n2) {
                return "data";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public ContentType contentType() {
            return this.contentType;
        }

        @Override
        public Source<ByteString, Object> data() {
            return this.data;
        }

        @Override
        public boolean isIndefiniteLength() {
            return true;
        }

        @Override
        public IndefiniteLength withContentType(ContentType contentType) {
            ContentType contentType2 = contentType;
            ContentType contentType3 = this.contentType();
            if (!(contentType2 != null ? !contentType2.equals(contentType3) : contentType3 != null)) {
                return this;
            }
            return this.copy(contentType, this.copy$default$2());
        }

        @Override
        public IndefiniteLength withData(Source<ByteString, Object> data) {
            return this.copy(this.copy$default$1(), data);
        }

        public String productPrefix() {
            return "HttpEntity.IndefiniteLength";
        }

        public String toString() {
            return new StringBuilder(2).append(this.productPrefix()).append("(").append(this.contentType()).append(")").toString();
        }

        public IndefiniteLength copy(ContentType contentType, Source<ByteString, Object> data) {
            return new IndefiniteLength(contentType, data);
        }

        public ContentType copy$default$1() {
            return this.contentType();
        }

        public Source<ByteString, Object> copy$default$2() {
            return this.data();
        }

        public ContentType _1() {
            return this.contentType();
        }

        public Source<ByteString, Object> _2() {
            return this.data();
        }
    }

    public static class LastChunk
    extends ChunkStreamPart
    implements Product,
    Serializable {
        private final String extension;
        private final Seq trailer;

        public static LastChunk apply(String string, Seq<HttpHeader> seq) {
            return HttpEntity$LastChunk$.MODULE$.apply(string, seq);
        }

        public static LastChunk fromProduct(Product product) {
            return HttpEntity$LastChunk$.MODULE$.fromProduct(product);
        }

        public static LastChunk unapply(LastChunk lastChunk) {
            return HttpEntity$LastChunk$.MODULE$.unapply(lastChunk);
        }

        public static String $lessinit$greater$default$1() {
            return HttpEntity$LastChunk$.MODULE$.$lessinit$greater$default$1();
        }

        public static Seq<HttpHeader> $lessinit$greater$default$2() {
            return HttpEntity$LastChunk$.MODULE$.$lessinit$greater$default$2();
        }

        public LastChunk(String extension, Seq<HttpHeader> trailer) {
            this.extension = extension;
            this.trailer = trailer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LastChunk)) return false;
            LastChunk lastChunk = (LastChunk)object;
            String string = this.extension();
            String string2 = lastChunk.extension();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Seq<HttpHeader> seq = this.trailer();
            Seq<HttpHeader> seq2 = lastChunk.trailer();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!lastChunk.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof LastChunk;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "LastChunk";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "extension";
            }
            if (1 == n2) {
                return "trailer";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String extension() {
            return this.extension;
        }

        public Seq<HttpHeader> trailer() {
            return this.trailer;
        }

        @Override
        public ByteString data() {
            return ByteString$.MODULE$.empty();
        }

        @Override
        public boolean isLastChunk() {
            return true;
        }

        @Override
        public Iterable<org.apache.pekko.http.javadsl.model.HttpHeader> getTrailerHeaders() {
            return (Iterable)JavaMapping$Implicits$.MODULE$.AddAsJava(this.trailer(), S2JMapping$.MODULE$.fromScalaMapping(JavaMapping$.MODULE$.iterableMapping(JavaMapping$HttpHeader$.MODULE$))).asJava();
        }

        public LastChunk copy(String extension, Seq<HttpHeader> trailer) {
            return new LastChunk(extension, trailer);
        }

        public String copy$default$1() {
            return this.extension();
        }

        public Seq<HttpHeader> copy$default$2() {
            return this.trailer();
        }

        public String _1() {
            return this.extension();
        }

        public Seq<HttpHeader> _2() {
            return this.trailer();
        }
    }

    public static final class Limitable<T>
    extends GraphStage<FlowShape<T, T>> {
        public final Function1<T, Object> org$apache$pekko$http$scaladsl$model$HttpEntity$Limitable$$sizeOf;
        private final Inlet in;
        private final Outlet out;
        private final FlowShape shape;
        private final Attributes initialAttributes;

        public static <Mat> Source<ByteString, Mat> applyForByteStrings(Source<ByteString, Mat> source, SizeLimit sizeLimit) {
            return HttpEntity$Limitable$.MODULE$.applyForByteStrings(source, sizeLimit);
        }

        public static <Mat> Source<ChunkStreamPart, Mat> applyForChunks(Source<ChunkStreamPart, Mat> source, SizeLimit sizeLimit) {
            return HttpEntity$Limitable$.MODULE$.applyForChunks(source, sizeLimit);
        }

        public static <T, Mat> Source<T, Mat> applyLimit(Source<T, Mat> source, SizeLimit sizeLimit, Function1<T, Object> function1) {
            return HttpEntity$Limitable$.MODULE$.applyLimit(source, sizeLimit, function1);
        }

        public Limitable(Function1<T, Object> sizeOf) {
            this.org$apache$pekko$http$scaladsl$model$HttpEntity$Limitable$$sizeOf = sizeOf;
            this.in = Inlet$.MODULE$.apply("Limitable.in");
            this.out = Outlet$.MODULE$.apply("Limitable.out");
            this.shape = FlowShape$.MODULE$.of(this.in(), this.out());
            this.initialAttributes = HttpEntity$Limitable$.org$apache$pekko$http$scaladsl$model$HttpEntity$Limitable$$$limitableDefaults;
        }

        public Inlet<T> in() {
            return this.in;
        }

        public Outlet<T> out() {
            return this.out;
        }

        public FlowShape<T, T> shape() {
            return this.shape;
        }

        public Attributes initialAttributes() {
            return this.initialAttributes;
        }

        public GraphStageLogic createLogic(Attributes _attributes) {
            return new InHandler(_attributes, this){
                private final Attributes _attributes$1;
                private long maxBytes;
                private long bytesLeft;
                private final /* synthetic */ Limitable $outer;
                {
                    this._attributes$1 = _attributes$2;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super($outer.shape());
                    this.maxBytes = -1L;
                    this.bytesLeft = Long.MAX_VALUE;
                    this.setHandlers($outer.in(), $outer.out(), this);
                }

                public void preStart() {
                    Option option = this._attributes$1.getFirst(ClassTag$.MODULE$.apply(SizeLimit.class));
                    if (option instanceof Some) {
                        SizeLimit limit;
                        SizeLimit sizeLimit = (SizeLimit)((Some)option).value();
                        if (sizeLimit != null && (limit = sizeLimit).isDisabled()) {
                            return;
                        }
                        if (sizeLimit != null) {
                            SizeLimit sizeLimit2 = HttpEntity$SizeLimit$.MODULE$.unapply(sizeLimit);
                            long l = sizeLimit2._1();
                            Option<Object> option2 = sizeLimit2._2();
                            long bytes = l;
                            if (option2 instanceof Some) {
                                Some some = (Some)option2;
                                long contentLength = BoxesRunTime.unboxToLong((Object)some.value());
                                Some cl = some;
                                if (contentLength > bytes) {
                                    this.failStage(EntityStreamSizeException$.MODULE$.apply(bytes, (Option<Object>)cl));
                                    return;
                                }
                                return;
                            }
                            long bytes2 = l;
                            if (None$.MODULE$.equals(option2)) {
                                this.maxBytes = bytes2;
                                this.bytesLeft = bytes2;
                                return;
                            }
                        }
                    }
                    if (None$.MODULE$.equals(option)) {
                        return;
                    }
                    throw new MatchError((Object)option);
                }

                public void onPush() {
                    Object elem = this.grab(this.$outer.in());
                    this.bytesLeft -= (long)BoxesRunTime.unboxToInt((Object)this.$outer.org$apache$pekko$http$scaladsl$model$HttpEntity$Limitable$$sizeOf.apply(elem));
                    if (this.bytesLeft >= 0L) {
                        this.push(this.$outer.out(), elem);
                        return;
                    }
                    this.failStage(EntityStreamSizeException$.MODULE$.apply(this.maxBytes, EntityStreamSizeException$.MODULE$.$lessinit$greater$default$2()));
                }

                public void onPull() {
                    this.pull(this.$outer.in());
                }
            };
        }
    }

    public static final class SizeLimit
    implements Attributes.Attribute,
    Product,
    Serializable {
        private final long maxBytes;
        private final Option contentLength;

        public static int Disabled() {
            return HttpEntity$SizeLimit$.MODULE$.Disabled();
        }

        public static SizeLimit apply(long l, Option<Object> option) {
            return HttpEntity$SizeLimit$.MODULE$.apply(l, option);
        }

        public static SizeLimit fromProduct(Product product) {
            return HttpEntity$SizeLimit$.MODULE$.fromProduct(product);
        }

        public static SizeLimit unapply(SizeLimit sizeLimit) {
            return HttpEntity$SizeLimit$.MODULE$.unapply(sizeLimit);
        }

        public static Option<Object> $lessinit$greater$default$2() {
            return HttpEntity$SizeLimit$.MODULE$.$lessinit$greater$default$2();
        }

        public SizeLimit(long maxBytes, Option<Object> contentLength) {
            this.maxBytes = maxBytes;
            this.contentLength = contentLength;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.maxBytes()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.contentLength()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SizeLimit)) return false;
            SizeLimit sizeLimit = (SizeLimit)object;
            if (this.maxBytes() != sizeLimit.maxBytes()) return false;
            Option<Object> option = this.contentLength();
            Option<Object> option2 = sizeLimit.contentLength();
            if (option != null) {
                if (!option.equals(option2)) return false;
                return true;
            }
            if (option2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SizeLimit;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "SizeLimit";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToLong((long)this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "maxBytes";
            }
            if (1 == n2) {
                return "contentLength";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long maxBytes() {
            return this.maxBytes;
        }

        public Option<Object> contentLength() {
            return this.contentLength;
        }

        public boolean isDisabled() {
            return this.maxBytes() < 0L;
        }

        public SizeLimit copy(long maxBytes, Option<Object> contentLength) {
            return new SizeLimit(maxBytes, contentLength);
        }

        public long copy$default$1() {
            return this.maxBytes();
        }

        public Option<Object> copy$default$2() {
            return this.contentLength();
        }

        public long _1() {
            return this.maxBytes();
        }

        public Option<Object> _2() {
            return this.contentLength();
        }
    }

    public static final class Strict
    implements HttpEntity.Strict,
    HttpEntity,
    UniversalEntity,
    Product,
    Serializable {
        private final ContentType contentType;
        private final ByteString data;

        public static Strict apply(ContentType contentType, ByteString byteString) {
            return HttpEntity$Strict$.MODULE$.apply(contentType, byteString);
        }

        public static Strict fromProduct(Product product) {
            return HttpEntity$Strict$.MODULE$.fromProduct(product);
        }

        public static Strict unapply(Strict strict) {
            return HttpEntity$Strict$.MODULE$.unapply(strict);
        }

        public Strict(ContentType contentType, ByteString data) {
            this.contentType = contentType;
            this.data = data;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Strict)) return false;
            Strict strict = (Strict)object;
            ContentType contentType = this.contentType();
            ContentType contentType2 = strict.contentType();
            if (contentType == null) {
                if (contentType2 != null) {
                    return false;
                }
            } else if (!contentType.equals(contentType2)) return false;
            ByteString byteString = this.data();
            ByteString byteString2 = strict.data();
            if (byteString == null) {
                if (byteString2 == null) return true;
                return false;
            } else {
                if (!byteString.equals(byteString2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof Strict;
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "contentType";
            }
            if (1 == n2) {
                return "data";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public ContentType contentType() {
            return this.contentType;
        }

        public ByteString data() {
            return this.data;
        }

        @Override
        public long contentLength() {
            return Int$.MODULE$.int2long(this.data().length());
        }

        @Override
        public boolean isKnownEmpty() {
            return this.data().isEmpty();
        }

        @Override
        public boolean isStrict() {
            return true;
        }

        public Source<ByteString, NotUsed> dataBytes() {
            return Source$.MODULE$.single((Object)this.data());
        }

        @Override
        public Future<Strict> toStrict(FiniteDuration timeout, Materializer fm) {
            return (Future)FastFuture$.MODULE$.successful().apply((Object)this);
        }

        @Override
        public RequestEntity transformDataBytes(Flow<ByteString, ByteString, Object> transformer) {
            return HttpEntity$Chunked$.MODULE$.fromData(this.contentType(), (Source<ByteString, Object>)Source$.MODULE$.single((Object)this.data()).via(transformer));
        }

        @Override
        public Strict withContentType(ContentType contentType) {
            ContentType contentType2 = contentType;
            ContentType contentType3 = this.contentType();
            if (!(contentType2 != null ? !contentType2.equals(contentType3) : contentType3 != null)) {
                return this;
            }
            return this.copy(contentType, this.copy$default$2());
        }

        @Override
        public UniversalEntity withSizeLimit(long maxBytes) {
            return (UniversalEntity)((Object)((long)this.data().length() <= maxBytes || this.isKnownEmpty() ? this : HttpEntity$Default$.MODULE$.apply(this.contentType(), Int$.MODULE$.int2long(this.data().length()), (Source<ByteString, Object>)Source$.MODULE$.single((Object)this.data())).withSizeLimit(maxBytes)));
        }

        @Override
        public UniversalEntity withoutSizeLimit() {
            return this.withSizeLimit(Int$.MODULE$.int2long(HttpEntity$SizeLimit$.MODULE$.Disabled()));
        }

        public String productPrefix() {
            return "HttpEntity.Strict";
        }

        public String toString() {
            String dataSizeStr = new StringBuilder(12).append(this.data().length()).append(" bytes total").toString();
            return new StringBuilder(3).append(this.productPrefix()).append("(").append(this.contentType()).append(",").append(dataSizeStr).append(")").toString();
        }

        @Override
        public ByteString getData() {
            return this.data();
        }

        public Strict copy(ContentType contentType, ByteString data) {
            return new Strict(contentType, data);
        }

        public ContentType copy$default$1() {
            return this.contentType();
        }

        public ByteString copy$default$2() {
            return this.data();
        }

        public ContentType _1() {
            return this.contentType();
        }

        public ByteString _2() {
            return this.data();
        }
    }

    @DoNotInherit
    public static interface WithoutKnownLength
    extends HttpEntity {
        @Override
        public ContentType contentType();

        public Source<ByteString, Object> data();

        public static Option contentLengthOption$(WithoutKnownLength $this) {
            return $this.contentLengthOption();
        }

        @Override
        default public Option<Object> contentLengthOption() {
            return None$.MODULE$;
        }

        public static boolean isKnownEmpty$(WithoutKnownLength $this) {
            return $this.isKnownEmpty();
        }

        @Override
        default public boolean isKnownEmpty() {
            return this.data() == Source$.MODULE$.empty();
        }

        public static Source dataBytes$(WithoutKnownLength $this) {
            return $this.dataBytes();
        }

        @Override
        default public Source<ByteString, Object> dataBytes() {
            return this.data();
        }

        public static WithoutKnownLength withSizeLimit$(WithoutKnownLength $this, long maxBytes) {
            return $this.withSizeLimit(maxBytes);
        }

        @Override
        default public WithoutKnownLength withSizeLimit(long maxBytes) {
            return this.withData(HttpEntity$Limitable$.MODULE$.applyForByteStrings(this.data(), HttpEntity$SizeLimit$.MODULE$.apply(maxBytes, HttpEntity$SizeLimit$.MODULE$.$lessinit$greater$default$2())));
        }

        public static WithoutKnownLength withoutSizeLimit$(WithoutKnownLength $this) {
            return $this.withoutSizeLimit();
        }

        @Override
        default public WithoutKnownLength withoutSizeLimit() {
            return this.withSizeLimit(Int$.MODULE$.int2long(HttpEntity$SizeLimit$.MODULE$.Disabled()));
        }

        public static WithoutKnownLength transformDataBytes$(WithoutKnownLength $this, Flow transformer) {
            return $this.transformDataBytes((Flow<ByteString, ByteString, Object>)transformer);
        }

        @Override
        default public WithoutKnownLength transformDataBytes(Flow<ByteString, ByteString, Object> transformer) {
            return this.withData((Source<ByteString, Object>)this.data().via(transformer));
        }

        public WithoutKnownLength withData(Source<ByteString, Object> var1);
    }
}

