/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.model;

import java.io.Serializable;
import org.apache.pekko.http.scaladsl.model.HttpEntity$;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpMethod;
import org.apache.pekko.http.scaladsl.model.HttpMethods$;
import org.apache.pekko.http.scaladsl.model.HttpProtocol;
import org.apache.pekko.http.scaladsl.model.HttpProtocols$;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.IllegalUriException$;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.http.scaladsl.model.headers.Host;
import org.apache.pekko.http.scaladsl.model.headers.Host$;
import org.apache.pekko.http.scaladsl.model.headers.Upgrade;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import org.parboiled2.CharUtils$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;

public final class HttpRequest$
implements Serializable {
    public static final HttpRequest$ MODULE$ = new HttpRequest$();

    private HttpRequest$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HttpRequest$.class);
    }

    public Uri effectiveUri(Uri uri, Seq<HttpHeader> headers, boolean securedConnection, Host defaultHostHeader) {
        Tuple2 tuple2 = this.findHostAndWsUpgrade$1(headers.iterator(), this.findHostAndWsUpgrade$default$2$1(), this.findHostAndWsUpgrade$default$3$1());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Host hostHeader = (Host)(tuple2._1() == null ? null : ((OptionVal)tuple2._1()).x());
        boolean isWebsocket = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)new OptionVal((Object)hostHeader), (Object)BoxesRunTime.boxToBoolean((boolean)isWebsocket));
        Host hostHeader2 = (Host)(tuple22._1() == null ? null : ((OptionVal)tuple22._1()).x());
        boolean isWebsocket2 = BoxesRunTime.unboxToBoolean((Object)tuple22._2());
        if (uri.isRelative()) {
            Host host;
            Host host2 = hostHeader2;
            OptionVal$.MODULE$.None();
            Host host3 = host2;
            if (!(null != null ? !((Object)null).equals(host3) : host3 != null)) {
                if (defaultHostHeader.isEmpty()) {
                    throw this.fail$1(uri, "is missing a `Host` header");
                }
                host = defaultHostHeader;
            } else {
                Host host4 = (Host)OptionVal.Some$.MODULE$.unapply((Object)host2);
                if (!OptionVal$.MODULE$.isEmpty$extension((Object)host4)) {
                    Host host5 = (Host)OptionVal$.MODULE$.get$extension((Object)host4);
                    Host host6 = host5;
                    Host x = host6;
                    if (x.isEmpty()) {
                        if (defaultHostHeader.isEmpty()) {
                            throw this.fail$1(uri, "an empty `Host` header");
                        }
                        host = defaultHostHeader;
                    } else {
                        Host x2;
                        host = x2 = host6;
                    }
                } else {
                    throw new MatchError((Object)new OptionVal((Object)host2));
                }
            }
            Host host7 = host;
            if (host7 == null) {
                throw new MatchError((Object)host7);
            }
            Host host8 = Host$.MODULE$.unapply(host7);
            Uri.Host host9 = host8._1();
            int n = host8._2();
            Uri.Host hostHeaderHost = host9;
            int hostHeaderPort = n;
            Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)hostHeaderHost, (Object)BoxesRunTime.boxToInteger((int)hostHeaderPort));
            Uri.Host hostHeaderHost2 = (Uri.Host)tuple23._1();
            int hostHeaderPort2 = BoxesRunTime.unboxToInt((Object)tuple23._2());
            String defaultScheme = isWebsocket2 ? Uri$.MODULE$.websocketScheme(securedConnection) : Uri$.MODULE$.httpScheme(securedConnection);
            return uri.toEffectiveRequestUri(hostHeaderHost2, hostHeaderPort2, defaultScheme, uri.toEffectiveRequestUri$default$4());
        }
        if (OptionVal$.MODULE$.isEmpty$extension((Object)hostHeader2) || uri.authority().isEmpty() && ((Host)OptionVal$.MODULE$.get$extension((Object)hostHeader2)).isEmpty() || ((Host)OptionVal$.MODULE$.get$extension((Object)hostHeader2)).host().equalsIgnoreCase(uri.authority().host()) && ((Host)OptionVal$.MODULE$.get$extension((Object)hostHeader2)).port() == uri.authority().port()) {
            return uri;
        }
        throw IllegalUriException$.MODULE$.apply(new StringBuilder(75).append("'Host' header value of request to `").append(uri).append("` doesn't match request target authority").toString(), new StringBuilder(40).append("Host header: ").append(new OptionVal((Object)hostHeader2)).append("\nrequest target authority: ").append(uri.authority()).toString());
    }

    public void verifyUri(Uri uri) {
        if (uri.isEmpty()) {
            throw IllegalUriException$.MODULE$.apply("`uri` must not be empty", IllegalUriException$.MODULE$.apply$default$2());
        }
        int n = uri.scheme().length();
        if (0 == n) {
            return;
        }
        if (4 == n && this.c$1(uri, 0) == 'h' && this.c$1(uri, 1) == 't' && this.c$1(uri, 2) == 't' && this.c$1(uri, 3) == 'p') {
            return;
        }
        if (5 == n && this.c$1(uri, 0) == 'h' && this.c$1(uri, 1) == 't' && this.c$1(uri, 2) == 't' && this.c$1(uri, 3) == 'p' && this.c$1(uri, 4) == 's') {
            return;
        }
        if (2 == n && this.c$1(uri, 0) == 'w' && this.c$1(uri, 1) == 's') {
            return;
        }
        if (3 == n && this.c$1(uri, 0) == 'w' && this.c$1(uri, 1) == 's' && this.c$1(uri, 2) == 's') {
            return;
        }
        throw IllegalUriException$.MODULE$.apply("`uri` must have scheme \"http\", \"https\", \"ws\", \"wss\" or no scheme", IllegalUriException$.MODULE$.apply$default$2());
    }

    public HttpRequest apply(HttpMethod method, Uri uri, Seq<HttpHeader> headers, RequestEntity entity, HttpProtocol protocol) {
        return new HttpRequest(method, uri, headers, Predef$.MODULE$.Map().empty(), entity, protocol);
    }

    public HttpMethod apply$default$1() {
        return HttpMethods$.MODULE$.GET();
    }

    public Uri apply$default$2() {
        return Uri$.MODULE$.$div();
    }

    public Seq<HttpHeader> apply$default$3() {
        return package$.MODULE$.Nil();
    }

    public RequestEntity apply$default$4() {
        return HttpEntity$.MODULE$.Empty();
    }

    public HttpProtocol apply$default$5() {
        return HttpProtocols$.MODULE$.HTTP$div1$u002E1();
    }

    public HttpRequest unapply(HttpRequest any) {
        return any;
    }

    private final Tuple2 findHostAndWsUpgrade$1(Iterator it, Host host, Option wsUpgrade) {
        while (!(OptionVal$.MODULE$.isDefined$extension((Object)host) && wsUpgrade.isDefined() || !it.hasNext())) {
            HttpHeader httpHeader = (HttpHeader)it.next();
            if (httpHeader instanceof Host) {
                Host h = (Host)httpHeader;
                host = (Host)OptionVal.Some$.MODULE$.apply((Object)h);
                continue;
            }
            if (!(httpHeader instanceof Upgrade)) continue;
            Upgrade u = (Upgrade)httpHeader;
            wsUpgrade = Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)u.hasWebSocket()));
        }
        return Tuple2$.MODULE$.apply((Object)new OptionVal((Object)host), (Object)BoxesRunTime.boxToBoolean((boolean)wsUpgrade.contains((Object)BoxesRunTime.boxToBoolean((boolean)true))));
    }

    private final Host findHostAndWsUpgrade$default$2$1() {
        OptionVal$.MODULE$.None();
        return null;
    }

    private final Option findHostAndWsUpgrade$default$3$1() {
        return None$.MODULE$;
    }

    private final Nothing$ fail$1(Uri uri$6, String detail) {
        throw IllegalUriException$.MODULE$.apply(new StringBuilder(80).append("Cannot establish effective URI of request to `").append(uri$6).append("`, request has a relative URI and ").append(detail).toString(), "consider setting `pekko.http.server.default-host-header`");
    }

    private final char c$1(Uri uri$7, int i) {
        return CharUtils$.MODULE$.toLowerCase(uri$7.scheme().charAt(i));
    }
}

