/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.coding;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.scaladsl.coding.Coder;
import org.apache.pekko.http.scaladsl.coding.Compressor;
import org.apache.pekko.http.scaladsl.coding.Decoder;
import org.apache.pekko.http.scaladsl.coding.Encoder;
import org.apache.pekko.http.scaladsl.coding.Gzip$;
import org.apache.pekko.http.scaladsl.coding.GzipCompressor;
import org.apache.pekko.http.scaladsl.coding.GzipCompressor$;
import org.apache.pekko.http.scaladsl.coding.GzipDecompressor;
import org.apache.pekko.http.scaladsl.coding.StreamDecoder;
import org.apache.pekko.http.scaladsl.model.HttpMessage;
import org.apache.pekko.http.scaladsl.model.headers.HttpEncoding;
import org.apache.pekko.http.scaladsl.model.headers.HttpEncodings$;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.util.ByteString;
import scala.Function0;
import scala.Function1;

@InternalApi
public class Gzip
implements Encoder,
Decoder,
Coder,
StreamDecoder {
    private final int compressionLevel;
    private final Function1 messageFilter;
    private final HttpEncoding encoding;

    public static Gzip apply(Function1<HttpMessage, Object> function1) {
        return Gzip$.MODULE$.apply(function1);
    }

    public Gzip(int compressionLevel, Function1<HttpMessage, Object> messageFilter) {
        this.compressionLevel = compressionLevel;
        this.messageFilter = messageFilter;
        this.encoding = HttpEncodings$.MODULE$.gzip();
    }

    @Override
    public Function1<HttpMessage, Object> messageFilter() {
        return this.messageFilter;
    }

    public Gzip(Function1<HttpMessage, Object> messageFilter) {
        this(GzipCompressor$.MODULE$.DefaultCompressionLevel(), messageFilter);
    }

    @Override
    public HttpEncoding encoding() {
        return this.encoding;
    }

    @Override
    public Compressor newCompressor() {
        return new GzipCompressor(this.compressionLevel);
    }

    @Override
    public Function0<GraphStage<FlowShape<ByteString, ByteString>>> newDecompressorStage(int maxBytesPerChunk) {
        return (Function0 & Serializable)() -> new GzipDecompressor(maxBytesPerChunk);
    }

    public Gzip withLevel(int level) {
        return new Gzip(level, this.messageFilter());
    }
}

