/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.semivirtual;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.tinfour.common.IConstraint;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.Vertex;
import org.tinfour.semivirtual.SemiVirtualEdge;
import org.tinfour.semivirtual.SemiVirtualEdgePage;

class SemiVirtualEdgePool
implements Iterable<IQuadEdge> {
    SemiVirtualEdgePool self;
    SemiVirtualEdgePage[] pages;
    SemiVirtualEdgePage nextAvailablePage;
    int nAllocated;
    int nFree;
    int nAllocationOperations;
    int nFreeOperations;
    HashMap<Integer, IConstraint> borderConstraintMap = new HashMap();
    HashMap<Integer, IConstraint> linearConstraintMap = new HashMap();

    SemiVirtualEdgePool() {
        this.self = this;
        this.pages = new SemiVirtualEdgePage[1];
        this.pages[0] = new SemiVirtualEdgePage(0);
        this.nextAvailablePage = this.pages[0];
        this.nAllocated = 0;
        this.nFree = this.pages.length * 1024;
    }

    int getPageCount() {
        return this.pages.length;
    }

    int getPageSize() {
        return 2048;
    }

    void preAllocateEdges(int n) {
        int i;
        if (this.nFree >= n) {
            return;
        }
        int availablePageID = this.nextAvailablePage.pageID;
        int edgesNeeded = n - this.nFree;
        int pagesNeeded = (edgesNeeded + 1024 - 1) / 1024;
        int oldLen = this.pages.length;
        int nP = oldLen + pagesNeeded;
        this.pages = Arrays.copyOf(this.pages, nP);
        for (i = oldLen; i < nP; ++i) {
            this.pages[i] = new SemiVirtualEdgePage(i);
        }
        for (i = 0; i < nP - 1; ++i) {
            this.pages[i].nextPage = this.pages[i + 1];
        }
        this.nextAvailablePage = this.pages[availablePageID];
        this.nFree += pagesNeeded * 1024;
    }

    private void allocatePage() {
        int oldLength = this.pages.length;
        SemiVirtualEdgePage[] newPages = new SemiVirtualEdgePage[oldLength + 1];
        System.arraycopy(this.pages, 0, newPages, 0, this.pages.length);
        newPages[oldLength] = new SemiVirtualEdgePage(oldLength);
        this.pages = newPages;
        this.nFree += 1024;
        this.nextAvailablePage = this.pages[oldLength];
        for (int i = 0; i < this.pages.length - 1; ++i) {
            this.pages[i].nextPage = this.pages[i + 1];
        }
    }

    SemiVirtualEdge allocateUnassignedEdge() {
        return new SemiVirtualEdge(this);
    }

    void allocateEdgeWithReceiver(SemiVirtualEdge receiver, Vertex a, Vertex b) {
        SemiVirtualEdgePage page = this.nextAvailablePage;
        int absIndex = page.allocateEdge(a, b);
        if (page.isFullyAllocated()) {
            this.nextAvailablePage = page.nextPage;
            if (this.nextAvailablePage == null) {
                this.allocatePage();
            }
        }
        --this.nFree;
        ++this.nAllocated;
        ++this.nAllocationOperations;
        receiver.page = page;
        receiver.index = absIndex;
        receiver.indexOnPage = absIndex & 0x7FF;
    }

    SemiVirtualEdge allocateEdge(Vertex a, Vertex b) {
        SemiVirtualEdgePage page = this.nextAvailablePage;
        int absIndex = page.allocateEdge(a, b);
        if (page.isFullyAllocated()) {
            this.nextAvailablePage = page.nextPage;
            if (this.nextAvailablePage == null) {
                this.allocatePage();
            }
        }
        --this.nFree;
        ++this.nAllocated;
        ++this.nAllocationOperations;
        return new SemiVirtualEdge(this, page, absIndex);
    }

    public SemiVirtualEdge getStartingEdge() {
        for (SemiVirtualEdgePage page : this.pages) {
            int[] allocatedEdges = page.getAllocations();
            for (int j = 0; j < allocatedEdges.length; ++j) {
                int iEdge = allocatedEdges[j];
                int index = iEdge & 0x7FF;
                if (page.vertices[index] == null || page.vertices[index + 1] == null) continue;
                return new SemiVirtualEdge(this, page, iEdge);
            }
        }
        return null;
    }

    public SemiVirtualEdge getStartingGhostEdge() {
        for (SemiVirtualEdgePage page : this.pages) {
            int[] allocatedEdges = page.getAllocations();
            for (int j = 0; j < allocatedEdges.length; ++j) {
                int iEdge = allocatedEdges[j];
                int index = iEdge & 0x7FF;
                if (page.vertices[index] == null || page.vertices[index + 1] != null) continue;
                return new SemiVirtualEdge(this, page, iEdge);
            }
        }
        return null;
    }

    void deallocateEdge(int absIndex) {
        int iPage = absIndex / 2048;
        SemiVirtualEdgePage page = this.pages[iPage];
        if (page.isFullyAllocated()) {
            page.nextPage = this.nextAvailablePage;
            this.nextAvailablePage = page;
        }
        page.deallocateEdge(absIndex);
        --this.nAllocated;
        ++this.nFree;
        ++this.nFreeOperations;
    }

    void deallocateEdge(SemiVirtualEdge e) {
        this.deallocateEdge(e.getIndex());
    }

    SemiVirtualEdgePage getPageForIndex(int index) {
        return this.pages[index / 2048];
    }

    public int size() {
        return this.nAllocated;
    }

    public List<IQuadEdge> getEdges() {
        ArrayList<IQuadEdge> eList = new ArrayList<IQuadEdge>(this.nAllocated);
        for (SemiVirtualEdgePage p : this.pages) {
            int[] map = p.getAllocations();
            for (int i = 0; i < map.length; ++i) {
                eList.add(new SemiVirtualEdge(this, p, map[i]));
            }
        }
        return eList;
    }

    public List<SemiVirtualEdge> getVirtualEdges() {
        ArrayList<SemiVirtualEdge> eList = new ArrayList<SemiVirtualEdge>(this.nAllocated);
        for (SemiVirtualEdgePage p : this.pages) {
            int[] map = p.getAllocations();
            for (int i = 0; i < map.length; ++i) {
                eList.add(new SemiVirtualEdge(this, p, map[i]));
            }
        }
        return eList;
    }

    public int getEdgeCount() {
        return this.nAllocated;
    }

    void dispose() {
        this.nextAvailablePage = null;
        for (int i = 0; i < this.pages.length; ++i) {
            this.pages[i].dispose();
            this.pages[i].nextPage = null;
            this.pages[i] = null;
        }
        this.pages = null;
    }

    void clear() {
        for (SemiVirtualEdgePage p : this.pages) {
            p.clear();
        }
        this.nAllocationOperations = 0;
        this.nFreeOperations = 0;
        this.nextAvailablePage = this.pages[0];
        for (int i = 0; i < this.pages.length - 1; ++i) {
            this.pages[i].nextPage = this.pages[i + 1];
        }
        this.pages[this.pages.length - 1].nextPage = null;
        this.nAllocated = 0;
        this.nFree = this.pages.length * 1024;
        this.linearConstraintMap.clear();
        this.borderConstraintMap.clear();
    }

    public String toString() {
        String s = "nEdges=" + this.nAllocated + ", nPages=" + this.pages.length + ", nFree=" + this.nFree;
        return s;
    }

    public void printDiagnostics(PrintStream ps) {
        int nPartials = 0;
        SemiVirtualEdgePage p = this.nextAvailablePage;
        while (p != null) {
            ++nPartials;
            p = p.nextPage;
        }
        int nConstrained = 0;
        int nConstraintInterior = 0;
        int nConstraintBorder = 0;
        for (IQuadEdge e : this) {
            if (e.isConstrained()) {
                ++nConstrained;
                if (!e.isConstrainedRegionBorder()) continue;
                ++nConstraintBorder;
                continue;
            }
            if (!e.isConstrainedRegionInterior()) continue;
            ++nConstraintInterior;
        }
        ps.format("%nEdge pool diagnostics%n", new Object[0]);
        ps.format("   Edges allocated:             %8d%n", this.nAllocated);
        ps.format("   Edges free:                  %8d%n", this.nFree);
        ps.format("   Pages:                       %8d%n", this.pages.length);
        ps.format("   Partially used pages:        %8d%n", nPartials);
        ps.format("   Total allocation operations: %8d%n", this.nAllocationOperations);
        ps.format("   Total free operations        %8d%n", this.nFreeOperations);
        ps.format("Constrained edges               %8d%n", nConstrained);
        ps.format("   Region borders:              %8d%n", nConstraintBorder);
        ps.format("   Region interior:             %8d%n", nConstraintInterior);
    }

    public int getMaximumAllocationIndex() {
        for (int iPage = this.pages.length - 1; iPage >= 0; --iPage) {
            SemiVirtualEdgePage p = this.pages[iPage];
            if (p.nPairsAllocated <= 0) continue;
            return (p.pageID + 1) * 2048;
        }
        return 0;
    }

    SemiVirtualEdge getEdgeForIndex(int index) {
        int iPage = index / 2048;
        SemiVirtualEdgePage page = this.pages[iPage];
        return new SemiVirtualEdge(this, page, index);
    }

    void getEdgeForIndexWithReceiver(SemiVirtualEdge receiver, int index, Vertex a, Vertex b) {
        SemiVirtualEdgePage page;
        int iPage = index / 2048;
        receiver.page = page = this.pages[iPage];
        receiver.index = index;
        receiver.indexOnPage = index & 0x7FF;
        int side = index & 1;
        int offset = index & 0x7FE;
        page.vertices[offset | side] = a;
        page.vertices[offset | side ^ 1] = b;
    }

    @Override
    public Iterator<IQuadEdge> iterator() {
        return this.getIterator(true);
    }

    Iterator<IQuadEdge> getIterator(final boolean includeGhostEdges) {
        return new Iterator<IQuadEdge>(){
            boolean skipGhostEdges;
            int iEdge;
            int iPage;
            int[] map;
            boolean hasNext;
            {
                this.skipGhostEdges = !includeGhostEdges;
                this.map = SemiVirtualEdgePool.this.pages[0].getAllocations();
                this.hasNext = this.processHasNext(0, -1);
            }

            private boolean processHasNext(int pageIndex, int edgeIndex) {
                this.iPage = pageIndex;
                this.iEdge = edgeIndex;
                while (this.iPage < SemiVirtualEdgePool.this.pages.length) {
                    int i;
                    Vertex[] v;
                    ++this.iEdge;
                    if (this.iEdge >= this.map.length) {
                        ++this.iPage;
                        this.iEdge = -1;
                        if (this.iPage == SemiVirtualEdgePool.this.pages.length) {
                            return false;
                        }
                        this.map = SemiVirtualEdgePool.this.pages[this.iPage].getAllocations();
                        continue;
                    }
                    if (this.skipGhostEdges && ((v = SemiVirtualEdgePool.this.pages[this.iPage].vertices)[i = this.map[this.iEdge] & 0x7FF] == null || v[i + 1] == null)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public SemiVirtualEdge next() {
                if (!this.hasNext) {
                    return null;
                }
                int index = this.map[this.iEdge];
                SemiVirtualEdgePage page = SemiVirtualEdgePool.this.pages[this.iPage];
                SemiVirtualEdge e = new SemiVirtualEdge(SemiVirtualEdgePool.this.self, page, index);
                this.hasNext = this.processHasNext(this.iPage, this.iEdge);
                return e;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove operation not supported by this iterator");
            }
        };
    }

    public SemiVirtualEdge splitEdge(SemiVirtualEdge e, Vertex m) {
        int constraintFlags;
        SemiVirtualEdge d = e.getDual();
        SemiVirtualEdge eR = e.getReverse();
        SemiVirtualEdge dF = d.getForward();
        Vertex a = e.getA();
        e.setA(m);
        SemiVirtualEdge p = this.allocateEdge(a, m);
        SemiVirtualEdge q = p.getDual();
        p.setForward(e);
        p.setReverse(eR);
        q.setForward(dF);
        q.setReverse(d);
        SemiVirtualEdgePage ePage = e.page;
        SemiVirtualEdgePage pPage = p.page;
        if (ePage.constraints == null) {
            return p;
        }
        pPage.readyConstraints();
        pPage.constraints[p.indexOnPage / 2] = constraintFlags = ePage.constraints[e.indexOnPage / 2];
        if (e.isConstrainedRegionBorder()) {
            IConstraint c = this.borderConstraintMap.get(e.getIndex());
            if (c != null) {
                this.addBorderConstraintToMap(p, c);
            }
            if ((c = this.borderConstraintMap.get(d.getIndex())) != null) {
                this.addBorderConstraintToMap(q, c);
            }
        }
        return p;
    }

    public void addBorderConstraintToMap(IQuadEdge edge, IConstraint constraint) {
        this.borderConstraintMap.put(edge.getIndex(), constraint);
    }

    public void addLinearConstraintToMap(IQuadEdge edge, IConstraint constraint) {
        int index = edge.getIndex();
        this.linearConstraintMap.put(index, constraint);
        this.linearConstraintMap.put(index ^ 1, constraint);
    }

    public void removeBorderConstraintFromMap(IQuadEdge edge) {
        this.borderConstraintMap.remove(edge.getIndex());
    }

    public void removeLinearConstraintFromMap(IQuadEdge edge) {
        this.linearConstraintMap.remove(edge.getIndex());
    }

    public IConstraint getBorderConstraint(IQuadEdge edge) {
        if (edge.isConstrainedRegionBorder()) {
            return this.borderConstraintMap.get(edge.getIndex());
        }
        return null;
    }

    public IConstraint getLinearConstraint(IQuadEdge edge) {
        if (edge.isConstraintLineMember()) {
            return this.linearConstraintMap.get(edge.getIndex());
        }
        return null;
    }
}

