/*
 * Decompiled with CFR 0.152.
 */
package sttp.client4.httpclient;

import java.io.Serializable;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.WebSocket;
import java.net.http.WebSocketHandshakeException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.runtime.function.JProcedure2;
import scala.runtime.java8.JFunction0;
import sttp.capabilities.package;
import sttp.client4.GenericRequest;
import sttp.client4.Response;
import sttp.client4.Response$;
import sttp.client4.WebSocketBackend;
import sttp.client4.compression.CompressionHandlers;
import sttp.client4.httpclient.HttpClientBackend;
import sttp.client4.internal.SttpToJavaConverters$;
import sttp.client4.internal.httpclient.AddToQueueListener;
import sttp.client4.internal.httpclient.DelegatingWebSocketListener;
import sttp.client4.internal.httpclient.Sequencer;
import sttp.client4.internal.httpclient.WebSocketImpl;
import sttp.client4.internal.ws.SimpleQueue;
import sttp.client4.internal.ws.WebSocketEvent;
import sttp.model.Header;
import sttp.model.Header$;
import sttp.model.HeaderNames$;
import sttp.model.ResponseMetadata;
import sttp.model.StatusCode$;
import sttp.monad.Canceler$;
import sttp.monad.MonadAsyncError;
import sttp.monad.syntax$;

public abstract class HttpClientAsyncBackend<F, S extends package.Streams<S>, BH, B>
extends HttpClientBackend<F, S, S, B>
implements WebSocketBackend<F> {
    private final HttpClient client;
    private final MonadAsyncError monad;
    private final Function1<HttpRequest, HttpRequest> customizeRequest;

    public HttpClientAsyncBackend(HttpClient client, MonadAsyncError<F> monad, boolean closeClient, Function1<HttpRequest, HttpRequest> customizeRequest, CompressionHandlers<S, B> compressionHandlers) {
        this.client = client;
        this.monad = monad;
        this.customizeRequest = customizeRequest;
        super(client, closeClient, compressionHandlers);
    }

    @Override
    public MonadAsyncError<F> monad() {
        return this.monad;
    }

    public abstract <T> F createSimpleQueue();

    public abstract F createSequencer();

    public abstract HttpResponse.BodyHandler<BH> createBodyHandler();

    public abstract B lowLevelBodyToBody(BH var1);

    public abstract void cancelLowLevelBody(BH var1);

    public abstract B bodyToLimitedBody(B var1, long var2);

    public abstract B emptyBody();

    public abstract <T> F ensureOnAbnormal(F var1, Function0<F> var2);

    @Override
    public <T> F sendRegular(GenericRequest<T, S> request) {
        return (F)this.monad().flatMap(this.convertRequest(request), (Function1 & Serializable)convertedRequest -> {
            HttpRequest jRequest = (HttpRequest)this.customizeRequest.apply(convertedRequest);
            AtomicReference lowLevelBody = new AtomicReference();
            return this.ensureOnAbnormal(syntax$.MODULE$.MonadErrorOps(() -> this.sendRegular$$anonfun$1$$anonfun$1(jRequest, lowLevelBody)).flatMap((Function1 & Serializable)jResponse -> {
                Object body = Option$.MODULE$.apply(jResponse.body()).map((Function1 & Serializable)p -> this.lowLevelBodyToBody(p)).getOrElse(this::$anonfun$2);
                Object limitedBody = request.options().maxResponseBodyLength().fold(() -> HttpClientAsyncBackend.$anonfun$3(body), (Function1 & Serializable)_$2 -> this.$anonfun$4(body, BoxesRunTime.unboxToLong((Object)_$2)));
                return this.readResponse((HttpResponse<?>)jResponse, package$.MODULE$.Left().apply(limitedBody), request);
            }, this.monad()), () -> this.sendRegular$$anonfun$1$$anonfun$3(lowLevelBody));
        });
    }

    @Override
    public <T> F sendWebSocket(GenericRequest<T, S> request) {
        return (F)syntax$.MODULE$.MonadErrorOps(() -> this.sendWebSocket$$anonfun$1(request)).handleError((PartialFunction)new Serializable(request, this){
            private final GenericRequest request$7;
            private final /* synthetic */ HttpClientAsyncBackend $outer;
            {
                this.request$7 = request$10;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                CompletionException e;
                Throwable throwable = x;
                return throwable instanceof CompletionException && (e = (CompletionException)throwable).getCause() instanceof WebSocketHandshakeException;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                CompletionException e;
                Throwable throwable = x;
                if (throwable instanceof CompletionException && (e = (CompletionException)throwable).getCause() instanceof WebSocketHandshakeException) {
                    return this.$outer.readResponse(((WebSocketHandshakeException)e.getCause()).getResponse(), package$.MODULE$.Left().apply(this.$outer.emptyBody()), this.request$7);
                }
                return function1.apply((Object)x);
            }
        }, this.monad());
    }

    private <T> F sendWebSocket(GenericRequest<T, S> request, SimpleQueue<F, WebSocketEvent> queue, Sequencer<F> sequencer) {
        AtomicBoolean isOpen = new AtomicBoolean(false);
        AtomicReference lowLevelWS = new AtomicReference();
        return (F)this.ensureOnAbnormal(this.monad().flatten(this.monad().async((Function1 & Serializable)cb -> {
            DelegatingWebSocketListener listener = new DelegatingWebSocketListener(new AddToQueueListener(queue, isOpen), (Function1<WebSocket, BoxedUnit>)(JProcedure1 & Serializable)ws -> {
                lowLevelWS.set(ws);
                WebSocketImpl<F> webSocket = new WebSocketImpl<F>((WebSocket)ws, queue, isOpen, sequencer, this.monad(), (Function1<CompletableFuture<WebSocket>, Object>)(Function1 & Serializable)cf -> this.monad().async((Function1 & Serializable)cb -> {
                    cf.whenComplete(new BiConsumer<WebSocket, Throwable>(cb){
                        private final Function1 cb$7;
                        {
                            this.cb$7 = cb$9;
                        }

                        public void accept(WebSocket t, Throwable error) {
                            if (error != null) {
                                this.cb$7.apply((Object)package$.MODULE$.Left().apply((Object)error));
                                return;
                            }
                            this.cb$7.apply((Object)package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
                        }
                    });
                    return Canceler$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                        boolean bl = cf.cancel(true);
                    });
                }));
                String subprotocol = ws.getSubprotocol();
                Nil$ headers = subprotocol != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(subprotocol)) ? (List)new .colon.colon((Object)Header$.MODULE$.apply(HeaderNames$.MODULE$.SecWebSocketProtocol(), subprotocol), (List)Nil$.MODULE$) : package$.MODULE$.Nil();
                Response<BoxedUnit> baseResponse = Response$.MODULE$.apply(BoxedUnit.UNIT, StatusCode$.MODULE$.SwitchingProtocols(), "", (Seq<Header>)headers, (List<ResponseMetadata>)package$.MODULE$.Nil(), request.onlyMetadata());
                Object body = this.bodyFromHttpClient().apply(package$.MODULE$.Right().apply(webSocket), request.response(), baseResponse);
                HttpClientAsyncBackend.success$2(cb, syntax$.MODULE$.MonadErrorOps(() -> HttpClientAsyncBackend.$anonfun$5$$anonfun$1(body)).map((Function1 & Serializable)b -> baseResponse.copy((BoxedUnit)b, baseResponse.copy$default$2(), baseResponse.copy$default$3(), baseResponse.copy$default$4(), baseResponse.copy$default$5(), baseResponse.copy$default$6()), this.monad()));
            }, (Function1<Throwable, BoxedUnit>)(JProcedure1 & Serializable)t -> HttpClientAsyncBackend.error$2(cb, t));
            CompletionStage cf = ((CompletableFuture)this.prepareWebSocketBuilder(request, this.client).buildAsync(request.uri().toJavaUri(), listener).thenApply(SttpToJavaConverters$.MODULE$.toJavaFunction((JProcedure1 & Serializable)_$3 -> {}))).exceptionally(SttpToJavaConverters$.MODULE$.toJavaFunction((JProcedure1 & Serializable)t -> cb.apply((Object)package$.MODULE$.Left().apply(t))));
            return Canceler$.MODULE$.apply((Function0)((JFunction0.mcV.sp & Serializable)() -> HttpClientAsyncBackend.sendWebSocket$$anonfun$2$$anonfun$1((CompletableFuture)cf)));
        })), () -> this.sendWebSocket$$anonfun$3(lowLevelWS));
    }

    private static final void success$1(Function1 cb$1, HttpResponse r) {
        cb$1.apply((Object)package$.MODULE$.Right().apply((Object)r));
    }

    private static final void error$1(Function1 cb$2, Throwable t) {
        cb$2.apply((Object)package$.MODULE$.Left().apply((Object)t));
    }

    private final Object sendRegular$$anonfun$1$$anonfun$1(HttpRequest jRequest$1, AtomicReference lowLevelBody$1) {
        return this.monad().async((Function1 & Serializable)cb -> {
            CompletableFuture cf = this.client.sendAsync(jRequest$1, this.createBodyHandler());
            cf.whenComplete(SttpToJavaConverters$.MODULE$.toJavaBiConsumer((JProcedure2 & Serializable)(t, u) -> {
                if (t != null) {
                    lowLevelBody$1.set(t.body());
                    HttpClientAsyncBackend.success$1(cb, t);
                }
                if (u != null) {
                    HttpClientAsyncBackend.error$1(cb, u);
                    return;
                }
            }));
            return Canceler$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                boolean bl = cf.cancel(true);
            });
        });
    }

    private final Object $anonfun$2() {
        return this.emptyBody();
    }

    private static final Object $anonfun$3(Object body$1) {
        return body$1;
    }

    private final /* synthetic */ Object $anonfun$4(Object body$2, long _$2) {
        return this.bodyToLimitedBody(body$2, _$2);
    }

    private final void sendRegular$$anonfun$1$$anonfun$3$$anonfun$1(AtomicReference lowLevelBody$5) {
        Object llb = lowLevelBody$5.get();
        if (llb != null) {
            this.cancelLowLevelBody(llb);
            return;
        }
    }

    private final Object sendRegular$$anonfun$1$$anonfun$3(AtomicReference lowLevelBody$4) {
        return this.monad().eval((Function0 & Serializable)() -> {
            this.sendRegular$$anonfun$1$$anonfun$3$$anonfun$1(lowLevelBody$4);
            return BoxedUnit.UNIT;
        });
    }

    private final Object sendWebSocket$$anonfun$1$$anonfun$1() {
        return this.createSimpleQueue();
    }

    private final Object sendWebSocket$$anonfun$1$$anonfun$2$$anonfun$1() {
        return this.createSequencer();
    }

    private final Object sendWebSocket$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1(GenericRequest request$6, SimpleQueue queue$2, Sequencer sequencer$1) {
        return this.sendWebSocket(request$6, queue$2, sequencer$1);
    }

    private final Object sendWebSocket$$anonfun$1(GenericRequest request$3) {
        return syntax$.MODULE$.MonadErrorOps(this::sendWebSocket$$anonfun$1$$anonfun$1).flatMap((Function1 & Serializable)queue -> syntax$.MODULE$.MonadErrorOps(this::sendWebSocket$$anonfun$1$$anonfun$2$$anonfun$1).flatMap((Function1 & Serializable)sequencer -> syntax$.MODULE$.MonadErrorOps(() -> this.sendWebSocket$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1(request$3, queue, sequencer)).map((Function1 & Serializable)ws -> ws, this.monad()), this.monad()), this.monad());
    }

    private static final void success$2(Function1 cb$4, Object r) {
        cb$4.apply((Object)package$.MODULE$.Right().apply(r));
    }

    private static final void error$2(Function1 cb$5, Throwable t) {
        cb$5.apply((Object)package$.MODULE$.Left().apply((Object)t));
    }

    private static final Object $anonfun$5$$anonfun$1(Object body$3) {
        return body$3;
    }

    private static final /* synthetic */ void sendWebSocket$$anonfun$2$$anonfun$1(CompletableFuture cf$4) {
        boolean bl = cf$4.cancel(true);
    }

    private static final void sendWebSocket$$anonfun$3$$anonfun$1(WebSocket llws$1) {
        llws$1.abort();
    }

    private final Object sendWebSocket$$anonfun$3(AtomicReference lowLevelWS$3) {
        WebSocket llws = (WebSocket)lowLevelWS$3.get();
        if (llws != null) {
            return this.monad().eval((Function0 & Serializable)() -> {
                HttpClientAsyncBackend.sendWebSocket$$anonfun$3$$anonfun$1(llws);
                return BoxedUnit.UNIT;
            });
        }
        return this.monad().unit((Object)BoxedUnit.UNIT);
    }
}

