/*
 * Decompiled with CFR 0.152.
 */
package sttp.client4.httpclient;

import java.io.Serializable;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.WebSocket;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.concurrent.duration.Duration;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import sttp.capabilities.package;
import sttp.client4.Backend;
import sttp.client4.BackendOptions;
import sttp.client4.GenericRequest;
import sttp.client4.GenericRequestBody;
import sttp.client4.MultipartBody;
import sttp.client4.Response$;
import sttp.client4.SttpClientException$;
import sttp.client4.compression.CompressionHandlers;
import sttp.client4.compression.Decompressor$;
import sttp.client4.httpclient.HttpClientBackend$;
import sttp.client4.internal.SttpToJavaConverters$;
import sttp.client4.internal.httpclient.BodyFromHttpClient;
import sttp.client4.internal.httpclient.BodyToHttpClient;
import sttp.model.Header;
import sttp.model.Header$;
import sttp.model.HeaderNames$;
import sttp.model.HttpVersion;
import sttp.model.Method$;
import sttp.model.ResponseMetadata;
import sttp.model.ResponseMetadata$;
import sttp.model.StatusCode;
import sttp.model.StatusCode$;
import sttp.monad.MonadError;
import sttp.monad.syntax$;
import sttp.ws.WebSocket;

public abstract class HttpClientBackend<F, S extends package.Streams<S>, P, B>
implements Backend<F> {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(HttpClientBackend.class.getDeclaredField("wsIllegalHeaders$lzy1"));
    private final HttpClient client;
    private final boolean closeClient;
    private final CompressionHandlers<P, B> compressionHandlers;
    private final MonadError<F> _monad;
    private volatile Object wsIllegalHeaders$lzy1;

    public static HttpClient defaultClient(BackendOptions backendOptions, Option<Executor> option) {
        return HttpClientBackend$.MODULE$.defaultClient(backendOptions, option);
    }

    public HttpClientBackend(HttpClient client, boolean closeClient, CompressionHandlers<P, B> compressionHandlers) {
        this.client = client;
        this.closeClient = closeClient;
        this.compressionHandlers = compressionHandlers;
        this._monad = this.monad();
    }

    public abstract package.Streams<S> streams();

    @Override
    public <T> F send(GenericRequest<T, P> request) {
        return this.adjustExceptions(request, () -> this.send$$anonfun$1(request));
    }

    public abstract <T> F sendRegular(GenericRequest<T, P> var1);

    public abstract <T> F sendWebSocket(GenericRequest<T, P> var1);

    private <T> F adjustExceptions(GenericRequest<?, ?> request, Function0<F> t) {
        return (F)SttpClientException$.MODULE$.adjustExceptions(this.monad(), t, (Function1<Exception, Option<Exception>>)(Function1 & Serializable)_$2 -> SttpClientException$.MODULE$.defaultExceptionToSttpClientException((GenericRequest)request, (Exception)_$2));
    }

    public abstract BodyToHttpClient<F, S, P> bodyToHttpClient();

    public abstract BodyFromHttpClient<F, S, B> bodyFromHttpClient();

    public abstract B addOnEndCallbackToBody(B var1, Function0<BoxedUnit> var2);

    public <T> F convertRequest(GenericRequest<T, P> request) {
        return (F)this.monad().suspend(() -> this.convertRequest$$anonfun$1(request));
    }

    public <T> F readResponse(HttpResponse<?> res, Either<B, WebSocket<F>> resBody, GenericRequest<T, P> request) {
        String method;
        Map headersMap = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(res.headers().map()).asScala();
        List headers = ((IterableOnceOps)headersMap.keySet().flatMap((Function1 & Serializable)name -> (IterableOnce)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)headersMap.apply(name)).asScala()).map((Function1 & Serializable)_$5 -> Header$.MODULE$.apply(name, _$5)))).toList();
        int code = StatusCode$.MODULE$.apply(res.statusCode());
        ResponseMetadata responseMetadata = ResponseMetadata$.MODULE$.apply(code, "", (Seq)headers);
        Option encoding = headers.collectFirst((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Header x) {
                Header header = x;
                Header h = header;
                return h.is(HeaderNames$.MODULE$.ContentEncoding());
            }

            public final Object applyOrElse(Header x, Function1 function1) {
                Header header = x;
                Header h = header;
                if (h.is(HeaderNames$.MODULE$.ContentEncoding())) {
                    return h.value();
                }
                return function1.apply((Object)x);
            }
        });
        boolean isBodyEmpty = headers.collectFirst((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Header x) {
                Header header = x;
                Header h = header;
                return h.is(HeaderNames$.MODULE$.ContentLength());
            }

            public final Object applyOrElse(Header x, Function1 function1) {
                Header header = x;
                Header h = header;
                if (h.is(HeaderNames$.MODULE$.ContentLength())) {
                    return h.value();
                }
                return function1.apply((Object)x);
            }
        }).contains((Object)"0");
        String string = method = Method$.MODULE$.apply(res.request().method());
        String string2 = Method$.MODULE$.HEAD();
        Either decodedResBody = (string == null ? string2 != null : !string.equals(string2)) ? resBody.left().map((Function1 & Serializable)is -> encoding.filterNot((Function1 & Serializable)e -> StatusCode$.MODULE$.equals$extension(code, (Object)new StatusCode(StatusCode$.MODULE$.NoContent())) || isBodyEmpty || !request.autoDecompressionEnabled() || e.isEmpty()).map((Function1 & Serializable)e -> Decompressor$.MODULE$.decompressIfPossible(is, (String)e, this.compressionHandlers.decompressors())).getOrElse(() -> HttpClientBackend.$anonfun$4$$anonfun$3(is))) : resBody;
        Either decodedResBodyWithCallback = decodedResBody.left().map((Function1 & Serializable)body -> this.addOnEndCallbackToBody(body, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> request.options().onBodyReceived().apply((Object)responseMetadata)));
        F body2 = this.bodyFromHttpClient().apply(decodedResBodyWithCallback, request.response(), responseMetadata);
        return (F)this.monad().map(body2, (Function1 & Serializable)_$6 -> Response$.MODULE$.apply(_$6, code, "", (Seq<Header>)headers, (List<ResponseMetadata>)package$.MODULE$.Nil(), request.onlyMetadata()));
    }

    public <T> WebSocket.Builder prepareWebSocketBuilder(GenericRequest<T, P> request, HttpClient client) {
        WebSocket.Builder builder;
        List wsSubProtocols;
        List list = wsSubProtocols = ((IterableOnceOps)((IterableOps)Option$.MODULE$.option2Iterable(request.headers().find((Function1 & Serializable)_$7 -> _$7.is(HeaderNames$.MODULE$.SecWebSocketProtocol())).map((Function1 & Serializable)_$8 -> _$8.value())).toSeq().flatMap((Function1 & Serializable)_$9 -> Predef$.MODULE$.wrapRefArray((Object[])_$9.split(",")))).map((Function1 & Serializable)_$10 -> _$10.trim())).toList();
        Nil$ nil$ = package$.MODULE$.Nil();
        List list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            builder = client.newWebSocketBuilder();
        } else if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            String string = (String)colon2.head();
            List list3 = colon2.next$access$1();
            String head = string;
            Nil$ nil$2 = package$.MODULE$.Nil();
            List list4 = list3;
            if (!(nil$2 != null ? !nil$2.equals(list4) : list4 != null)) {
                builder = client.newWebSocketBuilder().subprotocols(head, new String[0]);
            } else {
                String head2 = string;
                List tail = list3;
                builder = client.newWebSocketBuilder().subprotocols(head2, (String[])Arrays$.MODULE$.seqToArray((Seq)tail, String.class));
            }
        } else {
            throw new MatchError((Object)list);
        }
        WebSocket.Builder wsBuilder = builder;
        client.connectTimeout().map(SttpToJavaConverters$.MODULE$.toJavaFunction((Function1 & Serializable)d -> wsBuilder.connectTimeout((java.time.Duration)d)));
        this.filterIllegalWsHeaders(request).headers().foreach((Function1 & Serializable)h -> wsBuilder.header(h.name(), h.value()));
        return wsBuilder;
    }

    private <T> GenericRequest<T, P> filterIllegalWsHeaders(GenericRequest<T, P> request) {
        return (GenericRequest)request.withHeaders((Seq<Header>)((Seq)request.headers().filter((Function1 & Serializable)h -> !this.wsIllegalHeaders().contains((Object)h.name().toLowerCase()))));
    }

    private Set<String> wsIllegalHeaders() {
        Object object = this.wsIllegalHeaders$lzy1;
        if (object instanceof Set) {
            return (Set)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Set)this.wsIllegalHeaders$lzyINIT1();
    }

    private Object wsIllegalHeaders$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.wsIllegalHeaders$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Set set = null;
                    try {
                        set = (Set)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{HeaderNames$.MODULE$.SecWebSocketAccept(), HeaderNames$.MODULE$.SecWebSocketExtensions(), HeaderNames$.MODULE$.SecWebSocketKey(), HeaderNames$.MODULE$.SecWebSocketVersion(), HeaderNames$.MODULE$.SecWebSocketProtocol()}))).map((Function1 & Serializable)_$11 -> _$11.toLowerCase());
                        object2 = set == null ? LazyVals.NullValue$.MODULE$ : set;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.wsIllegalHeaders$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.wsIllegalHeaders$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return set;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public F close() {
        if (this.closeClient) {
            return (F)this.monad().eval((Function0 & Serializable)() -> {
                this.close$$anonfun$1();
                return BoxedUnit.UNIT;
            });
        }
        return (F)this.monad().unit((Object)BoxedUnit.UNIT);
    }

    private final Object send$$anonfun$1(GenericRequest request$1) {
        if (request$1.isWebSocket()) {
            return this.sendWebSocket(request$1);
        }
        return this.sendRegular(request$1);
    }

    private final Object convertRequest$$anonfun$1$$anonfun$3(GenericRequest request$5, HttpRequest.Builder builder$3, Option contentType$1) {
        return this.bodyToHttpClient().apply(request$5, builder$3, (Option<String>)contentType$1);
    }

    private final Object convertRequest$$anonfun$1(GenericRequest request$3) {
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(request$3.uri().toJavaUri());
        request$3.httpVersion().foreach((Function1 & Serializable)x$1 -> {
            HttpVersion httpVersion = x$1;
            if (HttpVersion.HTTP_1_1$.MODULE$.equals(httpVersion)) {
                return builder.version(HttpClient.Version.HTTP_1_1);
            }
            if (HttpVersion.HTTP_2$.MODULE$.equals(httpVersion)) {
                return builder.version(HttpClient.Version.HTTP_2);
            }
            return BoxedUnit.UNIT;
        });
        Option contentType = request$3.headers().find((Function1 & Serializable)_$3 -> _$3.is(HeaderNames$.MODULE$.ContentType())).map((Function1 & Serializable)_$4 -> _$4.value());
        contentType.foreach((Function1 & Serializable)ct -> {
            GenericRequestBody genericRequestBody = request$3.body();
            if (genericRequestBody instanceof MultipartBody) {
                return BoxedUnit.UNIT;
            }
            return builder.header(HeaderNames$.MODULE$.ContentType(), (String)ct);
        });
        return syntax$.MODULE$.MonadErrorOps(() -> this.convertRequest$$anonfun$1$$anonfun$3(request$3, builder, contentType)).map((Function1 & Serializable)httpBody -> {
            builder.method(request$3.method(), (HttpRequest.BodyPublisher)httpBody);
            ((IterableOnceOps)request$3.headers().filterNot((Function1 & Serializable)h -> h.is(HeaderNames$.MODULE$.ContentLength()) || h.is(HeaderNames$.MODULE$.ContentType()))).foreach((Function1 & Serializable)h -> builder.header(h.name(), h.value()));
            Duration timeout = request$3.options().readTimeout();
            if (timeout.isFinite()) {
                return builder.timeout(java.time.Duration.ofMillis(timeout.toMillis())).build();
            }
            return builder.build();
        }, this._monad);
    }

    private static final Object $anonfun$4$$anonfun$3(Object is$2) {
        return is$2;
    }

    private final void close$$anonfun$1() {
        Optional<BoxedUnit> optional = this.client.executor().map(new Function<Executor, BoxedUnit>(){

            public void apply(Executor t) {
                Executor executor = t;
                if (executor instanceof ThreadPoolExecutor) {
                    ThreadPoolExecutor tpe = (ThreadPoolExecutor)executor;
                    tpe.shutdown();
                    return;
                }
            }
        });
    }

    public static class ProxyAuthenticator
    extends Authenticator {
        private final BackendOptions.ProxyAuth auth;

        public ProxyAuthenticator(BackendOptions.ProxyAuth auth) {
            this.auth = auth;
        }

        @Override
        public PasswordAuthentication getPasswordAuthentication() {
            Authenticator.RequestorType requestorType = this.getRequestorType();
            Authenticator.RequestorType requestorType2 = Authenticator.RequestorType.PROXY;
            if (!(requestorType != null ? !((Object)((Object)requestorType)).equals((Object)requestorType2) : requestorType2 != null)) {
                return new PasswordAuthentication(this.auth.username(), this.auth.password().toCharArray());
            }
            return null;
        }
    }
}

