/*
 * Decompiled with CFR 0.152.
 */
package sttp.client4.httpurlconnection;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.LambdaMetafactory;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.file.Files;
import java.util.concurrent.ThreadLocalRandom;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sttp.client4.BackendOptions;
import sttp.client4.BasicBodyPart;
import sttp.client4.BasicMultipartBody;
import sttp.client4.ByteArrayBody;
import sttp.client4.ByteArrayBody$;
import sttp.client4.ByteBufferBody;
import sttp.client4.ByteBufferBody$;
import sttp.client4.FileBody;
import sttp.client4.FileBody$;
import sttp.client4.GenericRequest;
import sttp.client4.GenericRequestBody;
import sttp.client4.GenericWebSocketResponseAs;
import sttp.client4.InputStreamBody;
import sttp.client4.InputStreamBody$;
import sttp.client4.MultipartStreamBody;
import sttp.client4.MultipartStreamBody$;
import sttp.client4.NoBody$;
import sttp.client4.Response;
import sttp.client4.Response$;
import sttp.client4.StreamBody;
import sttp.client4.StreamBody$;
import sttp.client4.StringBody;
import sttp.client4.StringBody$;
import sttp.client4.SttpClientException$;
import sttp.client4.SyncBackend;
import sttp.client4.compression.CompressionHandlers;
import sttp.client4.compression.Compressor$;
import sttp.client4.compression.Decompressor$;
import sttp.client4.httpurlconnection.HttpURLConnectionBackend$;
import sttp.client4.internal.BodyFromResponseAs;
import sttp.client4.internal.FailingLimitedInputStream;
import sttp.client4.internal.FileHelpers$;
import sttp.client4.internal.OnEndInputStream;
import sttp.client4.internal.SttpFile;
import sttp.client4.internal.package$;
import sttp.client4.testing.SyncBackendStub;
import sttp.client4.ws.GotAWebSocketException;
import sttp.client4.ws.NotAWebSocketException;
import sttp.model.Header;
import sttp.model.Header$;
import sttp.model.HeaderNames$;
import sttp.model.MediaType;
import sttp.model.Part;
import sttp.model.ResponseMetadata;
import sttp.model.ResponseMetadata$;
import sttp.model.StatusCode;
import sttp.model.StatusCode$;
import sttp.model.Uri;
import sttp.monad.IdentityMonad$;
import sttp.monad.MonadError;

public class HttpURLConnectionBackend
implements SyncBackend {
    private final BackendOptions opts;
    private final Function1<HttpURLConnection, BoxedUnit> customizeConnection;
    private final Function1<String, URL> createURL;
    private final Function2<URL, Option<Proxy>, URLConnection> openConnection;
    private final CompressionHandlers<Object, InputStream> compressionHandlers;
    private final MonadError monad;
    private final char[] BoundaryChars;
    private final BodyFromResponseAs<Object, InputStream, Nothing$, Nothing$> bodyFromResponseAs;

    public static CompressionHandlers<Object, InputStream> DefaultCompressionHandlers() {
        return HttpURLConnectionBackend$.MODULE$.DefaultCompressionHandlers();
    }

    public static SyncBackend apply(BackendOptions backendOptions, Function1<HttpURLConnection, BoxedUnit> function1, Function1<String, URL> function12, Function2<URL, Option<Proxy>, URLConnection> function2, CompressionHandlers<Object, InputStream> compressionHandlers) {
        return HttpURLConnectionBackend$.MODULE$.apply(backendOptions, function1, function12, function2, compressionHandlers);
    }

    public static Function2<URL, Option<Proxy>, URLConnection> defaultOpenConnection() {
        return HttpURLConnectionBackend$.MODULE$.defaultOpenConnection();
    }

    public static SyncBackendStub stub() {
        return HttpURLConnectionBackend$.MODULE$.stub();
    }

    public static BackendOptions apply$default$1() {
        return HttpURLConnectionBackend$.MODULE$.apply$default$1();
    }

    public static Function1<HttpURLConnection, BoxedUnit> apply$default$2() {
        return HttpURLConnectionBackend$.MODULE$.apply$default$2();
    }

    public static Function1<String, URL> apply$default$3() {
        return HttpURLConnectionBackend$.MODULE$.apply$default$3();
    }

    public static Function2<URL, Option<Proxy>, URLConnection> apply$default$4() {
        return HttpURLConnectionBackend$.MODULE$.apply$default$4();
    }

    public static CompressionHandlers<Object, InputStream> apply$default$5() {
        return HttpURLConnectionBackend$.MODULE$.apply$default$5();
    }

    public HttpURLConnectionBackend(BackendOptions opts, Function1<HttpURLConnection, BoxedUnit> customizeConnection, Function1<String, URL> createURL, Function2<URL, Option<Proxy>, URLConnection> openConnection, CompressionHandlers<Object, InputStream> compressionHandlers) {
        this.opts = opts;
        this.customizeConnection = customizeConnection;
        this.createURL = createURL;
        this.openConnection = openConnection;
        this.compressionHandlers = compressionHandlers;
        this.monad = IdentityMonad$.MODULE$;
        this.BoundaryChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".toCharArray();
        this.bodyFromResponseAs = new BodyFromResponseAs<Object, InputStream, Nothing$, Nothing$>(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super($outer.monad());
            }

            public InputStream withReplayableBody(InputStream response, Either replayableBody) {
                Either either = replayableBody;
                if (either instanceof Left) {
                    byte[] bytes = (byte[])((Left)either).value();
                    return new ByteArrayInputStream(bytes);
                }
                if (either instanceof Right) {
                    SttpFile file = (SttpFile)((Right)either).value();
                    return new BufferedInputStream(new FileInputStream(file.toFile()));
                }
                throw new MatchError((Object)either);
            }

            public BoxedUnit regularIgnore(InputStream response) {
                response.close();
                return BoxedUnit.UNIT;
            }

            public byte[] regularAsByteArray(InputStream response) {
                return package$.MODULE$.toByteArray(response);
            }

            public SttpFile regularAsFile(InputStream response, SttpFile file) {
                FileHelpers$.MODULE$.saveFile(file.toFile(), response);
                return file;
            }

            public Tuple2 regularAsStream(InputStream response) {
                throw new IllegalStateException();
            }

            public InputStream regularAsInputStream(InputStream response) {
                return response;
            }

            public Object handleWS(GenericWebSocketResponseAs responseAs, ResponseMetadata meta, Nothing$ ws) {
                throw ws;
            }

            public BoxedUnit cleanupWhenNotAWebSocket(InputStream response, NotAWebSocketException e) {
                return BoxedUnit.UNIT;
            }

            public BoxedUnit cleanupWhenGotWebSocket(Nothing$ response, GotAWebSocketException e) {
                return BoxedUnit.UNIT;
            }
        };
    }

    @Override
    public <T> Response<T> send(GenericRequest<T, Object> r) {
        return (Response)this.adjustExceptions(r, () -> this.send$$anonfun$1(r));
    }

    @Override
    public MonadError<Object> monad() {
        return this.monad;
    }

    /*
     * Unable to fully structure code
     */
    private HttpURLConnection openConnection(Uri uri) {
        url = (URL)this.createURL.apply((Object)uri.toString());
        var4_3 = this.opts.proxy();
        if (!(var4_3 instanceof Some)) ** GOTO lbl-1000
        p = (BackendOptions.Proxy)((Some)var4_3).value();
        if (uri.host().forall((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$3(sttp.client4.BackendOptions$Proxy java.lang.String ), (Ljava/lang/String;)Z)((BackendOptions.Proxy)p))) {
            p.auth().foreach((Function1)(JProcedure1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)V, $anonfun$4(sttp.client4.BackendOptions$ProxyAuth ), (Lsttp/client4/BackendOptions$ProxyAuth;)V)());
            v0 = (URLConnection)this.openConnection.apply((Object)url, (Object)Some$.MODULE$.apply((Object)p.asJavaProxy()));
        } else lbl-1000:
        // 2 sources

        {
            v0 = (URLConnection)this.openConnection.apply((Object)url, (Object)None$.MODULE$);
        }
        conn = v0;
        return (HttpURLConnection)conn;
    }

    private Option<OutputStream> writeBody(GenericRequestBody<Object> body, GenericRequest<?, Object> r, HttpURLConnection c) {
        GenericRequestBody<Object> genericRequestBody;
        block8: {
            block7: {
                block6: {
                    genericRequestBody = body;
                    if (NoBody$.MODULE$.equals(genericRequestBody)) {
                        return None$.MODULE$;
                    }
                    if (genericRequestBody instanceof BasicBodyPart) {
                        BasicBodyPart b = (BasicBodyPart)genericRequestBody;
                        OutputStream os = c.getOutputStream();
                        this.writeBasicBody(b, os);
                        return Some$.MODULE$.apply((Object)os);
                    }
                    if (!(genericRequestBody instanceof StreamBody)) break block6;
                    StreamBody streamBody = StreamBody$.MODULE$.unapply((StreamBody)genericRequestBody);
                    Object BinaryStream = streamBody._1();
                    break block7;
                }
                if (!(genericRequestBody instanceof MultipartStreamBody)) break block8;
                MultipartStreamBody multipartStreamBody = MultipartStreamBody$.MODULE$.unapply((MultipartStreamBody)genericRequestBody);
                Seq seq = multipartStreamBody._1();
            }
            return None$.MODULE$;
        }
        if (genericRequestBody instanceof BasicMultipartBody) {
            BasicMultipartBody mp = (BasicMultipartBody)genericRequestBody;
            return this.setMultipartBody(r, mp, c);
        }
        throw new MatchError(genericRequestBody);
    }

    private int timeout(Duration t) {
        if (t.isFinite()) {
            return (int)t.toMillis();
        }
        return 0;
    }

    private void writeBasicBody(BasicBodyPart body, OutputStream os) {
        BasicBodyPart basicBodyPart = body;
        if (basicBodyPart instanceof StringBody) {
            StringBody stringBody = StringBody$.MODULE$.unapply((StringBody)basicBodyPart);
            String string = stringBody._1();
            String string2 = stringBody._2();
            MediaType mediaType = stringBody._3();
            String b = string;
            String encoding = string2;
            OutputStreamWriter writer = new OutputStreamWriter(os, encoding);
            writer.write(b);
            writer.flush();
            return;
        }
        if (basicBodyPart instanceof ByteArrayBody) {
            ByteArrayBody byteArrayBody = ByteArrayBody$.MODULE$.unapply((ByteArrayBody)basicBodyPart);
            byte[] byArray = byteArrayBody._1();
            MediaType mediaType = byteArrayBody._2();
            byte[] b = byArray;
            os.write(b);
            return;
        }
        if (basicBodyPart instanceof ByteBufferBody) {
            ByteBufferBody byteBufferBody = ByteBufferBody$.MODULE$.unapply((ByteBufferBody)basicBodyPart);
            ByteBuffer byteBuffer = byteBufferBody._1();
            MediaType mediaType = byteBufferBody._2();
            ByteBuffer b = byteBuffer;
            WritableByteChannel channel = Channels.newChannel(os);
            int n = channel.write(b);
            return;
        }
        if (basicBodyPart instanceof InputStreamBody) {
            InputStreamBody inputStreamBody = InputStreamBody$.MODULE$.unapply((InputStreamBody)basicBodyPart);
            InputStream inputStream = inputStreamBody._1();
            MediaType mediaType = inputStreamBody._2();
            InputStream b = inputStream;
            package$.MODULE$.transfer(b, os);
            return;
        }
        if (basicBodyPart instanceof FileBody) {
            FileBody fileBody = FileBody$.MODULE$.unapply((FileBody)basicBodyPart);
            SttpFile sttpFile = fileBody._1();
            MediaType mediaType = fileBody._2();
            SttpFile f = sttpFile;
            long l = Files.copy(f.toPath(), os);
            return;
        }
        throw new MatchError((Object)basicBodyPart);
    }

    private Option<OutputStream> setMultipartBody(GenericRequest<?, Object> r, BasicMultipartBody mp, HttpURLConnection c) {
        ThreadLocalRandom tlr = ThreadLocalRandom.current();
        String boundary = scala.package$.MODULE$.List().fill(32, () -> this.$anonfun$5(tlr)).mkString();
        Seq partsWithHeaders = (Seq)mp.parts().map((Function1 & Serializable)p -> {
            String contentDisposition = new StringBuilder(2).append(HeaderNames$.MODULE$.ContentDisposition()).append(": ").append(p.contentDispositionHeaderValue()).toString();
            Seq otherHeaders = (Seq)p.headers().map((Function1 & Serializable)h -> new StringBuilder(2).append(h.name()).append(": ").append(h.value()).toString());
            List allHeaders = (List)((IterableOps)new .colon.colon((Object)contentDisposition, (List)Nil$.MODULE$)).$plus$plus((IterableOnce)otherHeaders);
            return Tuple2$.MODULE$.apply((Object)allHeaders.mkString(package$.MODULE$.CrLf()), p);
        });
        String dashes = "--";
        long dashesLen = dashes.length();
        long crLfLen = package$.MODULE$.CrLf().length();
        long boundaryLen = boundary.length();
        long finalBoundaryLen = dashesLen + boundaryLen + dashesLen + crLfLen;
        Option contentLength = (Option)((IterableOnceOps)partsWithHeaders.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                None$ none$;
                String headers = (String)tuple2._1();
                Part p = (Part)tuple2._2();
                BasicBodyPart basicBodyPart = (BasicBodyPart)p.body();
                if (basicBodyPart instanceof StringBody) {
                    StringBody stringBody = StringBody$.MODULE$.unapply((StringBody)basicBodyPart);
                    String string = stringBody._1();
                    String string2 = stringBody._2();
                    MediaType mediaType = stringBody._3();
                    String b = string;
                    String encoding = string2;
                    none$ = Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)b.getBytes(encoding).length));
                } else if (basicBodyPart instanceof ByteArrayBody) {
                    ByteArrayBody byteArrayBody = ByteArrayBody$.MODULE$.unapply((ByteArrayBody)basicBodyPart);
                    byte[] byArray = byteArrayBody._1();
                    MediaType mediaType = byteArrayBody._2();
                    byte[] b = byArray;
                    none$ = Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)b.length));
                } else if (basicBodyPart instanceof ByteBufferBody) {
                    ByteBufferBody byteBufferBody = ByteBufferBody$.MODULE$.unapply((ByteBufferBody)basicBodyPart);
                    ByteBuffer byteBuffer = byteBufferBody._1();
                    MediaType mediaType = byteBufferBody._2();
                    none$ = None$.MODULE$;
                } else if (basicBodyPart instanceof InputStreamBody) {
                    InputStreamBody inputStreamBody = InputStreamBody$.MODULE$.unapply((InputStreamBody)basicBodyPart);
                    InputStream inputStream = inputStreamBody._1();
                    MediaType mediaType = inputStreamBody._2();
                    none$ = None$.MODULE$;
                } else if (basicBodyPart instanceof FileBody) {
                    FileBody fileBody = FileBody$.MODULE$.unapply((FileBody)basicBodyPart);
                    SttpFile sttpFile = fileBody._1();
                    MediaType mediaType = fileBody._2();
                    SttpFile b = sttpFile;
                    none$ = Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)b.toFile().length()));
                } else {
                    throw new MatchError((Object)basicBodyPart);
                }
                None$ bodyLen = none$;
                int headersLen = headers.getBytes(package$.MODULE$.Utf8()).length;
                return bodyLen.map((Function1)(JFunction1.mcJJ.sp & Serializable)bl -> dashesLen + boundaryLen + crLfLen + (long)headersLen + crLfLen + crLfLen + bl + crLfLen);
            }
            throw new MatchError((Object)tuple2);
        })).foldLeft((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)finalBoundaryLen)), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option2 = (Option)tuple2._2();
                if (option instanceof Some) {
                    long acc = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                    if (option2 instanceof Some) {
                        long l = BoxesRunTime.unboxToLong((Object)((Some)option2).value());
                        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(acc + l)));
                    }
                }
            }
            return None$.MODULE$;
        });
        String baseContentType = (String)r.headers().find((Function1 & Serializable)_$3 -> _$3.is(HeaderNames$.MODULE$.ContentType())).map((Function1 & Serializable)_$4 -> _$4.value()).getOrElse(HttpURLConnectionBackend::$anonfun$12);
        c.setRequestProperty(HeaderNames$.MODULE$.ContentType(), new StringBuilder(11).append(baseContentType).append("; boundary=").append(boundary).toString());
        contentLength.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)cl -> {
            c.setFixedLengthStreamingMode(cl);
            c.setRequestProperty(HeaderNames$.MODULE$.ContentLength(), BoxesRunTime.boxToLong((long)cl).toString());
        });
        LongRef total = LongRef.create((long)0L);
        OutputStream os = c.getOutputStream();
        partsWithHeaders.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String headers = (String)tuple2._1();
                Part p = (Part)tuple2._2();
                HttpURLConnectionBackend.writeMeta$1(os, total, dashes);
                HttpURLConnectionBackend.writeMeta$1(os, total, boundary);
                HttpURLConnectionBackend.writeMeta$1(os, total, package$.MODULE$.CrLf());
                HttpURLConnectionBackend.writeMeta$1(os, total, headers);
                HttpURLConnectionBackend.writeMeta$1(os, total, package$.MODULE$.CrLf());
                HttpURLConnectionBackend.writeMeta$1(os, total, package$.MODULE$.CrLf());
                this.writeBasicBody((BasicBodyPart)p.body(), os);
                HttpURLConnectionBackend.writeMeta$1(os, total, package$.MODULE$.CrLf());
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        HttpURLConnectionBackend.writeMeta$1(os, total, dashes);
        HttpURLConnectionBackend.writeMeta$1(os, total, boundary);
        HttpURLConnectionBackend.writeMeta$1(os, total, dashes);
        HttpURLConnectionBackend.writeMeta$1(os, total, package$.MODULE$.CrLf());
        return Some$.MODULE$.apply((Object)os);
    }

    private <T> Response<T> readResponse(HttpURLConnection c, InputStream is, GenericRequest<T, Object> request) {
        Vector headers = (Vector)((StrictOptimizedIterableOps)((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(c.getHeaderFields()).asScala()).toVector().filter((Function1 & Serializable)_$5 -> _$5._1() != null)).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                java.util.List vv = (java.util.List)tuple2._2();
                return (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(vv).asScala()).map((Function1 & Serializable)_$6 -> Header$.MODULE$.apply(k, _$6));
            }
            throw new MatchError((Object)tuple2);
        });
        Option contentEncoding = Option$.MODULE$.apply((Object)c.getHeaderField(HeaderNames$.MODULE$.ContentEncoding())).filter((Function1 & Serializable)_$7 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$7)));
        int code = StatusCode$.MODULE$.apply(c.getResponseCode());
        String string = c.getRequestMethod();
        String string2 = "HEAD";
        InputStream wrappedIs = (string == null ? string2 != null : !string.equals(string2)) && !StatusCode$.MODULE$.equals$extension(code, (Object)new StatusCode(StatusCode$.MODULE$.NoContent())) && request.autoDecompressionEnabled() ? this.wrapInput((Option<String>)contentEncoding, this.handleNullInput(is)) : this.handleNullInput(is);
        ResponseMetadata responseMetadata = ResponseMetadata$.MODULE$.apply(code, c.getResponseMessage(), (Seq)headers);
        OnEndInputStream isWithCallback = new OnEndInputStream(wrappedIs, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> request.options().onBodyReceived().apply((Object)responseMetadata));
        Object body = this.bodyFromResponseAs.apply(request.response(), responseMetadata, (Either<InputStream, Nothing$>)scala.package$.MODULE$.Left().apply((Object)isWithCallback));
        return Response$.MODULE$.apply(body, code, c.getResponseMessage(), (Seq<Header>)headers, (List<ResponseMetadata>)scala.package$.MODULE$.Nil(), request.onlyMetadata());
    }

    private InputStream handleNullInput(InputStream is) {
        if (is == null) {
            return new ByteArrayInputStream((byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Byte.TYPE)));
        }
        return is;
    }

    private InputStream wrapInput(Option<String> contentEncoding, InputStream is) {
        Option option = contentEncoding.map((Function1 & Serializable)_$8 -> _$8.toLowerCase());
        if (None$.MODULE$.equals(option)) {
            return is;
        }
        if (option instanceof Some) {
            String encoding = (String)((Some)option).value();
            return Decompressor$.MODULE$.decompressIfPossible(is, encoding, this.compressionHandlers.decompressors());
        }
        throw new MatchError((Object)option);
    }

    private <T> T adjustExceptions(GenericRequest<?, Object> request, Function0<T> t) {
        return (T)SttpClientException$.MODULE$.adjustExceptions(this.monad(), t, (Function1<Exception, Option<Exception>>)(Function1 & Serializable)_$9 -> SttpClientException$.MODULE$.defaultExceptionToSttpClientException((GenericRequest)request, (Exception)_$9));
    }

    @Override
    public void close() {
    }

    private static final InputStream $anonfun$1(InputStream is$1) {
        return is$1;
    }

    private static final /* synthetic */ InputStream $anonfun$2(InputStream is$2, long _$1) {
        return new FailingLimitedInputStream(is$2, _$1);
    }

    private final Response send$$anonfun$1(GenericRequest r$1) {
        Response response;
        Tuple2<GenericRequestBody<Object>, Option<Object>> tuple2 = Compressor$.MODULE$.compressIfNeeded(r$1, this.compressionHandlers.compressors());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        GenericRequestBody body = (GenericRequestBody)tuple2._1();
        Option contentLength = (Option)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)body, (Object)contentLength);
        GenericRequestBody body2 = (GenericRequestBody)tuple22._1();
        Option contentLength2 = (Option)tuple22._2();
        HttpURLConnection c = this.openConnection(r$1.uri());
        c.setRequestMethod(r$1.method());
        r$1.headers().foreach((Function1)(JProcedure1 & Serializable)h -> {
            if (!h.is(HeaderNames$.MODULE$.ContentLength())) {
                c.setRequestProperty(h.name(), h.value());
                return;
            }
        });
        contentLength2.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)cl -> c.setRequestProperty(HeaderNames$.MODULE$.ContentLength(), BoxesRunTime.boxToLong((long)cl).toString()));
        c.setDoInput(true);
        c.setReadTimeout(this.timeout(r$1.options().readTimeout()));
        c.setConnectTimeout(this.timeout((Duration)this.opts.connectionTimeout()));
        c.setInstanceFollowRedirects(false);
        this.customizeConnection.apply((Object)c);
        GenericRequestBody genericRequestBody = r$1.body();
        NoBody$ noBody$ = NoBody$.MODULE$;
        if (genericRequestBody == null ? noBody$ != null : !genericRequestBody.equals(noBody$)) {
            c.setDoOutput(true);
            this.writeBody(body2, r$1, c).foreach((Function1)(JProcedure1 & Serializable)os -> {
                os.flush();
                os.close();
            });
        }
        try {
            InputStream is = c.getInputStream();
            InputStream limitedIs = (InputStream)r$1.options().maxResponseBodyLength().fold(() -> HttpURLConnectionBackend.$anonfun$1(is), (Function1 & Serializable)_$1 -> HttpURLConnectionBackend.$anonfun$2(is, BoxesRunTime.unboxToLong((Object)_$1)));
            response = this.readResponse(c, limitedIs, r$1);
        }
        catch (CharacterCodingException e) {
            throw e;
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (SocketException e) {
            throw e;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IOException && c.getResponseCode() != -1) {
                response = this.readResponse(c, c.getErrorStream(), r$1);
            }
            throw throwable;
        }
        return response;
    }

    private static final /* synthetic */ boolean $anonfun$3(BackendOptions.Proxy p$1, String _$2) {
        return !p$1.ignoreProxy(_$2);
    }

    private static final /* synthetic */ void $anonfun$4(BackendOptions.ProxyAuth proxyAuth) {
        Authenticator.setDefault(new Authenticator(proxyAuth){
            private final BackendOptions.ProxyAuth proxyAuth$1;
            {
                this.proxyAuth$1 = proxyAuth$2;
            }

            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(this.proxyAuth$1.username(), this.proxyAuth$1.password().toCharArray());
            }
        });
    }

    private final char $anonfun$5(ThreadLocalRandom tlr$1) {
        return this.BoundaryChars[tlr$1.nextInt(this.BoundaryChars.length)];
    }

    private static final String $anonfun$12() {
        return "multipart/form-data";
    }

    private static final void writeMeta$1(OutputStream os$1, LongRef total$1, String s) {
        byte[] utf8Bytes = s.getBytes(package$.MODULE$.Utf8());
        os$1.write(utf8Bytes);
        total$1.elem += (long)utf8Bytes.length;
    }
}

