/*
 * Decompiled with CFR 0.152.
 */
package sttp.client4.internal;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import sttp.client4.BasicBodyPart;
import sttp.client4.ByteArrayBody;
import sttp.client4.ByteArrayBody$;
import sttp.client4.ByteBufferBody;
import sttp.client4.ByteBufferBody$;
import sttp.client4.FileBody;
import sttp.client4.GenericRequest;
import sttp.client4.GenericRequestBody;
import sttp.client4.InputStreamBody;
import sttp.client4.InputStreamBody$;
import sttp.client4.Response;
import sttp.client4.StringBody;
import sttp.client4.StringBody$;
import sttp.client4.internal.DigestAuthenticator$;
import sttp.client4.internal.DigestAuthenticator$DigestAuthData$;
import sttp.client4.internal.MessageDigestCompatibility;
import sttp.client4.internal.WwwAuthHeaderParser$;
import sttp.client4.internal.WwwAuthHeaderValue;
import sttp.client4.internal.package$;
import sttp.model.Header;
import sttp.model.Header$;
import sttp.model.HeaderNames$;
import sttp.model.MediaType;

public class DigestAuthenticator {
    private final DigestAuthData digestAuthData;
    private final String requestHeaderName;
    private final String responseHeaderName;
    private final int unauthorizedStatusCode;
    private final Function0<String> clientNonceGenerator;

    public static String QualityOfProtectionAuth() {
        return DigestAuthenticator$.MODULE$.QualityOfProtectionAuth();
    }

    public static String QualityOfProtectionAuthInt() {
        return DigestAuthenticator$.MODULE$.QualityOfProtectionAuthInt();
    }

    public static DigestAuthenticator apply(DigestAuthData digestAuthData, Function0<String> function0) {
        return DigestAuthenticator$.MODULE$.apply(digestAuthData, function0);
    }

    public static String defaultClientNonceGenerator() {
        return DigestAuthenticator$.MODULE$.defaultClientNonceGenerator();
    }

    public static DigestAuthenticator proxy(DigestAuthData digestAuthData, Function0<String> function0) {
        return DigestAuthenticator$.MODULE$.proxy(digestAuthData, function0);
    }

    public static Function0<String> apply$default$2() {
        return DigestAuthenticator$.MODULE$.apply$default$2();
    }

    public static Function0<String> proxy$default$2() {
        return DigestAuthenticator$.MODULE$.proxy$default$2();
    }

    public DigestAuthenticator(DigestAuthData digestAuthData, String requestHeaderName, String responseHeaderName, int unauthorizedStatusCode, Function0<String> clientNonceGenerator) {
        this.digestAuthData = digestAuthData;
        this.requestHeaderName = requestHeaderName;
        this.responseHeaderName = responseHeaderName;
        this.unauthorizedStatusCode = unauthorizedStatusCode;
        this.clientNonceGenerator = clientNonceGenerator;
    }

    public <T> Option<Header> authenticate(GenericRequest<T, ?> request, Response<T> response) {
        return this.responseHeaderValue((Seq<String>)response.headers(this.requestHeaderName), request, response.code()).map((Function1 & Serializable)_$1 -> Header$.MODULE$.apply(this.responseHeaderName, _$1));
    }

    private Option<String> responseHeaderValue(Seq<String> authHeaderValues, GenericRequest<?, ?> request, int statusCode) {
        Seq<String> wwwAuthRawHeaders = authHeaderValues;
        return wwwAuthRawHeaders.find((Function1 & Serializable)_$2 -> _$2.contains("Digest")).flatMap((Function1 & Serializable)inputHeader -> {
            if (statusCode == this.unauthorizedStatusCode) {
                WwwAuthHeaderValue parsed = WwwAuthHeaderParser$.MODULE$.parse((String)inputHeader);
                return this.responseHeaderValue(request, this.digestAuthData, parsed, (String)parsed.realm().getOrElse(DigestAuthenticator::responseHeaderValue$$anonfun$2$$anonfun$1), (String)parsed.nonce().getOrElse(DigestAuthenticator::responseHeaderValue$$anonfun$2$$anonfun$2));
            }
            return None$.MODULE$;
        });
    }

    /*
     * Unable to fully structure code
     */
    private Option<String> responseHeaderValue(GenericRequest<?, ?> request, DigestAuthData digestAuthData, WwwAuthHeaderValue wwwAuthHeader, String realmMatch, String nonceMatch) {
        block4: {
            v0 = isFirstOrShouldRetry = request.headers().find((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$1(sttp.model.Header ), (Lsttp/model/Header;)Z)()).exists((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$2(sttp.model.Header ), (Lsttp/model/Header;)Z)()) != false ? BoxesRunTime.unboxToBoolean((Object)wwwAuthHeader.isStale().getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$3(), ()Z)())) : true;
            if (!isFirstOrShouldRetry) break block4;
            qualityOfProtection = wwwAuthHeader.qop();
            algorithm = (String)wwwAuthHeader.algorithm().getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$4(), ()Ljava/lang/String;)());
            messageDigest = new MessageDigestCompatibility(algorithm);
            var11_10 = Tuple2$.MODULE$.apply((Object)Option$.MODULE$.apply((Object)request.uri().toJavaUri().getPath()), (Object)Option$.MODULE$.apply((Object)request.uri().toJavaUri().getQuery()));
            if (var11_10 == null) ** GOTO lbl-1000
            var12_11 = (Option)var11_10._1();
            var13_12 = (Option)var11_10._2();
            if (!(var12_11 instanceof Some)) ** GOTO lbl-1000
            p = var14_13 = (String)((Some)var12_11).value();
            if (!(var13_12 instanceof Some)) ** GOTO lbl-1000
            q = (String)((Some)var13_12).value();
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(p.trim())) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(q.trim()))) {
                v1 = new StringBuilder(1).append(p).append("?").append(q).toString();
            } else lbl-1000:
            // 2 sources

            {
                p = var14_13;
                if (None$.MODULE$.equals(var13_12) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(p.trim()))) {
                    v1 = p;
                } else lbl-1000:
                // 3 sources

                {
                    v1 = "/";
                }
            }
            digestUri = v1;
            clientNonce = (String)this.clientNonceGenerator.apply();
            nonceCount = "00000001";
            responseChallenge = this.calculateResponseChallenge(request, digestAuthData, realmMatch, qualityOfProtection, nonceMatch, digestUri, clientNonce, nonceCount, messageDigest, algorithm);
            authHeaderValue = this.createAuthHeaderValue(digestAuthData, nonceMatch, realmMatch, qualityOfProtection, digestUri, clientNonce, responseChallenge, nonceCount, algorithm, wwwAuthHeader.opaque());
            return Some$.MODULE$.apply((Object)authHeaderValue);
        }
        return None$.MODULE$;
    }

    private String calculateResponseChallenge(GenericRequest<?, ?> request, DigestAuthData digestAuthData, String realm, Option<String> qop, String nonce, String digestUri, String clientNonce, String nonceCount, MessageDigestCompatibility messageDigest, String algorithm) {
        String ha1 = this.calculateHa1(digestAuthData, realm, messageDigest, algorithm, nonce, clientNonce);
        String ha2 = this.calculateHa2(request, qop, digestUri, messageDigest);
        return this.calculateChallenge(qop, nonce, clientNonce, nonceCount, messageDigest, ha1, ha2);
    }

    private <T> String calculateHa1(DigestAuthData digestAuthData, String realm, MessageDigestCompatibility messageDigest, String algorithm, String nonce, String cnonce) {
        String base = DigestAuthenticator$.MODULE$.sttp$client4$internal$DigestAuthenticator$$$md5HexString(new StringBuilder(2).append(digestAuthData.username()).append(":").append(realm).append(":").append(digestAuthData.password()).toString(), messageDigest);
        if (algorithm.equalsIgnoreCase("MD5-sess")) {
            return DigestAuthenticator$.MODULE$.sttp$client4$internal$DigestAuthenticator$$$md5HexString(new StringBuilder(2).append(base).append(":").append(nonce).append(":").append(cnonce).toString(), messageDigest);
        }
        return base;
    }

    private <T> String calculateChallenge(Option<String> qop, String nonce, String clientNonce, String nonceCount, MessageDigestCompatibility messageDigest, String ha1, String ha2) {
        block2: {
            String v;
            block3: {
                Option<String> option = qop;
                if (!(option instanceof Some)) break block2;
                String string = v = (String)((Some)option).value();
                String string2 = DigestAuthenticator$.MODULE$.QualityOfProtectionAuth();
                if (!(string == null ? string2 != null : !string.equals(string2))) break block3;
                String string3 = v;
                String string4 = DigestAuthenticator$.MODULE$.QualityOfProtectionAuthInt();
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block2;
            }
            return DigestAuthenticator$.MODULE$.sttp$client4$internal$DigestAuthenticator$$$md5HexString(new StringBuilder(5).append(ha1).append(":").append(nonce).append(":").append(nonceCount).append(":").append(clientNonce).append(":").append(v).append(":").append(ha2).toString(), messageDigest);
        }
        return DigestAuthenticator$.MODULE$.sttp$client4$internal$DigestAuthenticator$$$md5HexString(new StringBuilder(2).append(ha1).append(":").append(nonce).append(":").append(ha2).toString(), messageDigest);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String calculateHa2(GenericRequest<?, ?> request, Option<String> qop, String digestUri, MessageDigestCompatibility messageDigest) {
        Option<String> option = qop;
        if (option instanceof Some) {
            String string = DigestAuthenticator$.MODULE$.QualityOfProtectionAuth();
            Object object = ((Some)option).value();
            if (!(string != null ? !string.equals(object) : object != null)) {
                return DigestAuthenticator$.MODULE$.sttp$client4$internal$DigestAuthenticator$$$md5HexString(new StringBuilder(1).append(request.method()).append(":").append(digestUri).toString(), messageDigest);
            }
        }
        if (None$.MODULE$.equals(option)) {
            return DigestAuthenticator$.MODULE$.sttp$client4$internal$DigestAuthenticator$$$md5HexString(new StringBuilder(1).append(request.method()).append(":").append(digestUri).toString(), messageDigest);
        }
        if (!(option instanceof Some)) throw new MatchError(option);
        String string = (String)((Some)option).value();
        String string2 = DigestAuthenticator$.MODULE$.QualityOfProtectionAuthInt();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            byte[] byArray;
            GenericRequestBody<?> genericRequestBody = request.body();
            if (!(genericRequestBody instanceof BasicBodyPart)) throw new IllegalStateException("Qop auth-int cannot be used with a non-basic body");
            BasicBodyPart brb = (BasicBodyPart)genericRequestBody;
            BasicBodyPart basicBodyPart = brb;
            if (basicBodyPart instanceof StringBody) {
                StringBody stringBody = StringBody$.MODULE$.unapply((StringBody)basicBodyPart);
                String string4 = stringBody._1();
                String string5 = stringBody._2();
                MediaType mediaType = stringBody._3();
                String s = string4;
                String e = string5;
                byArray = s.getBytes(Charset.forName(e));
            } else if (basicBodyPart instanceof ByteArrayBody) {
                byte[] b;
                ByteArrayBody byteArrayBody = ByteArrayBody$.MODULE$.unapply((ByteArrayBody)basicBodyPart);
                byte[] byArray2 = byteArrayBody._1();
                MediaType mediaType = byteArrayBody._2();
                byArray = b = byArray2;
            } else if (basicBodyPart instanceof ByteBufferBody) {
                ByteBufferBody byteBufferBody = ByteBufferBody$.MODULE$.unapply((ByteBufferBody)basicBodyPart);
                ByteBuffer byteBuffer = byteBufferBody._1();
                MediaType mediaType = byteBufferBody._2();
                ByteBuffer b = byteBuffer;
                byArray = b.array();
            } else if (basicBodyPart instanceof InputStreamBody) {
                InputStreamBody inputStreamBody = InputStreamBody$.MODULE$.unapply((InputStreamBody)basicBodyPart);
                InputStream inputStream = inputStreamBody._1();
                MediaType mediaType = inputStreamBody._2();
                InputStream b = inputStream;
                byArray = package$.MODULE$.toByteArray(b);
            } else {
                if (!(basicBodyPart instanceof FileBody)) throw new MatchError((Object)basicBodyPart);
                throw new IllegalStateException("Qop auth-int cannot be used with a file body");
            }
            byte[] body = byArray;
            return DigestAuthenticator$.MODULE$.sttp$client4$internal$DigestAuthenticator$$$md5HexString(new StringBuilder(2).append(request.method()).append(":").append(digestUri).append(":").append(DigestAuthenticator$.MODULE$.sttp$client4$internal$DigestAuthenticator$$$byteArrayToHexString((Seq<Object>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)messageDigest.digest(body)))).toString(), messageDigest);
        }
        String q = string;
        throw new IllegalArgumentException(new StringBuilder(13).append("Unknown qop: ").append(q).toString());
    }

    private <T> String createAuthHeaderValue(DigestAuthData digestAuthData, String nonce, String realm, Option<String> qop, String digestUri, String clientNonce, String challenge, String nonceCount, String algorithm, Option<String> opaque) {
        Some digestOut = Some$.MODULE$.apply((Object)new StringBuilder(18).append("Digest username=\"").append(digestAuthData.username()).append("\"").toString());
        Some realmOut = Some$.MODULE$.apply((Object)new StringBuilder(8).append("realm=\"").append(realm).append("\"").toString());
        Some uriOut = Some$.MODULE$.apply((Object)new StringBuilder(6).append("uri=\"").append(digestUri).append("\"").toString());
        Some nonceOut = Some$.MODULE$.apply((Object)new StringBuilder(8).append("nonce=\"").append(nonce).append("\"").toString());
        Option qopOut = qop.map((Function1 & Serializable)q -> new StringBuilder(4).append("qop=").append((String)q).toString());
        Some nc = Some$.MODULE$.apply((Object)new StringBuilder(3).append("nc=").append(nonceCount).toString());
        Some challengeOut = Some$.MODULE$.apply((Object)new StringBuilder(11).append("response=\"").append(challenge).append("\"").toString());
        Some cnonceOut = Some$.MODULE$.apply((Object)new StringBuilder(9).append("cnonce=\"").append(clientNonce).append("\"").toString());
        Some algorithmOut = Some$.MODULE$.apply((Object)new StringBuilder(10).append("algorithm=").append(algorithm).toString());
        Option opaqueOut = opaque.map((Function1 & Serializable)op -> new StringBuilder(9).append("opaque=\"").append((String)op).append("\"").toString());
        String authHeaderValue = ((IterableOnceOps)((StrictOptimizedIterableOps)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{digestOut, realmOut, uriOut, nonceOut, qopOut, challengeOut, cnonceOut, nc, algorithmOut, opaqueOut}))).flatten(Predef$.MODULE$.$conforms())).mkString(", ");
        return authHeaderValue;
    }

    private static final String responseHeaderValue$$anonfun$2$$anonfun$1() {
        throw new IllegalArgumentException("Missing realm");
    }

    private static final String responseHeaderValue$$anonfun$2$$anonfun$2() {
        throw new IllegalArgumentException("Missing nonce");
    }

    private static final /* synthetic */ boolean $anonfun$1(Header _$3) {
        return _$3.name().equalsIgnoreCase(HeaderNames$.MODULE$.Authorization());
    }

    private static final /* synthetic */ boolean $anonfun$2(Header _$4) {
        return _$4.value().contains("Digest");
    }

    private static final boolean $anonfun$3() {
        return false;
    }

    private static final String $anonfun$4() {
        return "MD5";
    }

    public static class DigestAuthData
    implements Product,
    Serializable {
        private final String username;
        private final String password;

        public static DigestAuthData apply(String string, String string2) {
            return DigestAuthenticator$DigestAuthData$.MODULE$.apply(string, string2);
        }

        public static DigestAuthData fromProduct(Product product) {
            return DigestAuthenticator$DigestAuthData$.MODULE$.fromProduct(product);
        }

        public static DigestAuthData unapply(DigestAuthData digestAuthData) {
            return DigestAuthenticator$DigestAuthData$.MODULE$.unapply(digestAuthData);
        }

        public DigestAuthData(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DigestAuthData)) return false;
            DigestAuthData digestAuthData = (DigestAuthData)object;
            String string = this.username();
            String string2 = digestAuthData.username();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.password();
            String string4 = digestAuthData.password();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!digestAuthData.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DigestAuthData;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "DigestAuthData";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "username";
            }
            if (1 == n2) {
                return "password";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String username() {
            return this.username;
        }

        public String password() {
            return this.password;
        }

        public DigestAuthData copy(String username, String password) {
            return new DigestAuthData(username, password);
        }

        public String copy$default$1() {
            return this.username();
        }

        public String copy$default$2() {
            return this.password();
        }

        public String _1() {
            return this.username();
        }

        public String _2() {
            return this.password();
        }
    }
}

