/*
 * Decompiled with CFR 0.152.
 */
package sttp.client4.internal.httpclient;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.http.HttpRequest;
import java.nio.ByteBuffer;
import java.util.concurrent.Flow;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import sttp.capabilities.package;
import sttp.client4.ByteArrayBody;
import sttp.client4.ByteArrayBody$;
import sttp.client4.ByteBufferBody;
import sttp.client4.ByteBufferBody$;
import sttp.client4.FileBody;
import sttp.client4.FileBody$;
import sttp.client4.GenericRequest;
import sttp.client4.GenericRequestBody;
import sttp.client4.InputStreamBody;
import sttp.client4.InputStreamBody$;
import sttp.client4.MultipartBody;
import sttp.client4.NoBody$;
import sttp.client4.StreamBody;
import sttp.client4.StreamBody$;
import sttp.client4.StringBody;
import sttp.client4.StringBody$;
import sttp.client4.compression.Compressor;
import sttp.client4.compression.Compressor$;
import sttp.client4.httpclient.BodyProgressCallback;
import sttp.client4.httpclient.BodyProgressCallback$;
import sttp.client4.internal.SttpFile;
import sttp.client4.internal.SttpToJavaConverters$;
import sttp.client4.internal.httpclient.BodyToHttpClient$;
import sttp.client4.internal.httpclient.MultipartBodyBuilder;
import sttp.model.HeaderNames$;
import sttp.model.MediaType;
import sttp.monad.MonadError;
import sttp.monad.syntax;
import sttp.monad.syntax$;

public interface BodyToHttpClient<F, S, R> {
    public package.Streams<S> streams();

    public MonadError<F> monad();

    public static Object apply$(BodyToHttpClient $this, GenericRequest request, HttpRequest.Builder builder, Option contentType) {
        return $this.apply(request, builder, (Option<String>)contentType);
    }

    default public <T> F apply(GenericRequest<T, R> request, HttpRequest.Builder builder, Option<String> contentType) {
        Object object;
        Object object2;
        Tuple2<GenericRequestBody<R>, Option<Object>> tuple2 = Compressor$.MODULE$.compressIfNeeded(request, this.compressors());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        GenericRequestBody maybeCompressedBody = (GenericRequestBody)tuple2._1();
        Option contentLength = (Option)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)maybeCompressedBody, (Object)contentLength);
        GenericRequestBody maybeCompressedBody2 = (GenericRequestBody)tuple22._1();
        Option contentLength2 = (Option)tuple22._2();
        GenericRequestBody genericRequestBody = maybeCompressedBody2;
        if (NoBody$.MODULE$.equals(genericRequestBody)) {
            HttpRequest.BodyPublisher bodyPublisher = (HttpRequest.BodyPublisher)syntax$.MODULE$.MonadErrorValueOps((Object)HttpRequest.BodyPublishers.noBody());
            object2 = syntax.MonadErrorValueOps$.MODULE$.unit$extension((Object)bodyPublisher, this.monad());
        } else if (genericRequestBody instanceof StringBody) {
            StringBody stringBody = StringBody$.MODULE$.unapply((StringBody)genericRequestBody);
            String string = stringBody._1();
            String string2 = stringBody._2();
            MediaType mediaType = stringBody._3();
            String b2 = string;
            HttpRequest.BodyPublisher bodyPublisher = (HttpRequest.BodyPublisher)syntax$.MODULE$.MonadErrorValueOps((Object)HttpRequest.BodyPublishers.ofString(b2));
            object2 = syntax.MonadErrorValueOps$.MODULE$.unit$extension((Object)bodyPublisher, this.monad());
        } else if (genericRequestBody instanceof ByteArrayBody) {
            ByteArrayBody byteArrayBody = ByteArrayBody$.MODULE$.unapply((ByteArrayBody)genericRequestBody);
            byte[] byArray = byteArrayBody._1();
            MediaType mediaType = byteArrayBody._2();
            byte[] b3 = byArray;
            HttpRequest.BodyPublisher bodyPublisher = (HttpRequest.BodyPublisher)syntax$.MODULE$.MonadErrorValueOps((Object)HttpRequest.BodyPublishers.ofByteArray(b3));
            object2 = syntax.MonadErrorValueOps$.MODULE$.unit$extension((Object)bodyPublisher, this.monad());
        } else if (genericRequestBody instanceof ByteBufferBody) {
            ByteBufferBody byteBufferBody = ByteBufferBody$.MODULE$.unapply((ByteBufferBody)genericRequestBody);
            ByteBuffer byteBuffer = byteBufferBody._1();
            MediaType mediaType = byteBufferBody._2();
            ByteBuffer b4 = byteBuffer;
            if (b4.hasArray()) {
                HttpRequest.BodyPublisher bodyPublisher = (HttpRequest.BodyPublisher)syntax$.MODULE$.MonadErrorValueOps((Object)HttpRequest.BodyPublishers.ofByteArray(b4.array(), 0, b4.limit()));
                object2 = syntax.MonadErrorValueOps$.MODULE$.unit$extension((Object)bodyPublisher, this.monad());
            } else {
                byte[] a = new byte[b4.remaining()];
                b4.get(a);
                HttpRequest.BodyPublisher bodyPublisher = (HttpRequest.BodyPublisher)syntax$.MODULE$.MonadErrorValueOps((Object)HttpRequest.BodyPublishers.ofByteArray(a));
                object2 = syntax.MonadErrorValueOps$.MODULE$.unit$extension((Object)bodyPublisher, this.monad());
            }
        } else if (genericRequestBody instanceof InputStreamBody) {
            InputStreamBody inputStreamBody = InputStreamBody$.MODULE$.unapply((InputStreamBody)genericRequestBody);
            InputStream inputStream = inputStreamBody._1();
            MediaType mediaType = inputStreamBody._2();
            InputStream b5 = inputStream;
            HttpRequest.BodyPublisher bodyPublisher = (HttpRequest.BodyPublisher)syntax$.MODULE$.MonadErrorValueOps((Object)HttpRequest.BodyPublishers.ofInputStream(SttpToJavaConverters$.MODULE$.toJavaSupplier((Function0 & Serializable)() -> b5)));
            object2 = syntax.MonadErrorValueOps$.MODULE$.unit$extension((Object)bodyPublisher, this.monad());
        } else if (genericRequestBody instanceof FileBody) {
            FileBody fileBody = FileBody$.MODULE$.unapply((FileBody)genericRequestBody);
            SttpFile sttpFile = fileBody._1();
            MediaType mediaType = fileBody._2();
            SttpFile f = sttpFile;
            HttpRequest.BodyPublisher bodyPublisher = (HttpRequest.BodyPublisher)syntax$.MODULE$.MonadErrorValueOps((Object)HttpRequest.BodyPublishers.ofFile(f.toFile().toPath()));
            object2 = syntax.MonadErrorValueOps$.MODULE$.unit$extension((Object)bodyPublisher, this.monad());
        } else if (genericRequestBody instanceof StreamBody) {
            Object BinaryStream;
            StreamBody streamBody = StreamBody$.MODULE$.unapply((StreamBody)genericRequestBody);
            Object s = BinaryStream = streamBody._1();
            object2 = this.streamToPublisher(s);
        } else if (genericRequestBody instanceof MultipartBody) {
            MultipartBody m = (MultipartBody)genericRequestBody;
            String baseContentType = (String)contentType.getOrElse(BodyToHttpClient::$anonfun$2);
            Tuple2<F, String> tuple23 = this.multiPartBodyBuilder().apply(m.parts(), this.monad());
            if (tuple23 == null) {
                throw new MatchError(tuple23);
            }
            Object body = tuple23._1();
            String boundary = (String)tuple23._2();
            Tuple2 tuple24 = Tuple2$.MODULE$.apply(body, (Object)boundary);
            Object body2 = tuple24._1();
            String boundary2 = (String)tuple24._2();
            builder.header(HeaderNames$.MODULE$.ContentType(), new StringBuilder(11).append(baseContentType).append("; boundary=").append(boundary2).toString());
            object2 = body2;
        } else {
            throw new MatchError((Object)genericRequestBody);
        }
        Object body = object2;
        Option option = contentLength2;
        if (None$.MODULE$.equals(option)) {
            object = body;
        } else if (option instanceof Some) {
            long cl = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            object = syntax$.MODULE$.MonadErrorOps(() -> BodyToHttpClient.$anonfun$3(body)).map((Function1 & Serializable)b -> this.withKnownContentLength((HttpRequest.BodyPublisher)b, cl), this.monad());
        } else {
            throw new MatchError((Object)option);
        }
        Object bodyWithContentLength = object;
        Option<BodyProgressCallback> option2 = request.attribute(BodyProgressCallback$.MODULE$.RequestAttribute());
        if (None$.MODULE$.equals(option2)) {
            return (F)bodyWithContentLength;
        }
        if (option2 instanceof Some) {
            BodyProgressCallback callback = (BodyProgressCallback)((Some)option2).value();
            return (F)syntax$.MODULE$.MonadErrorOps(() -> BodyToHttpClient.apply$$anonfun$1(bodyWithContentLength)).map((Function1 & Serializable)_$2 -> this.withCallback((HttpRequest.BodyPublisher)_$2, callback), this.monad());
        }
        throw new MatchError(option2);
    }

    public MultipartBodyBuilder<Object, F> multiPartBodyBuilder();

    public F streamToPublisher(Object var1);

    public List<Compressor<R>> compressors();

    private HttpRequest.BodyPublisher withKnownContentLength(HttpRequest.BodyPublisher delegate, long cl) {
        return new HttpRequest.BodyPublisher(cl, delegate){
            private final long cl$2;
            private final HttpRequest.BodyPublisher delegate$1;
            {
                this.cl$2 = cl$3;
                this.delegate$1 = delegate$3;
            }

            public long contentLength() {
                return this.cl$2;
            }

            public void subscribe(Flow.Subscriber subscriber) {
                this.delegate$1.subscribe(subscriber);
            }
        };
    }

    private HttpRequest.BodyPublisher withCallback(HttpRequest.BodyPublisher delegate, BodyProgressCallback callback) {
        return new HttpRequest.BodyPublisher(delegate, callback){
            private final HttpRequest.BodyPublisher delegate$2;
            public final BodyProgressCallback sttp$client4$internal$httpclient$BodyToHttpClient$$anon$2$$callback$2;
            {
                this.delegate$2 = delegate$4;
                this.sttp$client4$internal$httpclient$BodyToHttpClient$$anon$2$$callback$2 = callback$3;
            }

            public long contentLength() {
                return this.delegate$2.contentLength();
            }

            public void subscribe(Flow.Subscriber subscriber) {
                this.delegate$2.subscribe(new Flow.Subscriber<ByteBuffer>(subscriber, this){
                    private final Flow.Subscriber subscriber$1;
                    private final /* synthetic */ $anon$2 $outer;
                    {
                        this.subscriber$1 = subscriber$2;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public void onSubscribe(Flow.Subscription subscription) {
                        this.runCallbackSafe((Function0 & Serializable)() -> {
                            this.onSubscribe$$anonfun$1();
                            return BoxedUnit.UNIT;
                        });
                        this.subscriber$1.onSubscribe(subscription);
                    }

                    public void onNext(ByteBuffer item) {
                        this.runCallbackSafe(() -> this.$outer.sttp$client4$internal$httpclient$BodyToHttpClient$$anon$2$$anon$3$$_$onNext$$anonfun$adapted$1(item));
                        this.subscriber$1.onNext(item);
                    }

                    public void onComplete() {
                        this.runCallbackSafe(this.$outer::sttp$client4$internal$httpclient$BodyToHttpClient$$anon$2$$anon$3$$_$onComplete$$anonfun$adapted$1);
                        this.subscriber$1.onComplete();
                    }

                    public void onError(Throwable throwable) {
                        this.runCallbackSafe(() -> this.$outer.sttp$client4$internal$httpclient$BodyToHttpClient$$anon$2$$anon$3$$_$onError$$anonfun$adapted$1(throwable));
                        this.subscriber$1.onError(throwable);
                    }

                    private void runCallbackSafe(Function0 f) {
                        try {
                            f.apply$mcV$sp();
                        }
                        catch (Exception e) {
                            System.getLogger(this.getClass().getName()).log(System.Logger.Level.ERROR, "Error in callback", (Throwable)e);
                        }
                    }

                    private final void onSubscribe$$anonfun$1() {
                        long cl = this.$outer.contentLength();
                        this.$outer.sttp$client4$internal$httpclient$BodyToHttpClient$$anon$2$$callback$2.onInit((Option<Object>)(cl < 0L ? None$.MODULE$ : Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)cl))));
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{onSubscribe$$anonfun$adapted$1(), sttp$client4$internal$httpclient$BodyToHttpClient$$anon$2$$anon$3$$_$onNext$$anonfun$adapted$1(java.nio.ByteBuffer ), sttp$client4$internal$httpclient$BodyToHttpClient$$anon$2$$anon$3$$_$onComplete$$anonfun$adapted$1(), sttp$client4$internal$httpclient$BodyToHttpClient$$anon$2$$anon$3$$_$onError$$anonfun$adapted$1(java.lang.Throwable )}, serializedLambda);
                    }
                });
            }

            private final void onNext$$anonfun$1(ByteBuffer item$1) {
                this.sttp$client4$internal$httpclient$BodyToHttpClient$$anon$2$$callback$2.onNext(Int$.MODULE$.int2long(item$1.remaining()));
            }

            private final void onComplete$$anonfun$1() {
                this.sttp$client4$internal$httpclient$BodyToHttpClient$$anon$2$$callback$2.onComplete();
            }

            private final void onError$$anonfun$1(Throwable throwable$1) {
                this.sttp$client4$internal$httpclient$BodyToHttpClient$$anon$2$$callback$2.onError(throwable$1);
            }
        };
    }

    private static String $anonfun$2() {
        return "multipart/form-data";
    }

    private static Object $anonfun$3(Object body$1) {
        return body$1;
    }

    private static Object apply$$anonfun$1(Object bodyWithContentLength$1) {
        return bodyWithContentLength$1;
    }
}

