/*
 * Decompiled with CFR 0.152.
 */
package sttp.client4.logging;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import sttp.client4.Backend;
import sttp.client4.GenericBackend;
import sttp.client4.GenericRequest;
import sttp.client4.Request;
import sttp.client4.Response;
import sttp.client4.ResponseAs;
import sttp.client4.ResponseException;
import sttp.client4.ResponseException$;
import sttp.client4.StreamBackend;
import sttp.client4.StreamRequest;
import sttp.client4.StreamResponseAs;
import sttp.client4.SyncBackend;
import sttp.client4.WebSocketBackend;
import sttp.client4.WebSocketStreamBackend;
import sttp.client4.WebSocketSyncBackend;
import sttp.client4.logging.Log;
import sttp.client4.logging.LogConfig;
import sttp.client4.logging.Logger;
import sttp.client4.logging.LoggingBackend$;
import sttp.client4.logging.LoggingBackend$LoggingTag$;
import sttp.client4.logging.ResponseTimings;
import sttp.client4.logging.ResponseTimings$;
import sttp.client4.package$;
import sttp.client4.wrappers.DelegateBackend;
import sttp.model.ResponseMetadata;
import sttp.monad.MonadError;
import sttp.monad.syntax$;

public class LoggingBackend<F, P>
extends DelegateBackend<F, P> {
    private final GenericBackend<F, P> delegate;
    public final Log<F> sttp$client4$logging$LoggingBackend$$log;
    private final boolean logResponseBody;
    private final boolean includeTimings;

    public static <F> Backend<F> apply(Backend<F> backend, Log<F> log, boolean bl, boolean bl2) {
        return LoggingBackend$.MODULE$.apply(backend, log, bl, bl2);
    }

    public static <F> Backend<F> apply(Backend<F> backend, Logger<F> logger) {
        return LoggingBackend$.MODULE$.apply(backend, logger);
    }

    public static <F> Backend<F> apply(Backend<F> backend, Logger<F> logger, LogConfig logConfig) {
        return LoggingBackend$.MODULE$.apply(backend, logger, logConfig);
    }

    public static <F, S> StreamBackend<F, S> apply(StreamBackend<F, S> streamBackend, Log<F> log, boolean bl, boolean bl2) {
        return LoggingBackend$.MODULE$.apply(streamBackend, log, bl, bl2);
    }

    public static <F, S> StreamBackend<F, S> apply(StreamBackend<F, S> streamBackend, Logger<F> logger) {
        return LoggingBackend$.MODULE$.apply(streamBackend, logger);
    }

    public static <F, S> StreamBackend<F, S> apply(StreamBackend<F, S> streamBackend, Logger<F> logger, LogConfig logConfig) {
        return LoggingBackend$.MODULE$.apply(streamBackend, logger, logConfig);
    }

    public static SyncBackend apply(SyncBackend syncBackend, Log<Object> log, boolean bl, boolean bl2) {
        return LoggingBackend$.MODULE$.apply(syncBackend, log, bl, bl2);
    }

    public static SyncBackend apply(SyncBackend syncBackend, Logger<Object> logger) {
        return LoggingBackend$.MODULE$.apply(syncBackend, logger);
    }

    public static SyncBackend apply(SyncBackend syncBackend, Logger<Object> logger, LogConfig logConfig) {
        return LoggingBackend$.MODULE$.apply(syncBackend, logger, logConfig);
    }

    public static <F> WebSocketBackend<F> apply(WebSocketBackend<F> webSocketBackend, Log<F> log, boolean bl, boolean bl2) {
        return LoggingBackend$.MODULE$.apply(webSocketBackend, log, bl, bl2);
    }

    public static <F> WebSocketBackend<F> apply(WebSocketBackend<F> webSocketBackend, Logger<F> logger) {
        return LoggingBackend$.MODULE$.apply(webSocketBackend, logger);
    }

    public static <F> WebSocketBackend<F> apply(WebSocketBackend<F> webSocketBackend, Logger<F> logger, LogConfig logConfig) {
        return LoggingBackend$.MODULE$.apply(webSocketBackend, logger, logConfig);
    }

    public static <F, S> WebSocketStreamBackend<F, S> apply(WebSocketStreamBackend<F, S> webSocketStreamBackend, Log<F> log, boolean bl, boolean bl2) {
        return LoggingBackend$.MODULE$.apply(webSocketStreamBackend, log, bl, bl2);
    }

    public static <F, S> WebSocketStreamBackend<F, S> apply(WebSocketStreamBackend<F, S> webSocketStreamBackend, Logger<F> logger) {
        return LoggingBackend$.MODULE$.apply(webSocketStreamBackend, logger);
    }

    public static <F, S> WebSocketStreamBackend<F, S> apply(WebSocketStreamBackend<F, S> webSocketStreamBackend, Logger<F> logger, LogConfig logConfig) {
        return LoggingBackend$.MODULE$.apply(webSocketStreamBackend, logger, logConfig);
    }

    public static WebSocketSyncBackend apply(WebSocketSyncBackend webSocketSyncBackend, Log<Object> log, boolean bl, boolean bl2) {
        return LoggingBackend$.MODULE$.apply(webSocketSyncBackend, log, bl, bl2);
    }

    public static WebSocketSyncBackend apply(WebSocketSyncBackend webSocketSyncBackend, Logger<Object> logger) {
        return LoggingBackend$.MODULE$.apply(webSocketSyncBackend, logger);
    }

    public static WebSocketSyncBackend apply(WebSocketSyncBackend webSocketSyncBackend, Logger<Object> logger, LogConfig logConfig) {
        return LoggingBackend$.MODULE$.apply(webSocketSyncBackend, logger, logConfig);
    }

    public LoggingBackend(GenericBackend<F, P> delegate, Log<F> log, boolean logResponseBody, boolean includeTimings) {
        this.delegate = delegate;
        this.sttp$client4$logging$LoggingBackend$$log = log;
        this.logResponseBody = logResponseBody;
        this.includeTimings = includeTimings;
        super(delegate);
    }

    @Override
    public <T> F send(GenericRequest<T, P> request) {
        if (request.loggingOptions().log()) {
            return (F)syntax$.MODULE$.MonadErrorOps(() -> this.send$$anonfun$1(request)).flatMap((Function1 & Serializable)_$2 -> {
                Tuple2 tuple2;
                boolean _includeTimings = BoxesRunTime.unboxToBoolean((Object)request.loggingOptions().includeTimings().getOrElse(this::$anonfun$1));
                if (_includeTimings) {
                    LoggingTag t = LoggingBackend$LoggingTag$.MODULE$.apply(this.now(), new AtomicLong(0L));
                    tuple2 = Tuple2$.MODULE$.apply(request.onBodyReceived((Function1<ResponseMetadata, BoxedUnit>)(JProcedure1 & Serializable)_$3 -> t.bodyReceived().set(this.now())), (Object)Some$.MODULE$.apply((Object)t));
                } else {
                    tuple2 = Tuple2$.MODULE$.apply((Object)request, (Object)None$.MODULE$);
                }
                Tuple2 tuple22 = tuple2;
                GenericRequest requestWithTimings = (GenericRequest)tuple22._1();
                Option tag = (Option)tuple22._2();
                return this.monad().handleError(() -> this.send$$anonfun$2$$anonfun$1(request, requestWithTimings, tag), (PartialFunction)new Serializable(request, tag, this){
                    private final GenericRequest request$4;
                    private final Option tag$2;
                    private final /* synthetic */ LoggingBackend $outer;
                    {
                        this.request$4 = request$14;
                        this.tag$2 = tag$10;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public final boolean isDefinedAt(Throwable x) {
                        Throwable throwable = x;
                        if (throwable instanceof Exception) {
                            Exception e = (Exception)throwable;
                            return true;
                        }
                        return false;
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Throwable throwable = x;
                        if (throwable instanceof Exception) {
                            F f;
                            Exception e = (Exception)throwable;
                            MonadError<F> monadError = this.$outer.monad();
                            Option<ResponseException<?>> option = ResponseException$.MODULE$.find(e);
                            if (option instanceof Some) {
                                ResponseException re = (ResponseException)((Some)option).value();
                                f = this.$outer.sttp$client4$logging$LoggingBackend$$log.response(this.request$4, re.response(), (Option<String>)None$.MODULE$, (Option<ResponseTimings>)this.tag$2.map((Function1 & Serializable)tag -> this.$outer.sttp$client4$logging$LoggingBackend$$toResponseTimings((LoggingTag)tag)), (Option<ResponseException<?>>)Some$.MODULE$.apply((Object)re));
                            } else if (None$.MODULE$.equals(option)) {
                                f = this.$outer.sttp$client4$logging$LoggingBackend$$log.requestException(this.request$4, (Option<Duration>)this.tag$2.map((Function1 & Serializable)tag -> this.$outer.sttp$client4$logging$LoggingBackend$$toResponseTimings((LoggingTag)tag)).map(LoggingBackend::sttp$client4$logging$LoggingBackend$$anon$1$$_$applyOrElse$$anonfun$3), e);
                            } else {
                                throw new MatchError(option);
                            }
                            return monadError.flatMap(f, (Function1 & Serializable)_$5 -> this.$outer.monad().error((Throwable)e));
                        }
                        return function1.apply((Object)x);
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(sttp.client4.logging.LoggingBackend$LoggingTag ), applyOrElse$$anonfun$2(sttp.client4.logging.LoggingBackend$LoggingTag ), sttp$client4$logging$LoggingBackend$$anon$1$$_$applyOrElse$$anonfun$3(sttp.client4.logging.ResponseTimings ), applyOrElse$$anonfun$4(java.lang.Exception scala.runtime.BoxedUnit )}, serializedLambda);
                    }
                });
            }, this.monad());
        }
        return this.delegate.send(request);
    }

    private <T> F sendDoNotLogResponseBody(GenericRequest<T, P> request, Option<LoggingTag> tag) {
        return (F)syntax$.MODULE$.MonadErrorOps(() -> this.sendDoNotLogResponseBody$$anonfun$1(request)).flatMap((Function1 & Serializable)r -> syntax$.MODULE$.MonadErrorOps(() -> this.sendDoNotLogResponseBody$$anonfun$2$$anonfun$1(request, r, tag)).map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return r;
        }, this.monad()), this.monad());
    }

    private <T> F sendLogResponseBody(GenericRequest<T, P> request, Option<LoggingTag> tag) {
        GenericRequest genericRequest = request;
        if (genericRequest instanceof Request) {
            Request request2 = (Request)genericRequest;
            return (F)this.sendAndLog$1(tag, request2.response(package$.MODULE$.asBothOption((ResponseAs)request2.response(), package$.MODULE$.asStringAlways())));
        }
        if (genericRequest instanceof StreamRequest) {
            StreamRequest request3 = (StreamRequest)genericRequest;
            return (F)this.sendAndLog$1(tag, request3.response(package$.MODULE$.asBothOption((StreamResponseAs)request3.response(), package$.MODULE$.asStringAlways())));
        }
        GenericRequest request4 = genericRequest;
        return (F)syntax$.MODULE$.MonadErrorOps(() -> this.sendLogResponseBody$$anonfun$1(request4)).flatMap((Function1 & Serializable)r -> syntax$.MODULE$.MonadErrorOps(() -> this.sendLogResponseBody$$anonfun$2$$anonfun$1(request4, r, tag)).map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return r;
        }, this.monad()), this.monad());
    }

    private long now() {
        return System.currentTimeMillis();
    }

    private Duration elapsed(long from) {
        return Duration$.MODULE$.apply(this.now() - from, TimeUnit.MILLISECONDS);
    }

    public ResponseTimings sttp$client4$logging$LoggingBackend$$toResponseTimings(LoggingTag tag) {
        long br = tag.bodyReceived().get();
        return ResponseTimings$.MODULE$.apply((Option<Duration>)(br == 0L ? None$.MODULE$ : Some$.MODULE$.apply((Object)this.elapsed(br))), this.elapsed(tag.start()));
    }

    private final Object send$$anonfun$1(GenericRequest request$1) {
        return this.sttp$client4$logging$LoggingBackend$$log.beforeRequestSend(request$1);
    }

    private final boolean $anonfun$1() {
        return this.includeTimings;
    }

    private final boolean $anonfun$3() {
        return this.logResponseBody;
    }

    private final Object send$$anonfun$2$$anonfun$1(GenericRequest request$3, GenericRequest requestWithTimings$1, Option tag$1) {
        boolean _logResponseBody = BoxesRunTime.unboxToBoolean((Object)request$3.loggingOptions().logResponseBody().getOrElse(this::$anonfun$3));
        if (_logResponseBody) {
            return this.sendLogResponseBody(requestWithTimings$1, (Option<LoggingTag>)tag$1);
        }
        return this.sendDoNotLogResponseBody(requestWithTimings$1, (Option<LoggingTag>)tag$1);
    }

    public static final /* synthetic */ Duration sttp$client4$logging$LoggingBackend$$anon$1$$_$applyOrElse$$anonfun$3(ResponseTimings _$4) {
        return _$4.bodyHandled();
    }

    private final Object sendDoNotLogResponseBody$$anonfun$1(GenericRequest request$5) {
        return this.delegate.send(request$5);
    }

    private final Object sendDoNotLogResponseBody$$anonfun$2$$anonfun$1(GenericRequest request$7, Response r$1, Option tag$4) {
        return this.sttp$client4$logging$LoggingBackend$$log.response(request$7, r$1, (Option<String>)None$.MODULE$, (Option<ResponseTimings>)tag$4.map((Function1 & Serializable)tag -> this.sttp$client4$logging$LoggingBackend$$toResponseTimings((LoggingTag)tag)), (Option<ResponseException<?>>)None$.MODULE$);
    }

    private final Object sendAndLog$1$$anonfun$1(GenericRequest request$8) {
        return this.delegate.send(request$8);
    }

    private final Object sendAndLog$1$$anonfun$2$$anonfun$1(GenericRequest request$10, Response r$3, Option tag$6) {
        return this.sttp$client4$logging$LoggingBackend$$log.response(request$10, r$3, (Option<String>)((Option)((Tuple2)r$3.body())._2()), (Option<ResponseTimings>)tag$6.map((Function1 & Serializable)tag -> this.sttp$client4$logging$LoggingBackend$$toResponseTimings((LoggingTag)tag)), (Option<ResponseException<?>>)None$.MODULE$);
    }

    private final Object sendAndLog$1(Option tag$7, GenericRequest request) {
        return syntax$.MODULE$.MonadErrorOps(() -> this.sendAndLog$1$$anonfun$1(request)).flatMap((Function1 & Serializable)r -> syntax$.MODULE$.MonadErrorOps(() -> this.sendAndLog$1$$anonfun$2$$anonfun$1(request, r, tag$7)).map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return r.copy(((Tuple2)r.body())._1(), r.copy$default$2(), r.copy$default$3(), r.copy$default$4(), r.copy$default$5(), r.copy$default$6());
        }, this.monad()), this.monad());
    }

    private final Object sendLogResponseBody$$anonfun$1(GenericRequest request$11) {
        return this.delegate.send(request$11);
    }

    private final Object sendLogResponseBody$$anonfun$2$$anonfun$1(GenericRequest request$13, Response r$5, Option tag$9) {
        return this.sttp$client4$logging$LoggingBackend$$log.response(request$13, r$5, (Option<String>)None$.MODULE$, (Option<ResponseTimings>)tag$9.map((Function1 & Serializable)tag -> this.sttp$client4$logging$LoggingBackend$$toResponseTimings((LoggingTag)tag)), (Option<ResponseException<?>>)None$.MODULE$);
    }

    public static class LoggingTag
    implements Product,
    Serializable {
        private final long start;
        private final AtomicLong bodyReceived;

        public static LoggingTag apply(long l, AtomicLong atomicLong) {
            return LoggingBackend$LoggingTag$.MODULE$.apply(l, atomicLong);
        }

        public static LoggingTag fromProduct(Product product) {
            return LoggingBackend$LoggingTag$.MODULE$.fromProduct(product);
        }

        public static LoggingTag unapply(LoggingTag loggingTag) {
            return LoggingBackend$LoggingTag$.MODULE$.unapply(loggingTag);
        }

        public LoggingTag(long start, AtomicLong bodyReceived) {
            this.start = start;
            this.bodyReceived = bodyReceived;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.start()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.bodyReceived()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LoggingTag)) return false;
            LoggingTag loggingTag = (LoggingTag)object;
            if (this.start() != loggingTag.start()) return false;
            if (!BoxesRunTime.equals((Object)this.bodyReceived(), (Object)loggingTag.bodyReceived())) return false;
            if (!loggingTag.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof LoggingTag;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "LoggingTag";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToLong((long)this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "start";
            }
            if (1 == n2) {
                return "bodyReceived";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long start() {
            return this.start;
        }

        public AtomicLong bodyReceived() {
            return this.bodyReceived;
        }

        public LoggingTag copy(long start, AtomicLong bodyReceived) {
            return new LoggingTag(start, bodyReceived);
        }

        public long copy$default$1() {
            return this.start();
        }

        public AtomicLong copy$default$2() {
            return this.bodyReceived();
        }

        public long _1() {
            return this.start();
        }

        public AtomicLong _2() {
            return this.bodyReceived();
        }
    }
}

