// Generated by delombok at Fri Apr 19 18:23:12 UTC 2024
/*
 * Matomo Java Tracker
 *
 * @link https://github.com/matomo/matomo-java-tracker
 * @license https://github.com/matomo/matomo-java-tracker/blob/master/LICENSE BSD-3 Clause
 */
package org.matomo.java.tracking.parameters;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Locale.LanguageRange;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * Describes the content for the Accept-Language header field that can be overridden by a custom parameter. The format
 * is specified in the corresponding <a href="https://tools.ietf.org/html/rfc4647">RFC 4647 Matching of Language Tags</a>
 *
 * <p>Example: "en-US,en;q=0.8,de;q=0.6"
 */
public final class AcceptLanguage {
  private final List<LanguageRange> languageRanges;

  /**
   * Creates the Accept-Language definition for a given header.
   *
   * <p>Please see {@link LanguageRange#parse(String)} for more information. Example: "en-US,en;q=0.8,de;q=0.6"
   *
   * @param header A header that can be null
   * @return The parsed header (probably reformatted). null if the header is null.
   * @see LanguageRange#parse(String)
   */
  @Nullable
  public static AcceptLanguage fromHeader(@Nullable String header) {
    if (header == null || header.trim().isEmpty()) {
      return null;
    }
    return new AcceptLanguage(LanguageRange.parse(header));
  }

  /**
   * Returns the Accept Language header value.
   *
   * @return The header value, e.g. "en-US,en;q=0.8,de;q=0.6"
   */
  @NonNull
  public String toString() {
    return languageRanges.stream().filter(Objects::nonNull).map(AcceptLanguage::format).collect(Collectors.joining(","));
  }

  private static String format(@NonNull LanguageRange languageRange) {
    return languageRange.getWeight() == LanguageRange.MAX_WEIGHT ? languageRange.getRange() : String.format("%s;q=%s", languageRange.getRange(), languageRange.getWeight());
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  AcceptLanguage(final List<LanguageRange> languageRanges) {
    this.languageRanges = languageRanges;
  }


  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static class AcceptLanguageBuilder {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private java.util.ArrayList<LanguageRange> languageRanges;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    AcceptLanguageBuilder() {
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AcceptLanguage.AcceptLanguageBuilder languageRange(final LanguageRange languageRange) {
      if (this.languageRanges == null) this.languageRanges = new java.util.ArrayList<LanguageRange>();
      this.languageRanges.add(languageRange);
      return this;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AcceptLanguage.AcceptLanguageBuilder languageRanges(final java.util.Collection<? extends LanguageRange> languageRanges) {
      if (languageRanges == null) {
        throw new java.lang.NullPointerException("languageRanges cannot be null");
      }
      if (this.languageRanges == null) this.languageRanges = new java.util.ArrayList<LanguageRange>();
      this.languageRanges.addAll(languageRanges);
      return this;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AcceptLanguage.AcceptLanguageBuilder clearLanguageRanges() {
      if (this.languageRanges != null) this.languageRanges.clear();
      return this;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AcceptLanguage build() {
      java.util.List<LanguageRange> languageRanges;
      switch (this.languageRanges == null ? 0 : this.languageRanges.size()) {
      case 0: 
        languageRanges = java.util.Collections.emptyList();
        break;
      case 1: 
        languageRanges = java.util.Collections.singletonList(this.languageRanges.get(0));
        break;
      default: 
        languageRanges = java.util.Collections.unmodifiableList(new java.util.ArrayList<LanguageRange>(this.languageRanges));
      }
      return new AcceptLanguage(languageRanges);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
      return "AcceptLanguage.AcceptLanguageBuilder(languageRanges=" + this.languageRanges + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static AcceptLanguage.AcceptLanguageBuilder builder() {
    return new AcceptLanguage.AcceptLanguageBuilder();
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<LanguageRange> getLanguageRanges() {
    return this.languageRanges;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof AcceptLanguage)) return false;
    final AcceptLanguage other = (AcceptLanguage) o;
    final java.lang.Object this$languageRanges = this.getLanguageRanges();
    final java.lang.Object other$languageRanges = other.getLanguageRanges();
    if (this$languageRanges == null ? other$languageRanges != null : !this$languageRanges.equals(other$languageRanges)) return false;
    return true;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $languageRanges = this.getLanguageRanges();
    result = result * PRIME + ($languageRanges == null ? 43 : $languageRanges.hashCode());
    return result;
  }
}
